/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.DeviceProductInfo;
import android.hardware.display.DisplayedContentSample;
import android.hardware.display.DisplayedContentSamplingAttributes;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.InputWindowHandle;
import android.view.Surface;
import android.view.SurfaceControl_Delegate;
import android.view.SurfaceSession;
import android.view.View;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Objects;
import libcore.util.NativeAllocationRegistry;

public class SurfaceControl
implements Parcelable {
    private static final String TAG = "SurfaceControl";
    @GuardedBy(value={"mLock"})
    private ArrayList<OnReparentListener> mReparentListeners;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private String mName;
    public long mNativeObject;
    private long mNativeHandle;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private int mWidth;
    @GuardedBy(value={"mLock"})
    private int mHeight;
    private WeakReference<View> mLocalOwnerView;
    static Transaction sGlobalTransaction;
    static long sTransactionNestCount;
    @UnsupportedAppUsage
    public static final int HIDDEN = 4;
    public static final int SECURE = 128;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int PROTECTED_APP = 2048;
    public static final int CURSOR_WINDOW = 8192;
    public static final int NO_COLOR_FILL = 16384;
    public static final int FX_SURFACE_NORMAL = 0;
    public static final int FX_SURFACE_EFFECT = 131072;
    public static final int FX_SURFACE_CONTAINER = 524288;
    public static final int FX_SURFACE_BLAST = 262144;
    public static final int FX_SURFACE_MASK = 983040;
    private static final int SURFACE_HIDDEN = 1;
    private static final int SURFACE_OPAQUE = 2;
    public static final int POWER_MODE_OFF = 0;
    public static final int POWER_MODE_DOZE = 1;
    public static final int POWER_MODE_NORMAL = 2;
    public static final int POWER_MODE_DOZE_SUSPEND = 3;
    public static final int POWER_MODE_ON_SUSPEND = 4;
    public static final int WINDOW_TYPE_DONT_SCREENSHOT = 441731;
    private static final int INTERNAL_DATASPACE_SRGB = 0x8810000;
    private static final int INTERNAL_DATASPACE_DISPLAY_P3 = 0x88A0000;
    private static final int INTERNAL_DATASPACE_SCRGB = 0x18810000;
    public static final int METADATA_OWNER_UID = 1;
    public static final int METADATA_WINDOW_TYPE = 2;
    public static final int METADATA_TASK_ID = 3;
    public static final int METADATA_MOUSE_CURSOR = 4;
    public static final int METADATA_ACCESSIBILITY_ID = 5;
    public static final Parcelable.Creator<SurfaceControl> CREATOR;

    private static long nativeCreate(SurfaceSession surfaceSession, String string2, int n, int n2, int n3, int n4, long l, Parcel parcel) throws Surface.OutOfResourcesException {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCreate(Landroid/view/SurfaceSession;Ljava/lang/String;IIIIJLandroid/os/Parcel;)J", true, null);
    }

    private static long nativeReadFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeReadFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static long nativeCopyFromSurfaceControl(long l) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCopyFromSurfaceControl(J)J", true, null);
    }

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeWriteToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static void nativeRelease(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeRelease(J)V", true, null);
    }

    private static void nativeDisconnect(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDisconnect(J)V", true, null);
    }

    private static ScreenshotGraphicBuffer nativeScreenshot(IBinder iBinder, Rect rect, int n, int n2, boolean bl, int n3, boolean bl2) {
        return (ScreenshotGraphicBuffer)OverrideMethod.invokeA("android.view.SurfaceControl#nativeScreenshot(Landroid/os/IBinder;Landroid/graphics/Rect;IIZIZ)Landroid/view/SurfaceControl$ScreenshotGraphicBuffer;", true, null);
    }

    private static ScreenshotGraphicBuffer nativeCaptureLayers(IBinder iBinder, long l, Rect rect, float f, long[] lArray, int n) {
        return (ScreenshotGraphicBuffer)OverrideMethod.invokeA("android.view.SurfaceControl#nativeCaptureLayers(Landroid/os/IBinder;JLandroid/graphics/Rect;F[JI)Landroid/view/SurfaceControl$ScreenshotGraphicBuffer;", true, null);
    }

    private static long nativeMirrorSurface(long l) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeMirrorSurface(J)J", true, null);
    }

    @LayoutlibDelegate
    private static long nativeCreateTransaction() {
        return SurfaceControl_Delegate.nativeCreateTransaction();
    }

    private static long nativeGetNativeTransactionFinalizer() {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeGetNativeTransactionFinalizer()J", true, null);
    }

    private static void nativeApplyTransaction(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeApplyTransaction(JZ)V", true, null);
    }

    private static void nativeMergeTransaction(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeMergeTransaction(JJ)V", true, null);
    }

    private static void nativeSetAnimationTransaction(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAnimationTransaction(J)V", true, null);
    }

    private static void nativeSetEarlyWakeup(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetEarlyWakeup(J)V", true, null);
    }

    private static void nativeSetEarlyWakeupStart(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetEarlyWakeupStart(J)V", true, null);
    }

    private static void nativeSetEarlyWakeupEnd(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetEarlyWakeupEnd(J)V", true, null);
    }

    private static void nativeSetLayer(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayer(JJI)V", true, null);
    }

    private static void nativeSetRelativeLayer(long l, long l2, long l3, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetRelativeLayer(JJJI)V", true, null);
    }

    private static void nativeSetPosition(long l, long l2, float f, float f2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetPosition(JJFF)V", true, null);
    }

    private static void nativeSetSize(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetSize(JJII)V", true, null);
    }

    private static void nativeSetTransparentRegionHint(long l, long l2, Region region) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetTransparentRegionHint(JJLandroid/graphics/Region;)V", true, null);
    }

    private static void nativeSetAlpha(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAlpha(JJF)V", true, null);
    }

    private static void nativeSetMatrix(long l, long l2, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetMatrix(JJFFFF)V", true, null);
    }

    private static void nativeSetColorTransform(long l, long l2, float[] fArray, float[] fArray2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColorTransform(JJ[F[F)V", true, null);
    }

    private static void nativeSetColorSpaceAgnostic(long l, long l2, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColorSpaceAgnostic(JJZ)V", true, null);
    }

    private static void nativeSetGeometry(long l, long l2, Rect rect, Rect rect2, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGeometry(JJLandroid/graphics/Rect;Landroid/graphics/Rect;J)V", true, null);
    }

    private static void nativeSetColor(long l, long l2, float[] fArray) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColor(JJ[F)V", true, null);
    }

    private static void nativeSetFlags(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFlags(JJII)V", true, null);
    }

    private static void nativeSetFrameRateSelectionPriority(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFrameRateSelectionPriority(JJI)V", true, null);
    }

    private static void nativeSetWindowCrop(long l, long l2, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetWindowCrop(JJIIII)V", true, null);
    }

    private static void nativeSetCornerRadius(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetCornerRadius(JJF)V", true, null);
    }

    private static void nativeSetBackgroundBlurRadius(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetBackgroundBlurRadius(JJI)V", true, null);
    }

    private static void nativeSetLayerStack(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayerStack(JJI)V", true, null);
    }

    private static boolean nativeClearContentFrameStats(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearContentFrameStats(J)Z", true, null) != 0;
    }

    private static boolean nativeGetContentFrameStats(long l, WindowContentFrameStats windowContentFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetContentFrameStats(JLandroid/view/WindowContentFrameStats;)Z", true, null) != 0;
    }

    private static boolean nativeClearAnimationFrameStats() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearAnimationFrameStats()Z", true, null) != 0;
    }

    private static boolean nativeGetAnimationFrameStats(WindowAnimationFrameStats windowAnimationFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetAnimationFrameStats(Landroid/view/WindowAnimationFrameStats;)Z", true, null) != 0;
    }

    private static long[] nativeGetPhysicalDisplayIds() {
        return (long[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetPhysicalDisplayIds()[J", true, null);
    }

    private static IBinder nativeGetPhysicalDisplayToken(long l) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetPhysicalDisplayToken(J)Landroid/os/IBinder;", true, null);
    }

    private static IBinder nativeCreateDisplay(String string2, boolean bl) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeCreateDisplay(Ljava/lang/String;Z)Landroid/os/IBinder;", true, null);
    }

    private static void nativeDestroyDisplay(IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroyDisplay(Landroid/os/IBinder;)V", true, null);
    }

    private static void nativeSetDisplaySurface(long l, IBinder iBinder, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySurface(JLandroid/os/IBinder;J)V", true, null);
    }

    private static void nativeSetDisplayLayerStack(long l, IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayLayerStack(JLandroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetDisplayProjection(long l, IBinder iBinder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayProjection(JLandroid/os/IBinder;IIIIIIIII)V", true, null);
    }

    private static void nativeSetDisplaySize(long l, IBinder iBinder, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySize(JLandroid/os/IBinder;II)V", true, null);
    }

    private static DisplayInfo nativeGetDisplayInfo(IBinder iBinder) {
        return (DisplayInfo)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayInfo(Landroid/os/IBinder;)Landroid/view/SurfaceControl$DisplayInfo;", true, null);
    }

    private static DisplayConfig[] nativeGetDisplayConfigs(IBinder iBinder) {
        return (DisplayConfig[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayConfigs(Landroid/os/IBinder;)[Landroid/view/SurfaceControl$DisplayConfig;", true, null);
    }

    private static DisplayedContentSamplingAttributes nativeGetDisplayedContentSamplingAttributes(IBinder iBinder) {
        return (DisplayedContentSamplingAttributes)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayedContentSamplingAttributes(Landroid/os/IBinder;)Landroid/hardware/display/DisplayedContentSamplingAttributes;", true, null);
    }

    private static boolean nativeSetDisplayedContentSamplingEnabled(IBinder iBinder, boolean bl, int n, int n2) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetDisplayedContentSamplingEnabled(Landroid/os/IBinder;ZII)Z", true, null) != 0;
    }

    private static DisplayedContentSample nativeGetDisplayedContentSample(IBinder iBinder, long l, long l2) {
        return (DisplayedContentSample)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayedContentSample(Landroid/os/IBinder;JJ)Landroid/hardware/display/DisplayedContentSample;", true, null);
    }

    private static int nativeGetActiveConfig(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetActiveConfig(Landroid/os/IBinder;)I", true, null);
    }

    private static boolean nativeSetDesiredDisplayConfigSpecs(IBinder iBinder, DesiredDisplayConfigSpecs desiredDisplayConfigSpecs) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetDesiredDisplayConfigSpecs(Landroid/os/IBinder;Landroid/view/SurfaceControl$DesiredDisplayConfigSpecs;)Z", true, null) != 0;
    }

    private static DesiredDisplayConfigSpecs nativeGetDesiredDisplayConfigSpecs(IBinder iBinder) {
        return (DesiredDisplayConfigSpecs)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDesiredDisplayConfigSpecs(Landroid/os/IBinder;)Landroid/view/SurfaceControl$DesiredDisplayConfigSpecs;", true, null);
    }

    private static int[] nativeGetDisplayColorModes(IBinder iBinder) {
        return (int[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayColorModes(Landroid/os/IBinder;)[I", true, null);
    }

    private static DisplayPrimaries nativeGetDisplayNativePrimaries(IBinder iBinder) {
        return (DisplayPrimaries)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayNativePrimaries(Landroid/os/IBinder;)Landroid/view/SurfaceControl$DisplayPrimaries;", true, null);
    }

    private static int[] nativeGetCompositionDataspaces() {
        return (int[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetCompositionDataspaces()[I", true, null);
    }

    private static int nativeGetActiveColorMode(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetActiveColorMode(Landroid/os/IBinder;)I", true, null);
    }

    private static boolean nativeSetActiveColorMode(IBinder iBinder, int n) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetActiveColorMode(Landroid/os/IBinder;I)Z", true, null) != 0;
    }

    private static void nativeSetAutoLowLatencyMode(IBinder iBinder, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAutoLowLatencyMode(Landroid/os/IBinder;Z)V", true, null);
    }

    private static void nativeSetGameContentType(IBinder iBinder, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGameContentType(Landroid/os/IBinder;Z)V", true, null);
    }

    private static void nativeSetDisplayPowerMode(IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayPowerMode(Landroid/os/IBinder;I)V", true, null);
    }

    private static void nativeDeferTransactionUntil(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDeferTransactionUntil(JJJJ)V", true, null);
    }

    private static void nativeDeferTransactionUntilSurface(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDeferTransactionUntilSurface(JJJJ)V", true, null);
    }

    private static void nativeReparentChildren(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReparentChildren(JJJ)V", true, null);
    }

    private static void nativeReparent(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReparent(JJJ)V", true, null);
    }

    private static void nativeSeverChildren(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSeverChildren(JJ)V", true, null);
    }

    private static void nativeSetOverrideScalingMode(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetOverrideScalingMode(JJI)V", true, null);
    }

    private static Display.HdrCapabilities nativeGetHdrCapabilities(IBinder iBinder) {
        return (Display.HdrCapabilities)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetHdrCapabilities(Landroid/os/IBinder;)Landroid/view/Display$HdrCapabilities;", true, null);
    }

    private static boolean nativeGetAutoLowLatencyModeSupport(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetAutoLowLatencyModeSupport(Landroid/os/IBinder;)Z", true, null) != 0;
    }

    private static boolean nativeGetGameContentTypeSupport(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetGameContentTypeSupport(Landroid/os/IBinder;)Z", true, null) != 0;
    }

    private static void nativeSetInputWindowInfo(long l, long l2, InputWindowHandle inputWindowHandle) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetInputWindowInfo(JJLandroid/view/InputWindowHandle;)V", true, null);
    }

    private static boolean nativeGetProtectedContentSupport() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetProtectedContentSupport()Z", true, null) != 0;
    }

    private static void nativeSetMetadata(long l, long l2, int n, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetMetadata(JJILandroid/os/Parcel;)V", true, null);
    }

    private static void nativeSyncInputWindows(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSyncInputWindows(J)V", true, null);
    }

    private static boolean nativeGetDisplayBrightnessSupport(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetDisplayBrightnessSupport(Landroid/os/IBinder;)Z", true, null) != 0;
    }

    private static boolean nativeSetDisplayBrightness(IBinder iBinder, float f) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetDisplayBrightness(Landroid/os/IBinder;F)Z", true, null) != 0;
    }

    private static long nativeReadTransactionFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeReadTransactionFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static void nativeWriteTransactionToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeWriteTransactionToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static void nativeSetShadowRadius(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetShadowRadius(JJF)V", true, null);
    }

    private static void nativeSetGlobalShadowSettings(float[] fArray, float[] fArray2, float f, float f2, float f3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGlobalShadowSettings([F[FFFF)V", true, null);
    }

    private static void nativeSetFrameRate(long l, long l2, float f, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFrameRate(JJFI)V", true, null);
    }

    private static long nativeGetHandle(long l) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeGetHandle(J)J", true, null);
    }

    private static long nativeAcquireFrameRateFlexibilityToken() {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeAcquireFrameRateFlexibilityToken()J", true, null);
    }

    private static void nativeReleaseFrameRateFlexibilityToken(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReleaseFrameRateFlexibilityToken(J)V", true, null);
    }

    private static void nativeSetFixedTransformHint(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFixedTransformHint(JJI)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOnReparentListener(OnReparentListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReparentListeners == null) {
                this.mReparentListeners = new ArrayList(1);
            }
            return this.mReparentListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOnReparentListener(OnReparentListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            boolean removed = this.mReparentListeners.remove(listener);
            if (this.mReparentListeners.isEmpty()) {
                this.mReparentListeners = null;
            }
            return removed;
        }
    }

    private void assignNativeObject(long nativeObject, String callsite) {
        if (this.mNativeObject != 0L) {
            this.release();
        }
        if (nativeObject != 0L) {
            this.mCloseGuard.openWithCallSite("release", callsite);
        }
        this.mNativeObject = nativeObject;
        this.mNativeHandle = this.mNativeObject != 0L ? SurfaceControl.nativeGetHandle(nativeObject) : 0L;
    }

    public void copyFrom(SurfaceControl other, String callsite) {
        this.mName = other.mName;
        this.mWidth = other.mWidth;
        this.mHeight = other.mHeight;
        this.mLocalOwnerView = other.mLocalOwnerView;
        this.assignNativeObject(SurfaceControl.nativeCopyFromSurfaceControl(other.mNativeObject), callsite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags, SurfaceControl parent, SparseIntArray metadata, WeakReference<View> localOwnerView, String callsite) throws Surface.OutOfResourcesException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.mName = name;
        this.mWidth = w;
        this.mHeight = h;
        this.mLocalOwnerView = localOwnerView;
        Parcel metaParcel = Parcel.obtain();
        try {
            if (metadata != null && metadata.size() > 0) {
                metaParcel.writeInt(metadata.size());
                for (int i = 0; i < metadata.size(); ++i) {
                    metaParcel.writeInt(metadata.keyAt(i));
                    metaParcel.writeByteArray(ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(metadata.valueAt(i)).array());
                }
                metaParcel.setDataPosition(0);
            }
            this.mNativeObject = SurfaceControl.nativeCreate(session, name, w, h, format, flags, parent != null ? parent.mNativeObject : 0L, metaParcel);
        }
        finally {
            metaParcel.recycle();
        }
        if (this.mNativeObject == 0L) {
            throw new Surface.OutOfResourcesException("Couldn't allocate SurfaceControl native object");
        }
        this.mNativeHandle = SurfaceControl.nativeGetHandle(this.mNativeObject);
        this.mCloseGuard.openWithCallSite("release", callsite);
    }

    public SurfaceControl(SurfaceControl other, String callsite) {
        this.copyFrom(other, callsite);
    }

    private SurfaceControl(Parcel in) {
        this.readFromParcel(in);
    }

    public SurfaceControl() {
    }

    public void readFromParcel(Parcel in) {
        if (in == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.mName = in.readString8();
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
        long object = 0L;
        if (in.readInt() != 0) {
            object = SurfaceControl.nativeReadFromParcel(in);
        }
        this.assignNativeObject(object, "readFromParcel");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mName);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        if (this.mNativeObject == 0L) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
        }
        SurfaceControl.nativeWriteToParcel(this.mNativeObject, dest);
        if ((flags & 1) != 0) {
            this.release();
        }
    }

    public boolean isSameSurface(SurfaceControl other) {
        return other.mNativeHandle == this.mNativeHandle;
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, System.identityHashCode(this));
        proto.write(1138166333442L, this.mName);
        proto.end(token);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                SurfaceControl.nativeRelease(this.mNativeObject);
            }
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
            this.mNativeHandle = 0L;
            this.mCloseGuard.close();
        }
    }

    public void disconnect() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDisconnect(this.mNativeObject);
        }
    }

    private void checkNotReleased() {
        if (this.mNativeObject == 0L) {
            throw new NullPointerException("Invalid " + this + ", mNativeObject is null. Have you called release() already?");
        }
    }

    public boolean isValid() {
        return this.mNativeObject != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void openTransaction() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            if (sGlobalTransaction == null) {
                sGlobalTransaction = new Transaction();
            }
            Class<SurfaceControl> clazz2 = SurfaceControl.class;
            synchronized (SurfaceControl.class) {
                ++sTransactionNestCount;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void mergeToGlobalTransaction(Transaction t) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.merge(t);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void closeTransaction() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            if (sTransactionNestCount == 0L) {
                Log.e(TAG, "Call to SurfaceControl.closeTransaction without matching openTransaction");
            } else if (--sTransactionNestCount > 0L) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            sGlobalTransaction.apply();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferTransactionUntil(SurfaceControl barrier, long frame) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.deferTransactionUntil(this, barrier, frame);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparentChildren(SurfaceControl newParent) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.reparentChildren(this, newParent);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachChildren() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.detachChildren(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverrideScalingMode(int scalingMode) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setOverrideScalingMode(this, scalingMode);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void setLayer(int zorder) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setLayer(this, zorder);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void setPosition(float x, float y) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setPosition(this, x, y);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int w, int h) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setBufferSize(this, w, h);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void hide() {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.hide(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void show() {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.show(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransparentRegionHint(Region region) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setTransparentRegionHint(this, region);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean clearContentFrameStats() {
        this.checkNotReleased();
        return SurfaceControl.nativeClearContentFrameStats(this.mNativeObject);
    }

    public boolean getContentFrameStats(WindowContentFrameStats outStats) {
        this.checkNotReleased();
        return SurfaceControl.nativeGetContentFrameStats(this.mNativeObject, outStats);
    }

    public static boolean clearAnimationFrameStats() {
        return SurfaceControl.nativeClearAnimationFrameStats();
    }

    public static boolean getAnimationFrameStats(WindowAnimationFrameStats outStats) {
        return SurfaceControl.nativeGetAnimationFrameStats(outStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlpha(float alpha) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setAlpha(this, alpha);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatrix(float dsdx, float dtdx, float dtdy, float dsdy) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setMatrix(this, dsdx, dtdx, dtdy, dsdy);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorSpaceAgnostic(boolean agnostic) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setColorSpaceAgnostic(this, agnostic);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowCrop(Rect crop) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setWindowCrop(this, crop);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpaque(boolean isOpaque) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setOpaque(this, isOpaque);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecure(boolean isSecure) {
        this.checkNotReleased();
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setSecure(this, isSecure);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mHeight;
        }
    }

    public View getLocalOwnerView() {
        return this.mLocalOwnerView != null ? (View)this.mLocalOwnerView.get() : null;
    }

    public String toString() {
        return "Surface(name=" + this.mName + ")/@0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public static void setDisplayPowerMode(IBinder displayToken, int mode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayPowerMode(displayToken, mode);
    }

    public static DisplayInfo getDisplayInfo(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayInfo(displayToken);
    }

    public static DisplayConfig[] getDisplayConfigs(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayConfigs(displayToken);
    }

    public static int getActiveConfig(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveConfig(displayToken);
    }

    public static DisplayedContentSamplingAttributes getDisplayedContentSamplingAttributes(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayedContentSamplingAttributes(displayToken);
    }

    public static boolean setDisplayedContentSamplingEnabled(IBinder displayToken, boolean enable, int componentMask, int maxFrames) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        int maxColorComponents = 4;
        if (componentMask >> 4 != 0) {
            throw new IllegalArgumentException("invalid componentMask when enabling sampling");
        }
        return SurfaceControl.nativeSetDisplayedContentSamplingEnabled(displayToken, enable, componentMask, maxFrames);
    }

    public static DisplayedContentSample getDisplayedContentSample(IBinder displayToken, long maxFrames, long timestamp) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayedContentSample(displayToken, maxFrames, timestamp);
    }

    public static boolean setDesiredDisplayConfigSpecs(IBinder displayToken, DesiredDisplayConfigSpecs desiredDisplayConfigSpecs) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetDesiredDisplayConfigSpecs(displayToken, desiredDisplayConfigSpecs);
    }

    public static DesiredDisplayConfigSpecs getDesiredDisplayConfigSpecs(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDesiredDisplayConfigSpecs(displayToken);
    }

    public static int[] getDisplayColorModes(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayColorModes(displayToken);
    }

    public static DisplayPrimaries getDisplayNativePrimaries(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayNativePrimaries(displayToken);
    }

    public static int getActiveColorMode(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveColorMode(displayToken);
    }

    public static boolean setActiveColorMode(IBinder displayToken, int colorMode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveColorMode(displayToken, colorMode);
    }

    public static ColorSpace[] getCompositionColorSpaces() {
        int[] dataspaces = SurfaceControl.nativeGetCompositionDataspaces();
        ColorSpace srgb = ColorSpace.get(ColorSpace.Named.SRGB);
        ColorSpace[] colorSpaces = new ColorSpace[]{srgb, srgb};
        if (dataspaces.length == 2) {
            block4: for (int i = 0; i < 2; ++i) {
                switch (dataspaces[i]) {
                    case 0x88A0000: {
                        colorSpaces[i] = ColorSpace.get(ColorSpace.Named.DISPLAY_P3);
                        continue block4;
                    }
                    case 0x18810000: {
                        colorSpaces[i] = ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB);
                        continue block4;
                    }
                }
            }
        }
        return colorSpaces;
    }

    public static void setAutoLowLatencyMode(IBinder displayToken, boolean on) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetAutoLowLatencyMode(displayToken, on);
    }

    public static void setGameContentType(IBinder displayToken, boolean on) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetGameContentType(displayToken, on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplayProjection(displayToken, orientation, layerStackRect, displayRect);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setDisplayLayerStack(IBinder displayToken, int layerStack) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplayLayerStack(displayToken, layerStack);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setDisplaySurface(IBinder displayToken, Surface surface) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplaySurface(displayToken, surface);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplaySize(IBinder displayToken, int width, int height) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplaySize(displayToken, width, height);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static Display.HdrCapabilities getHdrCapabilities(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetHdrCapabilities(displayToken);
    }

    public static boolean getAutoLowLatencyModeSupport(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetAutoLowLatencyModeSupport(displayToken);
    }

    public static boolean getGameContentTypeSupport(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetGameContentTypeSupport(displayToken);
    }

    @UnsupportedAppUsage
    public static IBinder createDisplay(String name, boolean secure) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return SurfaceControl.nativeCreateDisplay(name, secure);
    }

    @UnsupportedAppUsage
    public static void destroyDisplay(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeDestroyDisplay(displayToken);
    }

    public static long[] getPhysicalDisplayIds() {
        return SurfaceControl.nativeGetPhysicalDisplayIds();
    }

    public static IBinder getPhysicalDisplayToken(long physicalDisplayId) {
        return SurfaceControl.nativeGetPhysicalDisplayToken(physicalDisplayId);
    }

    public static IBinder getInternalDisplayToken() {
        long[] physicalDisplayIds = SurfaceControl.getPhysicalDisplayIds();
        if (physicalDisplayIds.length == 0) {
            return null;
        }
        return SurfaceControl.getPhysicalDisplayToken(physicalDisplayIds[0]);
    }

    public static void screenshot(IBinder display, Surface consumer) {
        SurfaceControl.screenshot(display, consumer, new Rect(), 0, 0, false, 0);
    }

    public static void screenshot(IBinder display, Surface consumer, Rect sourceCrop, int width, int height, boolean useIdentityTransform, int rotation) {
        if (consumer == null) {
            throw new IllegalArgumentException("consumer must not be null");
        }
        ScreenshotGraphicBuffer buffer = SurfaceControl.screenshotToBuffer(display, sourceCrop, width, height, useIdentityTransform, rotation);
        try {
            consumer.attachAndQueueBufferWithColorSpace(buffer.getGraphicBuffer(), buffer.getColorSpace());
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Failed to take screenshot - " + e.getMessage());
        }
    }

    @UnsupportedAppUsage
    public static Bitmap screenshot(Rect sourceCrop, int width, int height, int rotation) {
        return SurfaceControl.screenshot(sourceCrop, width, height, false, rotation);
    }

    @UnsupportedAppUsage
    public static Bitmap screenshot(Rect sourceCrop, int width, int height, boolean useIdentityTransform, int rotation) {
        IBinder displayToken = SurfaceControl.getInternalDisplayToken();
        if (displayToken == null) {
            Log.w(TAG, "Failed to take screenshot because internal display is disconnected");
            return null;
        }
        if (rotation == 1 || rotation == 3) {
            rotation = rotation == 1 ? 3 : 1;
        }
        SurfaceControl.rotateCropForSF(sourceCrop, rotation);
        ScreenshotGraphicBuffer buffer = SurfaceControl.screenshotToBuffer(displayToken, sourceCrop, width, height, useIdentityTransform, rotation);
        if (buffer == null) {
            Log.w(TAG, "Failed to take screenshot");
            return null;
        }
        return Bitmap.wrapHardwareBuffer(buffer.getGraphicBuffer(), buffer.getColorSpace());
    }

    public static ScreenshotGraphicBuffer screenshotToBuffer(IBinder display, Rect sourceCrop, int width, int height, boolean useIdentityTransform, int rotation) {
        if (display == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeScreenshot(display, sourceCrop, width, height, useIdentityTransform, rotation, false);
    }

    public static ScreenshotGraphicBuffer screenshotToBufferWithSecureLayersUnsafe(IBinder display, Rect sourceCrop, int width, int height, boolean useIdentityTransform, int rotation) {
        if (display == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeScreenshot(display, sourceCrop, width, height, useIdentityTransform, rotation, true);
    }

    private static void rotateCropForSF(Rect crop, int rot) {
        if (rot == 1 || rot == 3) {
            int tmp = crop.top;
            crop.top = crop.left;
            crop.left = tmp;
            tmp = crop.right;
            crop.right = crop.bottom;
            crop.bottom = tmp;
        }
    }

    public static ScreenshotGraphicBuffer captureLayers(SurfaceControl layer, Rect sourceCrop, float frameScale) {
        return SurfaceControl.captureLayers(layer, sourceCrop, frameScale, 1);
    }

    public static ScreenshotGraphicBuffer captureLayers(SurfaceControl layer, Rect sourceCrop, float frameScale, int format) {
        IBinder displayToken = SurfaceControl.getInternalDisplayToken();
        return SurfaceControl.nativeCaptureLayers(displayToken, layer.mNativeObject, sourceCrop, frameScale, null, format);
    }

    public static ScreenshotGraphicBuffer captureLayersExcluding(SurfaceControl layer, Rect sourceCrop, float frameScale, int format, SurfaceControl[] exclude) {
        IBinder displayToken = SurfaceControl.getInternalDisplayToken();
        long[] nativeExcludeObjects = new long[exclude.length];
        for (int i = 0; i < exclude.length; ++i) {
            nativeExcludeObjects[i] = exclude[i].mNativeObject;
        }
        return SurfaceControl.nativeCaptureLayers(displayToken, layer.mNativeObject, sourceCrop, frameScale, nativeExcludeObjects, 1);
    }

    public static boolean getProtectedContentSupport() {
        return SurfaceControl.nativeGetProtectedContentSupport();
    }

    public static boolean getDisplayBrightnessSupport(IBinder displayToken) {
        return SurfaceControl.nativeGetDisplayBrightnessSupport(displayToken);
    }

    public static boolean setDisplayBrightness(IBinder displayToken, float brightness) {
        Objects.requireNonNull(displayToken);
        if (Float.isNaN(brightness) || brightness > 1.0f || brightness < 0.0f && brightness != -1.0f) {
            throw new IllegalArgumentException("brightness must be a number between 0.0f and 1.0f, or -1 to turn the backlight off.");
        }
        return SurfaceControl.nativeSetDisplayBrightness(displayToken, brightness);
    }

    public static SurfaceControl mirrorSurface(SurfaceControl mirrorOf) {
        long nativeObj = SurfaceControl.nativeMirrorSurface(mirrorOf.mNativeObject);
        SurfaceControl sc = new SurfaceControl();
        sc.assignNativeObject(nativeObj, "mirrorSurface");
        return sc;
    }

    private static void validateColorArg(float[] color2) {
        String msg = "Color must be specified as a float array with four values to represent r, g, b, a in range [0..1]";
        if (color2.length != 4) {
            throw new IllegalArgumentException("Color must be specified as a float array with four values to represent r, g, b, a in range [0..1]");
        }
        for (float c : color2) {
            if (!(c < 0.0f) && !(c > 1.0f)) continue;
            throw new IllegalArgumentException("Color must be specified as a float array with four values to represent r, g, b, a in range [0..1]");
        }
    }

    public static void setGlobalShadowSettings(float[] ambientColor, float[] spotColor, float lightPosY, float lightPosZ, float lightRadius) {
        SurfaceControl.validateColorArg(ambientColor);
        SurfaceControl.validateColorArg(spotColor);
        SurfaceControl.nativeSetGlobalShadowSettings(ambientColor, spotColor, lightPosY, lightPosZ, lightRadius);
    }

    public static long acquireFrameRateFlexibilityToken() {
        return SurfaceControl.nativeAcquireFrameRateFlexibilityToken();
    }

    public static void releaseFrameRateFlexibilityToken(long token) {
        SurfaceControl.nativeReleaseFrameRateFlexibilityToken(token);
    }

    static /* synthetic */ long access$200() {
        return SurfaceControl.nativeGetNativeTransactionFinalizer();
    }

    static {
        sTransactionNestCount = 0L;
        CREATOR = new Parcelable.Creator<SurfaceControl>(){

            @Override
            public SurfaceControl createFromParcel(Parcel in) {
                return new SurfaceControl(in);
            }

            public SurfaceControl[] newArray(int size) {
                return new SurfaceControl[size];
            }
        };
    }

    public static class LockDebuggingTransaction
    extends Transaction {
        Object mMonitor;

        public LockDebuggingTransaction(Object o) {
            this.mMonitor = o;
        }

        @Override
        protected void checkPreconditions(SurfaceControl sc) {
            super.checkPreconditions(sc);
            if (!Thread.holdsLock(this.mMonitor)) {
                throw new RuntimeException("Unlocked access to synchronized SurfaceControl.Transaction");
            }
        }
    }

    public static class Transaction
    implements Closeable,
    Parcelable {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Transaction.class.getClassLoader(), SurfaceControl.access$200(), 512L);
        public long mNativeObject;
        private final ArrayMap<SurfaceControl, Point> mResizedSurfaces = new ArrayMap();
        private final ArrayMap<SurfaceControl, SurfaceControl> mReparentedSurfaces = new ArrayMap();
        Runnable mFreeNativeResources;
        private static final float[] INVALID_COLOR = new float[]{-1.0f, -1.0f, -1.0f};
        public static final Parcelable.Creator<Transaction> CREATOR = new Parcelable.Creator<Transaction>(){

            @Override
            public Transaction createFromParcel(Parcel in) {
                return new Transaction(in);
            }

            public Transaction[] newArray(int size) {
                return new Transaction[size];
            }
        };

        protected void checkPreconditions(SurfaceControl sc) {
            sc.checkNotReleased();
        }

        public Transaction() {
            this.mNativeObject = SurfaceControl.nativeCreateTransaction();
            this.mFreeNativeResources = sRegistry.registerNativeAllocation(this, this.mNativeObject);
        }

        private Transaction(Parcel in) {
            this.readFromParcel(in);
        }

        public void apply() {
            this.apply(false);
        }

        @Override
        public void close() {
            this.mResizedSurfaces.clear();
            this.mReparentedSurfaces.clear();
            this.mFreeNativeResources.run();
            this.mNativeObject = 0L;
        }

        public void apply(boolean sync) {
            this.applyResizedSurfaces();
            this.notifyReparentedSurfaces();
            SurfaceControl.nativeApplyTransaction(this.mNativeObject, sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyResizedSurfaces() {
            for (int i = this.mResizedSurfaces.size() - 1; i >= 0; --i) {
                Point size = this.mResizedSurfaces.valueAt(i);
                SurfaceControl surfaceControl = this.mResizedSurfaces.keyAt(i);
                Object object = surfaceControl.mLock;
                synchronized (object) {
                    surfaceControl.mWidth = size.x;
                    surfaceControl.mHeight = size.y;
                    continue;
                }
            }
            this.mResizedSurfaces.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyReparentedSurfaces() {
            int reparentCount = this.mReparentedSurfaces.size();
            for (int i = reparentCount - 1; i >= 0; --i) {
                SurfaceControl child = this.mReparentedSurfaces.keyAt(i);
                Object object = child.mLock;
                synchronized (object) {
                    int listenerCount = child.mReparentListeners != null ? child.mReparentListeners.size() : 0;
                    for (int j = 0; j < listenerCount; ++j) {
                        OnReparentListener listener = (OnReparentListener)child.mReparentListeners.get(j);
                        listener.onReparent(this, this.mReparentedSurfaces.valueAt(i));
                    }
                    this.mReparentedSurfaces.removeAt(i);
                    continue;
                }
            }
        }

        public Transaction setVisibility(SurfaceControl sc, boolean visible) {
            this.checkPreconditions(sc);
            if (visible) {
                return this.show(sc);
            }
            return this.hide(sc);
        }

        public Transaction setFrameRateSelectionPriority(SurfaceControl sc, int priority) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetFrameRateSelectionPriority(this.mNativeObject, sc.mNativeObject, priority);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction show(SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 1);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction hide(SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 1, 1);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setPosition(SurfaceControl sc, float x, float y) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetPosition(this.mNativeObject, sc.mNativeObject, x, y);
            return this;
        }

        public Transaction setBufferSize(SurfaceControl sc, int w, int h) {
            this.checkPreconditions(sc);
            this.mResizedSurfaces.put(sc, new Point(w, h));
            SurfaceControl.nativeSetSize(this.mNativeObject, sc.mNativeObject, w, h);
            return this;
        }

        public Transaction setFixedTransformHint(SurfaceControl sc, int transformHint) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFixedTransformHint(this.mNativeObject, sc.mNativeObject, transformHint);
            return this;
        }

        public Transaction unsetFixedTransformHint(SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFixedTransformHint(this.mNativeObject, sc.mNativeObject, -1);
            return this;
        }

        public Transaction setLayer(SurfaceControl sc, int z) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetLayer(this.mNativeObject, sc.mNativeObject, z);
            return this;
        }

        public Transaction setRelativeLayer(SurfaceControl sc, SurfaceControl relativeTo, int z) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetRelativeLayer(this.mNativeObject, sc.mNativeObject, relativeTo.mNativeObject, z);
            return this;
        }

        public Transaction setTransparentRegionHint(SurfaceControl sc, Region transparentRegion) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetTransparentRegionHint(this.mNativeObject, sc.mNativeObject, transparentRegion);
            return this;
        }

        public Transaction setAlpha(SurfaceControl sc, float alpha) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetAlpha(this.mNativeObject, sc.mNativeObject, alpha);
            return this;
        }

        public Transaction setInputWindowInfo(SurfaceControl sc, InputWindowHandle handle) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetInputWindowInfo(this.mNativeObject, sc.mNativeObject, handle);
            return this;
        }

        public Transaction syncInputWindows() {
            SurfaceControl.nativeSyncInputWindows(this.mNativeObject);
            return this;
        }

        public Transaction setGeometry(SurfaceControl sc, Rect sourceCrop, Rect destFrame, int orientation) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetGeometry(this.mNativeObject, sc.mNativeObject, sourceCrop, destFrame, orientation);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setMatrix(SurfaceControl sc, float dsdx, float dtdx, float dtdy, float dsdy) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetMatrix(this.mNativeObject, sc.mNativeObject, dsdx, dtdx, dtdy, dsdy);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setMatrix(SurfaceControl sc, Matrix matrix, float[] float9) {
            matrix.getValues(float9);
            this.setMatrix(sc, float9[0], float9[3], float9[1], float9[4]);
            this.setPosition(sc, float9[2], float9[5]);
            return this;
        }

        public Transaction setColorTransform(SurfaceControl sc, float[] matrix, float[] translation) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColorTransform(this.mNativeObject, sc.mNativeObject, matrix, translation);
            return this;
        }

        public Transaction setColorSpaceAgnostic(SurfaceControl sc, boolean agnostic) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColorSpaceAgnostic(this.mNativeObject, sc.mNativeObject, agnostic);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setWindowCrop(SurfaceControl sc, Rect crop) {
            this.checkPreconditions(sc);
            if (crop != null) {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
            } else {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, 0, 0);
            }
            return this;
        }

        public Transaction setWindowCrop(SurfaceControl sc, int width, int height) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, width, height);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setCornerRadius(SurfaceControl sc, float cornerRadius) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetCornerRadius(this.mNativeObject, sc.mNativeObject, cornerRadius);
            return this;
        }

        public Transaction setBackgroundBlurRadius(SurfaceControl sc, int radius) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetBackgroundBlurRadius(this.mNativeObject, sc.mNativeObject, radius);
            return this;
        }

        @UnsupportedAppUsage(maxTargetSdk=26)
        public Transaction setLayerStack(SurfaceControl sc, int layerStack) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetLayerStack(this.mNativeObject, sc.mNativeObject, layerStack);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction deferTransactionUntil(SurfaceControl sc, SurfaceControl barrier, long frameNumber) {
            if (frameNumber < 0L) {
                return this;
            }
            this.checkPreconditions(sc);
            SurfaceControl.nativeDeferTransactionUntil(this.mNativeObject, sc.mNativeObject, barrier.mNativeObject, frameNumber);
            return this;
        }

        @Deprecated
        @UnsupportedAppUsage
        public Transaction deferTransactionUntilSurface(SurfaceControl sc, Surface barrierSurface, long frameNumber) {
            if (frameNumber < 0L) {
                return this;
            }
            this.checkPreconditions(sc);
            SurfaceControl.nativeDeferTransactionUntilSurface(this.mNativeObject, sc.mNativeObject, barrierSurface.mNativeObject, frameNumber);
            return this;
        }

        public Transaction reparentChildren(SurfaceControl sc, SurfaceControl newParent) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeReparentChildren(this.mNativeObject, sc.mNativeObject, newParent.mNativeObject);
            return this;
        }

        public Transaction reparent(SurfaceControl sc, SurfaceControl newParent) {
            this.checkPreconditions(sc);
            long otherObject = 0L;
            if (newParent != null) {
                newParent.checkNotReleased();
                otherObject = newParent.mNativeObject;
            }
            SurfaceControl.nativeReparent(this.mNativeObject, sc.mNativeObject, otherObject);
            this.mReparentedSurfaces.put(sc, newParent);
            return this;
        }

        public Transaction detachChildren(SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSeverChildren(this.mNativeObject, sc.mNativeObject);
            return this;
        }

        public Transaction setOverrideScalingMode(SurfaceControl sc, int overrideScalingMode) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetOverrideScalingMode(this.mNativeObject, sc.mNativeObject, overrideScalingMode);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setColor(SurfaceControl sc, float[] color2) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColor(this.mNativeObject, sc.mNativeObject, color2);
            return this;
        }

        public Transaction unsetColor(SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColor(this.mNativeObject, sc.mNativeObject, Transaction.INVALID_COLOR);
            return this;
        }

        public Transaction setSecure(SurfaceControl sc, boolean isSecure) {
            this.checkPreconditions(sc);
            if (isSecure) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 128, 128);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 128);
            }
            return this;
        }

        public Transaction setOpaque(SurfaceControl sc, boolean isOpaque) {
            this.checkPreconditions(sc);
            if (isOpaque) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 2, 2);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 2);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transaction setDisplaySurface(IBinder displayToken, Surface surface) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (surface != null) {
                Object object = surface.mLock;
                synchronized (object) {
                    SurfaceControl.nativeSetDisplaySurface(this.mNativeObject, displayToken, surface.mNativeObject);
                }
            } else {
                SurfaceControl.nativeSetDisplaySurface(this.mNativeObject, displayToken, 0L);
            }
            return this;
        }

        public Transaction setDisplayLayerStack(IBinder displayToken, int layerStack) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            SurfaceControl.nativeSetDisplayLayerStack(this.mNativeObject, displayToken, layerStack);
            return this;
        }

        public Transaction setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (layerStackRect == null) {
                throw new IllegalArgumentException("layerStackRect must not be null");
            }
            if (displayRect == null) {
                throw new IllegalArgumentException("displayRect must not be null");
            }
            SurfaceControl.nativeSetDisplayProjection(this.mNativeObject, displayToken, orientation, layerStackRect.left, layerStackRect.top, layerStackRect.right, layerStackRect.bottom, displayRect.left, displayRect.top, displayRect.right, displayRect.bottom);
            return this;
        }

        public Transaction setDisplaySize(IBinder displayToken, int width, int height) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            SurfaceControl.nativeSetDisplaySize(this.mNativeObject, displayToken, width, height);
            return this;
        }

        public Transaction setAnimationTransaction() {
            SurfaceControl.nativeSetAnimationTransaction(this.mNativeObject);
            return this;
        }

        @Deprecated
        public Transaction setEarlyWakeup() {
            SurfaceControl.nativeSetEarlyWakeup(this.mNativeObject);
            return this;
        }

        public Transaction setEarlyWakeupStart() {
            SurfaceControl.nativeSetEarlyWakeupStart(this.mNativeObject);
            return this;
        }

        public Transaction setEarlyWakeupEnd() {
            SurfaceControl.nativeSetEarlyWakeupEnd(this.mNativeObject);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transaction setMetadata(SurfaceControl sc, int key, int data) {
            Parcel parcel = Parcel.obtain();
            parcel.writeInt(data);
            try {
                this.setMetadata(sc, key, parcel);
            }
            finally {
                parcel.recycle();
            }
            return this;
        }

        public Transaction setMetadata(SurfaceControl sc, int key, Parcel data) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetMetadata(this.mNativeObject, sc.mNativeObject, key, data);
            return this;
        }

        public Transaction setShadowRadius(SurfaceControl sc, float shadowRadius) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetShadowRadius(this.mNativeObject, sc.mNativeObject, shadowRadius);
            return this;
        }

        public Transaction setFrameRate(SurfaceControl sc, float frameRate, int compatibility) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFrameRate(this.mNativeObject, sc.mNativeObject, frameRate, compatibility);
            return this;
        }

        public Transaction merge(Transaction other) {
            if (this == other) {
                return this;
            }
            this.mResizedSurfaces.putAll(other.mResizedSurfaces);
            other.mResizedSurfaces.clear();
            this.mReparentedSurfaces.putAll(other.mReparentedSurfaces);
            other.mReparentedSurfaces.clear();
            SurfaceControl.nativeMergeTransaction(this.mNativeObject, other.mNativeObject);
            return this;
        }

        public Transaction remove(SurfaceControl sc) {
            this.reparent(sc, null);
            sc.release();
            return this;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mNativeObject == 0L) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
            }
            SurfaceControl.nativeWriteTransactionToParcel(this.mNativeObject, dest);
        }

        private void readFromParcel(Parcel in) {
            this.mNativeObject = 0L;
            if (in.readInt() != 0) {
                this.mNativeObject = SurfaceControl.nativeReadTransactionFromParcel(in);
                this.mFreeNativeResources = sRegistry.registerNativeAllocation(this, this.mNativeObject);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class DisplayPrimaries {
        public CieXyz red;
        public CieXyz green;
        public CieXyz blue;
        public CieXyz white;
    }

    public static class CieXyz {
        public float X;
        public float Y;
        public float Z;
    }

    public static class DesiredDisplayConfigSpecs {
        public int defaultConfig;
        public float primaryRefreshRateMin;
        public float primaryRefreshRateMax;
        public float appRequestRefreshRateMin;
        public float appRequestRefreshRateMax;

        public DesiredDisplayConfigSpecs() {
        }

        public DesiredDisplayConfigSpecs(DesiredDisplayConfigSpecs other) {
            this.copyFrom(other);
        }

        public DesiredDisplayConfigSpecs(int defaultConfig, float primaryRefreshRateMin, float primaryRefreshRateMax, float appRequestRefreshRateMin, float appRequestRefreshRateMax) {
            this.defaultConfig = defaultConfig;
            this.primaryRefreshRateMin = primaryRefreshRateMin;
            this.primaryRefreshRateMax = primaryRefreshRateMax;
            this.appRequestRefreshRateMin = appRequestRefreshRateMin;
            this.appRequestRefreshRateMax = appRequestRefreshRateMax;
        }

        public boolean equals(Object o) {
            return o instanceof DesiredDisplayConfigSpecs && this.equals((DesiredDisplayConfigSpecs)o);
        }

        public boolean equals(DesiredDisplayConfigSpecs other) {
            return other != null && this.defaultConfig == other.defaultConfig && this.primaryRefreshRateMin == other.primaryRefreshRateMin && this.primaryRefreshRateMax == other.primaryRefreshRateMax && this.appRequestRefreshRateMin == other.appRequestRefreshRateMin && this.appRequestRefreshRateMax == other.appRequestRefreshRateMax;
        }

        public int hashCode() {
            return 0;
        }

        public void copyFrom(DesiredDisplayConfigSpecs other) {
            this.defaultConfig = other.defaultConfig;
            this.primaryRefreshRateMin = other.primaryRefreshRateMin;
            this.primaryRefreshRateMax = other.primaryRefreshRateMax;
            this.appRequestRefreshRateMin = other.appRequestRefreshRateMin;
            this.appRequestRefreshRateMax = other.appRequestRefreshRateMax;
        }

        public String toString() {
            return String.format("defaultConfig=%d primaryRefreshRateRange=[%.0f %.0f] appRequestRefreshRateRange=[%.0f %.0f]", this.defaultConfig, Float.valueOf(this.primaryRefreshRateMin), Float.valueOf(this.primaryRefreshRateMax), Float.valueOf(this.appRequestRefreshRateMin), Float.valueOf(this.appRequestRefreshRateMax));
        }
    }

    public static class DisplayConfig {
        public static final int INVALID_DISPLAY_CONFIG_ID = -1;
        public int width;
        public int height;
        public float xDpi;
        public float yDpi;
        public float refreshRate;
        public long appVsyncOffsetNanos;
        public long presentationDeadlineNanos;
        public int configGroup;

        public String toString() {
            return "DisplayConfig{width=" + this.width + ", height=" + this.height + ", xDpi=" + this.xDpi + ", yDpi=" + this.yDpi + ", refreshRate=" + this.refreshRate + ", appVsyncOffsetNanos=" + this.appVsyncOffsetNanos + ", presentationDeadlineNanos=" + this.presentationDeadlineNanos + ", configGroup=" + this.configGroup + "}";
        }
    }

    public static class DisplayInfo {
        public boolean isInternal;
        public float density;
        public boolean secure;
        public DeviceProductInfo deviceProductInfo;

        public String toString() {
            return "DisplayInfo{isInternal=" + this.isInternal + ", density=" + this.density + ", secure=" + this.secure + ", deviceProductInfo=" + this.deviceProductInfo + "}";
        }
    }

    public static class Builder {
        private SurfaceSession mSession;
        private int mFlags = 4;
        private int mWidth;
        private int mHeight;
        private int mFormat = -1;
        private String mName;
        private WeakReference<View> mLocalOwnerView;
        private SurfaceControl mParent;
        private SparseIntArray mMetadata;
        private String mCallsite = "SurfaceControl.Builder";

        public Builder(SurfaceSession session) {
            this.mSession = session;
        }

        public Builder() {
        }

        public SurfaceControl build() {
            if (this.mWidth < 0 || this.mHeight < 0) {
                throw new IllegalStateException("width and height must be positive or unset");
            }
            if ((this.mWidth > 0 || this.mHeight > 0) && (this.isEffectLayer() || this.isContainerLayer())) {
                throw new IllegalStateException("Only buffer layers can set a valid buffer size.");
            }
            return new SurfaceControl(this.mSession, this.mName, this.mWidth, this.mHeight, this.mFormat, this.mFlags, this.mParent, this.mMetadata, this.mLocalOwnerView, this.mCallsite);
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setLocalOwnerView(View view) {
            this.mLocalOwnerView = new WeakReference<View>(view);
            return this;
        }

        public Builder setBufferSize(int width, int height) {
            if (width < 0 || height < 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            this.mWidth = width;
            this.mHeight = height;
            return this.setFlags(0, 983040);
        }

        private void unsetBufferSize() {
            this.mWidth = 0;
            this.mHeight = 0;
        }

        public Builder setFormat(int format) {
            this.mFormat = format;
            return this;
        }

        public Builder setProtected(boolean protectedContent) {
            this.mFlags = protectedContent ? (this.mFlags |= 0x800) : (this.mFlags &= 0xFFFFF7FF);
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.mFlags = secure ? (this.mFlags |= 0x80) : (this.mFlags &= 0xFFFFFF7F);
            return this;
        }

        public Builder setOpaque(boolean opaque) {
            this.mFlags = opaque ? (this.mFlags |= 0x400) : (this.mFlags &= 0xFFFFFBFF);
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.mFlags = hidden ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
            return this;
        }

        public Builder setParent(SurfaceControl parent) {
            this.mParent = parent;
            return this;
        }

        public Builder setMetadata(int key, int data) {
            if (this.mMetadata == null) {
                this.mMetadata = new SparseIntArray();
            }
            this.mMetadata.put(key, data);
            return this;
        }

        public Builder setEffectLayer() {
            this.mFlags |= 0x4000;
            this.unsetBufferSize();
            return this.setFlags(131072, 983040);
        }

        public Builder setColorLayer() {
            this.unsetBufferSize();
            return this.setFlags(131072, 983040);
        }

        private boolean isEffectLayer() {
            return (this.mFlags & 0x20000) == 131072;
        }

        public Builder setBLASTLayer() {
            this.unsetBufferSize();
            return this.setFlags(262144, 983040);
        }

        public Builder setContainerLayer() {
            this.unsetBufferSize();
            return this.setFlags(524288, 983040);
        }

        private boolean isContainerLayer() {
            return (this.mFlags & 0x80000) == 524288;
        }

        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        public Builder setCallsite(String callsite) {
            this.mCallsite = callsite;
            return this;
        }

        private Builder setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~mask | flags;
            return this;
        }
    }

    public static class ScreenshotGraphicBuffer {
        private final GraphicBuffer mGraphicBuffer;
        private final ColorSpace mColorSpace;
        private final boolean mContainsSecureLayers;

        public ScreenshotGraphicBuffer(GraphicBuffer graphicBuffer, ColorSpace colorSpace, boolean containsSecureLayers) {
            this.mGraphicBuffer = graphicBuffer;
            this.mColorSpace = colorSpace;
            this.mContainsSecureLayers = containsSecureLayers;
        }

        private static ScreenshotGraphicBuffer createFromNative(int width, int height, int format, int usage, long unwrappedNativeObject, int namedColorSpace, boolean containsSecureLayers) {
            GraphicBuffer graphicBuffer = GraphicBuffer.createFromExisting(width, height, format, usage, unwrappedNativeObject);
            ColorSpace colorSpace = ColorSpace.get(ColorSpace.Named.values()[namedColorSpace]);
            return new ScreenshotGraphicBuffer(graphicBuffer, colorSpace, containsSecureLayers);
        }

        public ColorSpace getColorSpace() {
            return this.mColorSpace;
        }

        public GraphicBuffer getGraphicBuffer() {
            return this.mGraphicBuffer;
        }

        public boolean containsSecureLayers() {
            return this.mContainsSecureLayers;
        }
    }

    public static interface OnReparentListener {
        public void onReparent(Transaction var1, SurfaceControl var2);
    }
}

