/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.ScrollCaptureCallback;
import android.view.View;
import com.android.internal.util.FastMath;

public class ScrollCaptureTarget {
    private final View mContainingView;
    private final ScrollCaptureCallback mCallback;
    private final Rect mLocalVisibleRect;
    private final Point mPositionInWindow;
    private final int mHint;
    private Rect mScrollBounds;
    private final float[] mTmpFloatArr = new float[2];
    private final Matrix mMatrixViewLocalToWindow = new Matrix();
    private final Rect mTmpRect = new Rect();

    public ScrollCaptureTarget(View scrollTarget, Rect localVisibleRect, Point positionInWindow, ScrollCaptureCallback callback) {
        this.mContainingView = scrollTarget;
        this.mHint = this.mContainingView.getScrollCaptureHint();
        this.mCallback = callback;
        this.mLocalVisibleRect = localVisibleRect;
        this.mPositionInWindow = positionInWindow;
    }

    public int getHint() {
        return this.mHint;
    }

    public ScrollCaptureCallback getCallback() {
        return this.mCallback;
    }

    public View getContainingView() {
        return this.mContainingView;
    }

    public Rect getLocalVisibleRect() {
        return this.mLocalVisibleRect;
    }

    public Point getPositionInWindow() {
        return this.mPositionInWindow;
    }

    public Rect getScrollBounds() {
        return this.mScrollBounds;
    }

    public void setScrollBounds(Rect scrollBounds) {
        this.mScrollBounds = Rect.copyOrNull(scrollBounds);
        if (this.mScrollBounds == null) {
            return;
        }
        if (!this.mScrollBounds.intersect(0, 0, this.mContainingView.getWidth(), this.mContainingView.getHeight())) {
            this.mScrollBounds.setEmpty();
        }
    }

    private static void zero(float[] pointArray) {
        pointArray[0] = 0.0f;
        pointArray[1] = 0.0f;
    }

    private static void roundIntoPoint(Point pointObj, float[] pointArray) {
        pointObj.x = FastMath.round(pointArray[0]);
        pointObj.y = FastMath.round(pointArray[1]);
    }

    public void updatePositionInWindow() {
        this.mMatrixViewLocalToWindow.reset();
        this.mContainingView.transformMatrixToGlobal(this.mMatrixViewLocalToWindow);
        ScrollCaptureTarget.zero(this.mTmpFloatArr);
        this.mMatrixViewLocalToWindow.mapPoints(this.mTmpFloatArr);
        ScrollCaptureTarget.roundIntoPoint(this.mPositionInWindow, this.mTmpFloatArr);
    }
}

