/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import com.android.internal.widget.CachingIconView;
import com.android.internal.widget.NotificationExpandButton;
import java.util.ArrayList;

@RemoteViews.RemoteView
public class NotificationHeaderView
extends ViewGroup {
    public static final int NO_COLOR = 1;
    private final int mChildMinWidth;
    private final int mContentEndMargin;
    private final int mGravity;
    private View mAppName;
    private View mHeaderText;
    private View mSecondaryHeaderText;
    private View.OnClickListener mExpandClickListener;
    private View.OnClickListener mAppOpsListener;
    private HeaderTouchListener mTouchListener = new HeaderTouchListener();
    private LinearLayout mTransferChip;
    private NotificationExpandButton mExpandButton;
    private CachingIconView mIcon;
    private View mProfileBadge;
    private View mAppOps;
    private boolean mExpanded;
    private boolean mShowExpandButtonAtEnd;
    private boolean mShowWorkBadgeAtEnd;
    private int mHeaderTextMarginEnd;
    private Drawable mBackground;
    private boolean mEntireHeaderClickable;
    private boolean mExpandOnlyOnButton;
    private boolean mAcceptAllTouches;
    private int mTotalWidth;
    ViewOutlineProvider mProvider = new ViewOutlineProvider(){

        @Override
        public void getOutline(View view, Outline outline) {
            if (NotificationHeaderView.this.mBackground != null) {
                outline.setRect(0, 0, NotificationHeaderView.this.getWidth(), NotificationHeaderView.this.getHeight());
                outline.setAlpha(1.0f);
            }
        }
    };

    public NotificationHeaderView(Context context) {
        this(context, null);
    }

    @UnsupportedAppUsage
    public NotificationHeaderView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NotificationHeaderView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationHeaderView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Resources res = this.getResources();
        this.mChildMinWidth = res.getDimensionPixelSize(17105365);
        this.mContentEndMargin = res.getDimensionPixelSize(17105345);
        this.mEntireHeaderClickable = res.getBoolean(17891497);
        int[] attrIds = new int[]{16842927};
        TypedArray ta = context.obtainStyledAttributes(attrs, attrIds, defStyleAttr, defStyleRes);
        this.mGravity = ta.getInt(0, 0);
        ta.recycle();
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mAppName = this.findViewById(16908761);
        this.mHeaderText = this.findViewById(16909033);
        this.mSecondaryHeaderText = this.findViewById(16909035);
        this.mTransferChip = (LinearLayout)this.findViewById(16909158);
        this.mExpandButton = (NotificationExpandButton)this.findViewById(16908949);
        this.mIcon = (CachingIconView)this.findViewById(16908294);
        this.mProfileBadge = this.findViewById(16909317);
        this.mAppOps = this.findViewById(16908762);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int givenWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int givenHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        int wrapContentWidthSpec = View.MeasureSpec.makeMeasureSpec(givenWidth, Integer.MIN_VALUE);
        int wrapContentHeightSpec = View.MeasureSpec.makeMeasureSpec(givenHeight, Integer.MIN_VALUE);
        int totalWidth = this.getPaddingStart();
        int iconWidth = this.getPaddingEnd();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidthSpec = NotificationHeaderView.getChildMeasureSpec(wrapContentWidthSpec, lp.leftMargin + lp.rightMargin, lp.width);
            int childHeightSpec = NotificationHeaderView.getChildMeasureSpec(wrapContentHeightSpec, lp.topMargin + lp.bottomMargin, lp.height);
            child.measure(childWidthSpec, childHeightSpec);
            if (child == this.mExpandButton && this.mShowExpandButtonAtEnd || child == this.mProfileBadge || child == this.mAppOps || child == this.mTransferChip) {
                iconWidth += lp.leftMargin + lp.rightMargin + child.getMeasuredWidth();
                continue;
            }
            totalWidth += lp.leftMargin + lp.rightMargin + child.getMeasuredWidth();
        }
        int endMargin = Math.max(this.mHeaderTextMarginEnd, iconWidth);
        if (totalWidth > givenWidth - endMargin) {
            int overFlow = totalWidth - givenWidth + endMargin;
            overFlow = this.shrinkViewForOverflow(wrapContentHeightSpec, overFlow, this.mAppName, this.mChildMinWidth);
            overFlow = this.shrinkViewForOverflow(wrapContentHeightSpec, overFlow, this.mHeaderText, 0);
            this.shrinkViewForOverflow(wrapContentHeightSpec, overFlow, this.mSecondaryHeaderText, 0);
        }
        this.mTotalWidth = Math.min(totalWidth += this.getPaddingEnd(), givenWidth);
        this.setMeasuredDimension(givenWidth, givenHeight);
    }

    private int shrinkViewForOverflow(int heightSpec, int overFlow, View targetView, int minimumWidth) {
        int oldWidth = targetView.getMeasuredWidth();
        if (overFlow > 0 && targetView.getVisibility() != 8 && oldWidth > minimumWidth) {
            int newSize = Math.max(minimumWidth, oldWidth - overFlow);
            int childWidthSpec = View.MeasureSpec.makeMeasureSpec(newSize, Integer.MIN_VALUE);
            targetView.measure(childWidthSpec, heightSpec);
            overFlow -= oldWidth - newSize;
        }
        return overFlow;
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        boolean centerAligned;
        int left = this.getPaddingStart();
        int end = this.getMeasuredWidth();
        boolean bl = centerAligned = (this.mGravity & 1) != 0;
        if (centerAligned) {
            left += this.getMeasuredWidth() / 2 - this.mTotalWidth / 2;
        }
        int childCount = this.getChildCount();
        int ownHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        for (int i = 0; i < childCount; ++i) {
            int layoutLeft;
            int layoutRight;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childHeight = child.getMeasuredHeight();
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int top = (int)((float)this.getPaddingTop() + (float)(ownHeight - childHeight) / 2.0f);
            int bottom = top + childHeight;
            if (child == this.mExpandButton && this.mShowExpandButtonAtEnd || child == this.mProfileBadge || child == this.mAppOps || child == this.mTransferChip) {
                layoutRight = end == this.getMeasuredWidth() ? end - this.mContentEndMargin : end - params.getMarginEnd();
                layoutLeft = layoutRight - child.getMeasuredWidth();
                end = layoutLeft - params.getMarginStart();
            } else {
                int right = (left += params.getMarginStart()) + child.getMeasuredWidth();
                layoutLeft = left;
                layoutRight = right;
                left = right + params.getMarginEnd();
            }
            if (this.getLayoutDirection() == 1) {
                int ltrLeft = layoutLeft;
                layoutLeft = this.getWidth() - layoutRight;
                layoutRight = this.getWidth() - ltrLeft;
            }
            child.layout(layoutLeft, top, layoutRight, bottom);
        }
        this.updateTouchListener();
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    public void setHeaderBackgroundDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            this.setWillNotDraw(false);
            this.mBackground = drawable2;
            this.mBackground.setCallback(this);
            this.setOutlineProvider(this.mProvider);
        } else {
            this.setWillNotDraw(true);
            this.mBackground = null;
            this.setOutlineProvider(null);
        }
        this.invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mBackground != null) {
            this.mBackground.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.mBackground.draw(canvas);
        }
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mBackground;
    }

    @Override
    protected void drawableStateChanged() {
        if (this.mBackground != null && this.mBackground.isStateful()) {
            this.mBackground.setState(this.getDrawableState());
        }
    }

    private void updateTouchListener() {
        if (this.mExpandClickListener == null && this.mAppOpsListener == null) {
            this.setOnTouchListener(null);
            return;
        }
        this.setOnTouchListener(this.mTouchListener);
        this.mTouchListener.bindTouchRects();
    }

    public void setAppOpsOnClickListener(View.OnClickListener l) {
        this.mAppOpsListener = l;
        this.updateTouchListener();
    }

    @Override
    public void setOnClickListener(View.OnClickListener l) {
        this.mExpandClickListener = l;
        this.mExpandButton.setOnClickListener(this.mExpandClickListener);
        this.updateTouchListener();
    }

    public int getOriginalIconColor() {
        return this.mIcon.getOriginalIconColor();
    }

    public int getOriginalNotificationColor() {
        return this.mExpandButton.getOriginalNotificationColor();
    }

    @RemotableViewMethod
    public void setExpanded(boolean expanded) {
        this.mExpanded = expanded;
        this.updateExpandButton();
    }

    private void updateExpandButton() {
        int contentDescriptionId;
        int drawableId;
        if (this.mExpanded) {
            drawableId = 17302368;
            contentDescriptionId = 17040119;
        } else {
            drawableId = 17302427;
            contentDescriptionId = 17040118;
        }
        this.mExpandButton.setImageDrawable(this.getContext().getDrawable(drawableId));
        this.mExpandButton.setColorFilter(this.getOriginalNotificationColor());
        this.mExpandButton.setContentDescription(this.mContext.getText(contentDescriptionId));
    }

    public void setShowWorkBadgeAtEnd(boolean showWorkBadgeAtEnd) {
        if (showWorkBadgeAtEnd != this.mShowWorkBadgeAtEnd) {
            this.setClipToPadding(!showWorkBadgeAtEnd);
            this.mShowWorkBadgeAtEnd = showWorkBadgeAtEnd;
        }
    }

    public void setShowExpandButtonAtEnd(boolean showExpandButtonAtEnd) {
        if (showExpandButtonAtEnd != this.mShowExpandButtonAtEnd) {
            this.setClipToPadding(!showExpandButtonAtEnd);
            this.mShowExpandButtonAtEnd = showExpandButtonAtEnd;
        }
    }

    public View getWorkProfileIcon() {
        return this.mProfileBadge;
    }

    public CachingIconView getIcon() {
        return this.mIcon;
    }

    @RemotableViewMethod
    public void setHeaderTextMarginEnd(int headerTextMarginEnd) {
        if (this.mHeaderTextMarginEnd != headerTextMarginEnd) {
            this.mHeaderTextMarginEnd = headerTextMarginEnd;
            this.requestLayout();
        }
    }

    public int getHeaderTextMarginEnd() {
        return this.mHeaderTextMarginEnd;
    }

    private View getFirstChildNotGone() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            return child;
        }
        return this;
    }

    public ImageView getExpandButton() {
        return this.mExpandButton;
    }

    @Override
    public boolean hasOverlappingRendering() {
        return false;
    }

    public boolean isInTouchRect(float x, float y) {
        if (this.mExpandClickListener == null) {
            return false;
        }
        return this.mTouchListener.isInside(x, y);
    }

    @RemotableViewMethod
    public void setAcceptAllTouches(boolean acceptAllTouches) {
        this.mAcceptAllTouches = this.mEntireHeaderClickable || acceptAllTouches;
    }

    @RemotableViewMethod
    public void setExpandOnlyOnButton(boolean expandOnlyOnButton) {
        this.mExpandOnlyOnButton = expandOnlyOnButton;
    }

    public class HeaderTouchListener
    implements View.OnTouchListener {
        private final ArrayList<Rect> mTouchRects = new ArrayList();
        private Rect mExpandButtonRect;
        private Rect mAppOpsRect;
        private int mTouchSlop;
        private boolean mTrackGesture;
        private float mDownX;
        private float mDownY;

        public void bindTouchRects() {
            this.mTouchRects.clear();
            this.addRectAroundView(NotificationHeaderView.this.mIcon);
            this.mExpandButtonRect = this.addRectAroundView(NotificationHeaderView.this.mExpandButton);
            this.mAppOpsRect = this.addRectAroundView(NotificationHeaderView.this.mAppOps);
            NotificationHeaderView.this.setTouchDelegate(new TouchDelegate(this.mAppOpsRect, NotificationHeaderView.this.mAppOps));
            this.addWidthRect();
            this.mTouchSlop = ViewConfiguration.get(NotificationHeaderView.this.getContext()).getScaledTouchSlop();
        }

        private void addWidthRect() {
            Rect r = new Rect();
            r.top = 0;
            r.bottom = (int)(32.0f * NotificationHeaderView.this.getResources().getDisplayMetrics().density);
            r.left = 0;
            r.right = NotificationHeaderView.this.getWidth();
            this.mTouchRects.add(r);
        }

        private Rect addRectAroundView(View view) {
            Rect r = this.getRectAroundView(view);
            this.mTouchRects.add(r);
            return r;
        }

        private Rect getRectAroundView(View view) {
            float size = 48.0f * NotificationHeaderView.this.getResources().getDisplayMetrics().density;
            float width = Math.max(size, (float)view.getWidth());
            float height = Math.max(size, (float)view.getHeight());
            Rect r = new Rect();
            if (view.getVisibility() == 8) {
                view = NotificationHeaderView.this.getFirstChildNotGone();
                r.left = (int)((float)view.getLeft() - width / 2.0f);
            } else {
                r.left = (int)((float)(view.getLeft() + view.getRight()) / 2.0f - width / 2.0f);
            }
            r.top = (int)((float)(view.getTop() + view.getBottom()) / 2.0f - height / 2.0f);
            r.bottom = (int)((float)r.top + height);
            r.right = (int)((float)r.left + width);
            return r;
        }

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            float x = event.getX();
            float y = event.getY();
            switch (event.getActionMasked() & 0xFF) {
                case 0: {
                    this.mTrackGesture = false;
                    if (!this.isInside(x, y)) break;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mTrackGesture = true;
                    return true;
                }
                case 2: {
                    if (!this.mTrackGesture || !(Math.abs(this.mDownX - x) > (float)this.mTouchSlop) && !(Math.abs(this.mDownY - y) > (float)this.mTouchSlop)) break;
                    this.mTrackGesture = false;
                    break;
                }
                case 1: {
                    if (!this.mTrackGesture) break;
                    if (NotificationHeaderView.this.mAppOps.isVisibleToUser() && (this.mAppOpsRect.contains((int)x, (int)y) || this.mAppOpsRect.contains((int)this.mDownX, (int)this.mDownY))) {
                        NotificationHeaderView.this.mAppOps.performClick();
                        return true;
                    }
                    NotificationHeaderView.this.mExpandButton.performClick();
                }
            }
            return this.mTrackGesture;
        }

        private boolean isInside(float x, float y) {
            if (NotificationHeaderView.this.mAcceptAllTouches) {
                return true;
            }
            if (NotificationHeaderView.this.mExpandOnlyOnButton) {
                return this.mExpandButtonRect.contains((int)x, (int)y);
            }
            for (int i = 0; i < this.mTouchRects.size(); ++i) {
                Rect r = this.mTouchRects.get(i);
                if (!r.contains((int)x, (int)y)) continue;
                return true;
            }
            return false;
        }
    }
}

