/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.IInputFilterHost;
import android.view.InputEvent;

public interface IInputFilter
extends IInterface {
    public void install(IInputFilterHost var1) throws RemoteException;

    public void uninstall() throws RemoteException;

    public void filterInputEvent(InputEvent var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputFilter {
        private static final String DESCRIPTOR = "android.view.IInputFilter";
        static final int TRANSACTION_install = 1;
        static final int TRANSACTION_uninstall = 2;
        static final int TRANSACTION_filterInputEvent = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputFilter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputFilter) {
                return (IInputFilter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "install";
                }
                case 2: {
                    return "uninstall";
                }
                case 3: {
                    return "filterInputEvent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IInputFilterHost _arg0 = IInputFilterHost.Stub.asInterface(data.readStrongBinder());
                    this.install(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.uninstall();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    InputEvent _arg0 = 0 != data.readInt() ? InputEvent.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.filterInputEvent(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IInputFilter impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IInputFilter getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IInputFilter {
            private IBinder mRemote;
            public static IInputFilter sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void install(IInputFilterHost host) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(host != null ? host.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().install(host);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void uninstall() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().uninstall();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void filterInputEvent(InputEvent event, int policyFlags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(policyFlags);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().filterInputEvent(event, policyFlags);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputFilter {
        @Override
        public void install(IInputFilterHost host) throws RemoteException {
        }

        @Override
        public void uninstall() throws RemoteException {
        }

        @Override
        public void filterInputEvent(InputEvent event, int policyFlags) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

