/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.DisplayCutout;
import android.view.Surface;
import java.util.Objects;

public class DisplayAdjustments {
    public static final DisplayAdjustments DEFAULT_DISPLAY_ADJUSTMENTS = new DisplayAdjustments();
    private volatile CompatibilityInfo mCompatInfo = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
    private final Configuration mConfiguration = new Configuration(Configuration.EMPTY);
    private FixedRotationAdjustments mFixedRotationAdjustments;

    @UnsupportedAppUsage
    public DisplayAdjustments() {
    }

    public DisplayAdjustments(Configuration configuration) {
        if (configuration != null) {
            this.mConfiguration.setTo(configuration);
        }
    }

    public DisplayAdjustments(DisplayAdjustments daj) {
        this.setCompatibilityInfo(daj.mCompatInfo);
        this.mConfiguration.setTo(daj.getConfiguration());
        this.mFixedRotationAdjustments = daj.mFixedRotationAdjustments;
    }

    @UnsupportedAppUsage
    public void setCompatibilityInfo(CompatibilityInfo compatInfo) {
        if (this == DEFAULT_DISPLAY_ADJUSTMENTS) {
            throw new IllegalArgumentException("setCompatbilityInfo: Cannot modify DEFAULT_DISPLAY_ADJUSTMENTS");
        }
        this.mCompatInfo = compatInfo != null && (compatInfo.isScalingRequired() || !compatInfo.supportsScreen()) ? compatInfo : CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return this.mCompatInfo;
    }

    public void setConfiguration(Configuration configuration) {
        if (this == DEFAULT_DISPLAY_ADJUSTMENTS) {
            throw new IllegalArgumentException("setConfiguration: Cannot modify DEFAULT_DISPLAY_ADJUSTMENTS");
        }
        this.mConfiguration.setTo(configuration != null ? configuration : Configuration.EMPTY);
    }

    @UnsupportedAppUsage
    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public void setFixedRotationAdjustments(FixedRotationAdjustments fixedRotationAdjustments) {
        this.mFixedRotationAdjustments = fixedRotationAdjustments;
    }

    public FixedRotationAdjustments getFixedRotationAdjustments() {
        return this.mFixedRotationAdjustments;
    }

    private boolean noFlip(int realRotation) {
        FixedRotationAdjustments rotationAdjustments = this.mFixedRotationAdjustments;
        if (rotationAdjustments == null) {
            return true;
        }
        return (realRotation - rotationAdjustments.mRotation + 4) % 2 == 0;
    }

    public void adjustSize(Point size, int realRotation) {
        if (this.noFlip(realRotation)) {
            return;
        }
        int w = size.x;
        size.x = size.y;
        size.y = w;
    }

    public void adjustMetrics(DisplayMetrics metrics, int realRotation) {
        if (this.noFlip(realRotation)) {
            return;
        }
        int w = metrics.widthPixels;
        metrics.widthPixels = metrics.heightPixels;
        metrics.heightPixels = w;
        w = metrics.noncompatWidthPixels;
        metrics.noncompatWidthPixels = metrics.noncompatHeightPixels;
        metrics.noncompatHeightPixels = w;
        float x = metrics.xdpi;
        metrics.xdpi = metrics.ydpi;
        metrics.ydpi = x;
        x = metrics.noncompatXdpi;
        metrics.noncompatXdpi = metrics.noncompatYdpi;
        metrics.noncompatYdpi = x;
    }

    public DisplayCutout getDisplayCutout(DisplayCutout realCutout) {
        FixedRotationAdjustments rotationAdjustments = this.mFixedRotationAdjustments;
        return rotationAdjustments != null && rotationAdjustments.mRotatedDisplayCutout != null ? rotationAdjustments.mRotatedDisplayCutout : realCutout;
    }

    public int getRotation(int realRotation) {
        FixedRotationAdjustments rotationAdjustments = this.mFixedRotationAdjustments;
        return rotationAdjustments != null ? rotationAdjustments.mRotation : realRotation;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + Objects.hashCode(this.mCompatInfo);
        hash = hash * 31 + Objects.hashCode(this.mConfiguration);
        hash = hash * 31 + Objects.hashCode(this.mFixedRotationAdjustments);
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DisplayAdjustments)) {
            return false;
        }
        DisplayAdjustments daj = (DisplayAdjustments)o;
        return Objects.equals(daj.mCompatInfo, this.mCompatInfo) && Objects.equals(daj.mConfiguration, this.mConfiguration) && Objects.equals(daj.mFixedRotationAdjustments, this.mFixedRotationAdjustments);
    }

    public static class FixedRotationAdjustments
    implements Parcelable {
        final int mRotation;
        final DisplayCutout mRotatedDisplayCutout;
        public static final Parcelable.Creator<FixedRotationAdjustments> CREATOR = new Parcelable.Creator<FixedRotationAdjustments>(){

            @Override
            public FixedRotationAdjustments createFromParcel(Parcel in) {
                return new FixedRotationAdjustments(in);
            }

            public FixedRotationAdjustments[] newArray(int size) {
                return new FixedRotationAdjustments[size];
            }
        };

        public FixedRotationAdjustments(int rotation, DisplayCutout cutout) {
            this.mRotation = rotation;
            this.mRotatedDisplayCutout = cutout;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.mRotation;
            hash = hash * 31 + Objects.hashCode(this.mRotatedDisplayCutout);
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FixedRotationAdjustments)) {
                return false;
            }
            FixedRotationAdjustments other = (FixedRotationAdjustments)o;
            return this.mRotation == other.mRotation && Objects.equals(this.mRotatedDisplayCutout, other.mRotatedDisplayCutout);
        }

        public String toString() {
            return "FixedRotationAdjustments{rotation=" + Surface.rotationToString(this.mRotation) + " cutout=" + this.mRotatedDisplayCutout + "}";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRotation);
            dest.writeTypedObject(new DisplayCutout.ParcelableWrapper(this.mRotatedDisplayCutout), flags);
        }

        private FixedRotationAdjustments(Parcel in) {
            this.mRotation = in.readInt();
            DisplayCutout.ParcelableWrapper cutoutWrapper = in.readTypedObject(DisplayCutout.ParcelableWrapper.CREATOR);
            this.mRotatedDisplayCutout = cutoutWrapper != null ? cutoutWrapper.get() : null;
        }
    }
}

