/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.content.pm.PackageParser;
import android.content.pm.Signature;
import android.os.Trace;
import android.util.apk.ApkSignatureSchemeV2Verifier;
import android.util.apk.ApkSignatureSchemeV3Verifier;
import android.util.apk.ApkSignatureSchemeV4Verifier;
import android.util.apk.ByteBufferFactory;
import android.util.apk.SignatureNotFoundException;
import android.util.jar.StrictJarFile;
import com.android.internal.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import libcore.io.IoUtils;

public class ApkSignatureVerifier {
    private static final AtomicReference<byte[]> sBuffer = new AtomicReference();

    public static PackageParser.SigningDetails verify(String apkPath, @PackageParser.SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion) throws PackageParser.PackageParserException {
        return ApkSignatureVerifier.verifySignatures(apkPath, minSignatureSchemeVersion, true);
    }

    public static PackageParser.SigningDetails unsafeGetCertsWithoutVerification(String apkPath, int minSignatureSchemeVersion) throws PackageParser.PackageParserException {
        return ApkSignatureVerifier.verifySignatures(apkPath, minSignatureSchemeVersion, false);
    }

    private static PackageParser.SigningDetails verifySignatures(String apkPath, @PackageParser.SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion, boolean verifyFull) throws PackageParser.PackageParserException {
        if (minSignatureSchemeVersion > 4) {
            throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
        }
        try {
            return ApkSignatureVerifier.verifyV4Signature(apkPath, minSignatureSchemeVersion, verifyFull);
        }
        catch (SignatureNotFoundException e) {
            if (minSignatureSchemeVersion >= 4) {
                throw new PackageParser.PackageParserException(-103, "No APK Signature Scheme v4 signature in package " + apkPath, e);
            }
            if (minSignatureSchemeVersion > 3) {
                throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
            }
            return ApkSignatureVerifier.verifyV3AndBelowSignatures(apkPath, minSignatureSchemeVersion, verifyFull);
        }
    }

    private static PackageParser.SigningDetails verifyV3AndBelowSignatures(String apkPath, @PackageParser.SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion, boolean verifyFull) throws PackageParser.PackageParserException {
        try {
            return ApkSignatureVerifier.verifyV3Signature(apkPath, verifyFull);
        }
        catch (SignatureNotFoundException e) {
            if (minSignatureSchemeVersion >= 3) {
                throw new PackageParser.PackageParserException(-103, "No APK Signature Scheme v3 signature in package " + apkPath, e);
            }
            if (minSignatureSchemeVersion > 2) {
                throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
            }
            try {
                return ApkSignatureVerifier.verifyV2Signature(apkPath, verifyFull);
            }
            catch (SignatureNotFoundException e2) {
                if (minSignatureSchemeVersion >= 2) {
                    throw new PackageParser.PackageParserException(-103, "No APK Signature Scheme v2 signature in package " + apkPath, e2);
                }
                if (minSignatureSchemeVersion > 1) {
                    throw new PackageParser.PackageParserException(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
                }
                return ApkSignatureVerifier.verifyV1Signature(apkPath, verifyFull);
            }
        }
    }

    private static PackageParser.SigningDetails verifyV4Signature(String apkPath, @PackageParser.SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion, boolean verifyFull) throws SignatureNotFoundException, PackageParser.PackageParserException {
        Trace.traceBegin(262144L, verifyFull ? "verifyV4" : "certsOnlyV4");
        try {
            ApkSignatureSchemeV4Verifier.VerifiedSigner vSigner = ApkSignatureSchemeV4Verifier.extractCertificates(apkPath);
            Certificate[][] signerCerts = new Certificate[][]{vSigner.certs};
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            if (verifyFull) {
                byte[] nonstreamingDigest = null;
                Certificate[][] nonstreamingCerts = null;
                try {
                    ApkSignatureSchemeV3Verifier.VerifiedSigner v3Signer = ApkSignatureSchemeV3Verifier.unsafeGetCertsWithoutVerification(apkPath);
                    nonstreamingDigest = v3Signer.digest;
                    nonstreamingCerts = new Certificate[][]{v3Signer.certs};
                }
                catch (SignatureNotFoundException e) {
                    try {
                        ApkSignatureSchemeV2Verifier.VerifiedSigner v2Signer = ApkSignatureSchemeV2Verifier.verify(apkPath, false);
                        nonstreamingDigest = v2Signer.digest;
                        nonstreamingCerts = v2Signer.certs;
                    }
                    catch (SignatureNotFoundException ee) {
                        throw new SecurityException("V4 verification failed to collect V2/V3 certificates from : " + apkPath, ee);
                    }
                }
                Signature[] nonstreamingSigs = ApkSignatureVerifier.convertToSignatures(nonstreamingCerts);
                if (nonstreamingSigs.length != signerSigs.length) {
                    throw new SecurityException("Invalid number of certificates: " + nonstreamingSigs.length);
                }
                int size = signerSigs.length;
                for (int i = 0; i < size; ++i) {
                    if (nonstreamingSigs[i].equals(signerSigs[i])) continue;
                    throw new SecurityException("V4 signature certificate does not match V2/V3");
                }
                if (!ArrayUtils.equals(vSigner.apkDigest, nonstreamingDigest, vSigner.apkDigest.length)) {
                    throw new SecurityException("APK digest in V4 signature does not match V2/V3");
                }
            }
            PackageParser.SigningDetails signingDetails = new PackageParser.SigningDetails(signerSigs, 4);
            return signingDetails;
        }
        catch (SignatureNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PackageParser.PackageParserException(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v4", e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    private static PackageParser.SigningDetails verifyV3Signature(String apkPath, boolean verifyFull) throws SignatureNotFoundException, PackageParser.PackageParserException {
        Trace.traceBegin(262144L, verifyFull ? "verifyV3" : "certsOnlyV3");
        try {
            ApkSignatureSchemeV3Verifier.VerifiedSigner vSigner = verifyFull ? ApkSignatureSchemeV3Verifier.verify(apkPath) : ApkSignatureSchemeV3Verifier.unsafeGetCertsWithoutVerification(apkPath);
            Certificate[][] signerCerts = new Certificate[][]{vSigner.certs};
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            Signature[] pastSignerSigs = null;
            if (vSigner.por != null) {
                pastSignerSigs = new Signature[vSigner.por.certs.size()];
                for (int i = 0; i < pastSignerSigs.length; ++i) {
                    pastSignerSigs[i] = new Signature(vSigner.por.certs.get(i).getEncoded());
                    pastSignerSigs[i].setFlags(vSigner.por.flagsList.get(i));
                }
            }
            PackageParser.SigningDetails signingDetails = new PackageParser.SigningDetails(signerSigs, 3, pastSignerSigs);
            return signingDetails;
        }
        catch (SignatureNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PackageParser.PackageParserException(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v3", e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    private static PackageParser.SigningDetails verifyV2Signature(String apkPath, boolean verifyFull) throws SignatureNotFoundException, PackageParser.PackageParserException {
        Trace.traceBegin(262144L, verifyFull ? "verifyV2" : "certsOnlyV2");
        try {
            Certificate[][] signerCerts = verifyFull ? ApkSignatureSchemeV2Verifier.verify(apkPath) : ApkSignatureSchemeV2Verifier.unsafeGetCertsWithoutVerification(apkPath);
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            PackageParser.SigningDetails signingDetails = new PackageParser.SigningDetails(signerSigs, 2);
            return signingDetails;
        }
        catch (SignatureNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PackageParser.PackageParserException(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v2", e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PackageParser.SigningDetails verifyV1Signature(String apkPath, boolean verifyFull) throws PackageParser.PackageParserException {
        PackageParser.SigningDetails signingDetails;
        StrictJarFile jarFile = null;
        try {
            Trace.traceBegin(262144L, "strictJarFileCtor");
            jarFile = new StrictJarFile(apkPath, true, verifyFull);
            ArrayList<ZipEntry> toVerify = new ArrayList<ZipEntry>();
            ZipEntry manifestEntry = jarFile.findEntry("AndroidManifest.xml");
            if (manifestEntry == null) {
                throw new PackageParser.PackageParserException(-101, "Package " + apkPath + " has no manifest");
            }
            Certificate[][] lastCerts = ApkSignatureVerifier.loadCertificates(jarFile, manifestEntry);
            if (ArrayUtils.isEmpty(lastCerts)) {
                throw new PackageParser.PackageParserException(-103, "Package " + apkPath + " has no certificates at entry " + "AndroidManifest.xml");
            }
            Signature[] lastSigs = ApkSignatureVerifier.convertToSignatures(lastCerts);
            if (verifyFull) {
                Iterator<ZipEntry> i = jarFile.iterator();
                while (i.hasNext()) {
                    String entryName;
                    ZipEntry entry = i.next();
                    if (entry.isDirectory() || (entryName = entry.getName()).startsWith("META-INF/") || entryName.equals("AndroidManifest.xml")) continue;
                    toVerify.add(entry);
                }
                for (ZipEntry entry : toVerify) {
                    Certificate[][] entryCerts = ApkSignatureVerifier.loadCertificates(jarFile, entry);
                    if (ArrayUtils.isEmpty(entryCerts)) {
                        throw new PackageParser.PackageParserException(-103, "Package " + apkPath + " has no certificates at entry " + entry.getName());
                    }
                    Signature[] entrySigs = ApkSignatureVerifier.convertToSignatures(entryCerts);
                    if (Signature.areExactMatch(lastSigs, entrySigs)) continue;
                    throw new PackageParser.PackageParserException(-104, "Package " + apkPath + " has mismatched certificates at entry " + entry.getName());
                }
            }
            signingDetails = new PackageParser.SigningDetails(lastSigs, 1);
        }
        catch (GeneralSecurityException e) {
            try {
                throw new PackageParser.PackageParserException(-105, "Failed to collect certificates from " + apkPath, e);
                catch (IOException | RuntimeException e2) {
                    throw new PackageParser.PackageParserException(-103, "Failed to collect certificates from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                Trace.traceEnd(262144L);
                ApkSignatureVerifier.closeQuietly(jarFile);
                throw throwable;
            }
        }
        Trace.traceEnd(262144L);
        ApkSignatureVerifier.closeQuietly(jarFile);
        return signingDetails;
    }

    private static Certificate[][] loadCertificates(StrictJarFile jarFile, ZipEntry entry) throws PackageParser.PackageParserException {
        InputStream is = null;
        try {
            is = jarFile.getInputStream(entry);
            ApkSignatureVerifier.readFullyIgnoringContents(is);
            Certificate[][] certificateArray = jarFile.getCertificateChains(entry);
            return certificateArray;
        }
        catch (IOException | RuntimeException e) {
            throw new PackageParser.PackageParserException(-102, "Failed reading " + entry.getName() + " in " + jarFile, e);
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    private static void readFullyIgnoringContents(InputStream in) throws IOException {
        byte[] buffer = sBuffer.getAndSet(null);
        if (buffer == null) {
            buffer = new byte[4096];
        }
        int n = 0;
        int count = 0;
        while ((n = in.read(buffer, 0, buffer.length)) != -1) {
            count += n;
        }
        sBuffer.set(buffer);
    }

    private static Signature[] convertToSignatures(Certificate[][] certs) throws CertificateEncodingException {
        Signature[] res = new Signature[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            res[i] = new Signature(certs[i]);
        }
        return res;
    }

    private static void closeQuietly(StrictJarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getMinimumSignatureSchemeVersionForTargetSdk(int targetSdk) {
        if (targetSdk >= 30) {
            return 2;
        }
        return 1;
    }

    public static byte[] getVerityRootHash(String apkPath) throws IOException, SecurityException {
        try {
            return ApkSignatureSchemeV3Verifier.getVerityRootHash(apkPath);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            try {
                return ApkSignatureSchemeV2Verifier.getVerityRootHash(apkPath);
            }
            catch (SignatureNotFoundException e) {
                return null;
            }
        }
    }

    public static byte[] generateApkVerity(String apkPath, ByteBufferFactory bufferFactory) throws IOException, SignatureNotFoundException, SecurityException, DigestException, NoSuchAlgorithmException {
        try {
            return ApkSignatureSchemeV3Verifier.generateApkVerity(apkPath, bufferFactory);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            return ApkSignatureSchemeV2Verifier.generateApkVerity(apkPath, bufferFactory);
        }
    }

    public static byte[] generateApkVerityRootHash(String apkPath) throws NoSuchAlgorithmException, DigestException, IOException {
        try {
            return ApkSignatureSchemeV3Verifier.generateApkVerityRootHash(apkPath);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            try {
                return ApkSignatureSchemeV2Verifier.generateApkVerityRootHash(apkPath);
            }
            catch (SignatureNotFoundException e) {
                return null;
            }
        }
    }

    public static class Result {
        public final Certificate[][] certs;
        public final Signature[] sigs;
        public final int signatureSchemeVersion;

        public Result(Certificate[][] certs, Signature[] sigs, int signingVersion) {
            this.certs = certs;
            this.sigs = sigs;
            this.signatureSchemeVersion = signingVersion;
        }
    }
}

