/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.net.Uri;
import android.os.Binder;
import android.telephony.ims.ImsException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.aidl.IImsRegistrationCallback;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public interface RegistrationManager {
    public static final int REGISTRATION_STATE_NOT_REGISTERED = 0;
    public static final int REGISTRATION_STATE_REGISTERING = 1;
    public static final int REGISTRATION_STATE_REGISTERED = 2;
    public static final Map<Integer, Integer> IMS_REG_TO_ACCESS_TYPE_MAP = new HashMap<Integer, Integer>(){
        {
            this.put(-1, -1);
            this.put(0, 1);
            this.put(1, 2);
        }
    };

    public void registerImsRegistrationCallback(Executor var1, RegistrationCallback var2) throws ImsException;

    public void unregisterImsRegistrationCallback(RegistrationCallback var1);

    public void getRegistrationState(Executor var1, Consumer<Integer> var2);

    public void getRegistrationTransportType(Executor var1, Consumer<Integer> var2);

    public static class RegistrationCallback {
        private final RegistrationBinder mBinder = new RegistrationBinder(this);

        public void onRegistered(int imsTransportType) {
        }

        public void onRegistering(int imsTransportType) {
        }

        public void onUnregistered(ImsReasonInfo info) {
        }

        public void onTechnologyChangeFailed(int imsTransportType, ImsReasonInfo info) {
        }

        public void onSubscriberAssociatedUriChanged(Uri[] uris) {
        }

        public IImsRegistrationCallback getBinder() {
            return this.mBinder;
        }

        public void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class RegistrationBinder
        extends IImsRegistrationCallback.Stub {
            private final RegistrationCallback mLocalCallback;
            private Executor mExecutor;

            RegistrationBinder(RegistrationCallback localCallback) {
                this.mLocalCallback = localCallback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistered(int imsRadioTech) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onRegistered(RegistrationBinder.getAccessType(imsRadioTech)));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistering(int imsRadioTech) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onRegistering(RegistrationBinder.getAccessType(imsRadioTech)));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeregistered(ImsReasonInfo info) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onUnregistered(info));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTechnologyChangeFailed(int imsRadioTech, ImsReasonInfo info) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onTechnologyChangeFailed(RegistrationBinder.getAccessType(imsRadioTech), info));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubscriberAssociatedUriChanged(Uri[] uris) {
                if (this.mLocalCallback == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onSubscriberAssociatedUriChanged(uris));
                }
                finally {
                    RegistrationBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }

            private static int getAccessType(int regType) {
                if (!IMS_REG_TO_ACCESS_TYPE_MAP.containsKey(regType)) {
                    Log.w("RegistrationManager", "RegistrationBinder - invalid regType returned: " + regType);
                    return -1;
                }
                return IMS_REG_TO_ACCESS_TYPE_MAP.get(regType);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsRegistrationState {
    }
}

