/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.content.Context;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.ims.ImsException;
import android.telephony.ims.RcsContactUceCapability;
import android.telephony.ims.aidl.IImsRcsController;
import android.telephony.ims.aidl.IRcsUceControllerCallback;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;

public class RcsUceAdapter {
    private static final String TAG = "RcsUceAdapter";
    public static final int ERROR_GENERIC_FAILURE = 1;
    public static final int ERROR_NOT_ENABLED = 2;
    public static final int ERROR_NOT_AVAILABLE = 3;
    public static final int ERROR_NOT_REGISTERED = 4;
    public static final int ERROR_NOT_AUTHORIZED = 5;
    public static final int ERROR_FORBIDDEN = 6;
    public static final int ERROR_NOT_FOUND = 7;
    public static final int ERROR_REQUEST_TOO_LARGE = 8;
    public static final int ERROR_REQUEST_TIMEOUT = 10;
    public static final int ERROR_INSUFFICIENT_MEMORY = 11;
    public static final int ERROR_LOST_NETWORK = 12;
    public static final int ERROR_ALREADY_IN_QUEUE = 13;
    public static final int PUBLISH_STATE_OK = 1;
    public static final int PUBLISH_STATE_NOT_PUBLISHED = 2;
    public static final int PUBLISH_STATE_VOLTE_PROVISION_ERROR = 3;
    public static final int PUBLISH_STATE_RCS_PROVISION_ERROR = 4;
    public static final int PUBLISH_STATE_REQUEST_TIMEOUT = 5;
    public static final int PUBLISH_STATE_OTHER_ERROR = 6;
    private final Context mContext;
    private final int mSubId;

    RcsUceAdapter(Context context, int subId) {
        this.mContext = context;
        this.mSubId = subId;
    }

    public void requestCapabilities(final Executor executor, List<Uri> contactNumbers, final CapabilitiesCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null AvailabilityCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        if (contactNumbers == null) {
            throw new IllegalArgumentException("Must include non-null contact number list.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "requestCapabilities: IImsRcsController is null");
            throw new ImsException("Can not find remote IMS service", 1);
        }
        IRcsUceControllerCallback.Stub internalCallback = new IRcsUceControllerCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilitiesReceived(List<RcsContactUceCapability> contactCapabilities) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> c.onCapabilitiesReceived(contactCapabilities));
                }
                finally {
                    1.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int errorCode) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> c.onError(errorCode));
                }
                finally {
                    1.restoreCallingIdentity(callingIdentity);
                }
            }
        };
        try {
            imsRcsController.requestCapabilities(this.mSubId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), contactNumbers, internalCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#requestCapabilities", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    public int getUcePublishState() throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "getUcePublishState: IImsRcsController is null");
            throw new ImsException("Can not find remote IMS service", 1);
        }
        try {
            return imsRcsController.getUcePublishState(this.mSubId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#getUcePublishState", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    public boolean isUceSettingEnabled() throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "isUceSettingEnabled: IImsRcsController is null");
            throw new ImsException("Can not find remote IMS service", 1);
        }
        try {
            return imsRcsController.isUceSettingEnabled(this.mSubId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#isUceSettingEnabled", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    @SystemApi
    public void setUceSettingEnabled(boolean isEnabled) throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "setUceSettingEnabled: IImsRcsController is null");
            throw new ImsException("Can not find remote IMS service", 1);
        }
        try {
            imsRcsController.setUceSettingEnabled(this.mSubId, isEnabled);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#setUceSettingEnabled", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    private IImsRcsController getIImsRcsController() {
        IBinder binder = TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyImsServiceRegisterer().get();
        return IImsRcsController.Stub.asInterface(binder);
    }

    public static class CapabilitiesCallback {
        public void onCapabilitiesReceived(List<RcsContactUceCapability> contactCapabilities) {
        }

        public void onError(int errorCode) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PublishState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

