/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.nsd.WifiP2pServiceResponse;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WifiP2pDnsSdServiceResponse
extends WifiP2pServiceResponse {
    private String mDnsQueryName;
    private String mInstanceName;
    private int mDnsType;
    private int mVersion;
    private final HashMap<String, String> mTxtRecord = new HashMap();
    private static final Map<Integer, String> sVmpack = new HashMap<Integer, String>();

    public String getDnsQueryName() {
        return this.mDnsQueryName;
    }

    public int getDnsType() {
        return this.mDnsType;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public Map<String, String> getTxtRecord() {
        return this.mTxtRecord;
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("serviceType:DnsSd(").append(this.mServiceType).append(")");
        sbuf.append(" status:").append(WifiP2pServiceResponse.Status.toString(this.mStatus));
        sbuf.append(" srcAddr:").append(this.mDevice.deviceAddress);
        sbuf.append(" version:").append(String.format("%02x", this.mVersion));
        sbuf.append(" dnsName:").append(this.mDnsQueryName);
        sbuf.append(" TxtRecord:");
        for (String key : this.mTxtRecord.keySet()) {
            sbuf.append(" key:").append(key).append(" value:").append(this.mTxtRecord.get(key));
        }
        if (this.mInstanceName != null) {
            sbuf.append(" InsName:").append(this.mInstanceName);
        }
        return sbuf.toString();
    }

    protected WifiP2pDnsSdServiceResponse(int status, int tranId, WifiP2pDevice dev, byte[] data) {
        super(1, status, tranId, dev, data);
        if (!this.parse()) {
            throw new IllegalArgumentException("Malformed bonjour service response");
        }
    }

    private boolean parse() {
        String rData;
        if (this.mData == null) {
            return true;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.mData));
        this.mDnsQueryName = this.readDnsName(dis);
        if (this.mDnsQueryName == null) {
            return false;
        }
        try {
            this.mDnsType = dis.readUnsignedShort();
            this.mVersion = dis.readUnsignedByte();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (this.mDnsType == 12) {
            rData = this.readDnsName(dis);
            if (rData == null) {
                return false;
            }
            if (rData.length() <= this.mDnsQueryName.length()) {
                return false;
            }
        } else {
            if (this.mDnsType == 16) {
                return this.readTxtData(dis);
            }
            return false;
        }
        this.mInstanceName = rData.substring(0, rData.length() - this.mDnsQueryName.length() - 1);
        return true;
    }

    private String readDnsName(DataInputStream dis) {
        StringBuffer sb = new StringBuffer();
        HashMap<Integer, String> vmpack = new HashMap<Integer, String>(sVmpack);
        if (this.mDnsQueryName != null) {
            vmpack.put(39, this.mDnsQueryName);
        }
        try {
            while (true) {
                int i;
                if ((i = dis.readUnsignedByte()) == 0) {
                    return sb.toString();
                }
                if (i == 192) {
                    String ref = vmpack.get(dis.readUnsignedByte());
                    if (ref == null) {
                        return null;
                    }
                    sb.append(ref);
                    return sb.toString();
                }
                byte[] data = new byte[i];
                dis.readFully(data);
                sb.append(new String(data));
                sb.append(".");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean readTxtData(DataInputStream dis) {
        try {
            int len;
            while (dis.available() > 0 && (len = dis.readUnsignedByte()) != 0) {
                byte[] data = new byte[len];
                dis.readFully(data);
                String[] keyVal = new String(data).split("=");
                if (keyVal.length != 2) {
                    return false;
                }
                this.mTxtRecord.put(keyVal[0], keyVal[1]);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    static WifiP2pDnsSdServiceResponse newInstance(int status, int transId, WifiP2pDevice dev, byte[] data) {
        if (status != 0) {
            return new WifiP2pDnsSdServiceResponse(status, transId, dev, null);
        }
        try {
            return new WifiP2pDnsSdServiceResponse(status, transId, dev, data);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        sVmpack.put(12, "_tcp.local.");
        sVmpack.put(17, "local.");
        sVmpack.put(28, "_udp.local.");
    }
}

