/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.ComponentName;
import android.content.pm.parsing.ParsingPackageImpl;
import android.content.pm.parsing.component.ParsedIntentInfo;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.Parcelling;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ParsedComponent
implements Parcelable {
    private static ParsedIntentInfo.ListParceler sForIntentInfos = Parcelling.Cache.getOrCreate(ParsedIntentInfo.ListParceler.class);
    private String name;
    int icon;
    int labelRes;
    CharSequence nonLocalizedLabel;
    int logo;
    int banner;
    int descriptionRes;
    int flags;
    private String packageName;
    private List<ParsedIntentInfo> intents;
    private ComponentName componentName;
    protected Bundle metaData;

    ParsedComponent() {
    }

    public ParsedComponent(ParsedComponent other) {
        this.metaData = other.metaData;
        this.name = other.name;
        this.icon = other.getIcon();
        this.labelRes = other.getLabelRes();
        this.nonLocalizedLabel = other.getNonLocalizedLabel();
        this.logo = other.getLogo();
        this.banner = other.getBanner();
        this.descriptionRes = other.getDescriptionRes();
        this.flags = other.getFlags();
        this.setPackageName(other.packageName);
        this.intents = new ArrayList<ParsedIntentInfo>(other.getIntents());
    }

    public void addIntent(ParsedIntentInfo intent) {
        this.intents = CollectionUtils.add(this.intents, intent);
    }

    public List<ParsedIntentInfo> getIntents() {
        return this.intents != null ? this.intents : Collections.emptyList();
    }

    public ParsedComponent setName(String name) {
        this.name = TextUtils.safeIntern(name);
        return this;
    }

    public void setPackageName(String packageName) {
        this.packageName = TextUtils.safeIntern(packageName);
        this.componentName = null;
    }

    public ComponentName getComponentName() {
        if (this.componentName == null) {
            this.componentName = new ComponentName(this.getPackageName(), this.getName());
        }
        return this.componentName;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeInt(this.getIcon());
        dest.writeInt(this.getLabelRes());
        dest.writeCharSequence(this.getNonLocalizedLabel());
        dest.writeInt(this.getLogo());
        dest.writeInt(this.getBanner());
        dest.writeInt(this.getDescriptionRes());
        dest.writeInt(this.getFlags());
        ParsingPackageImpl.sForInternedString.parcel(this.packageName, dest, flags);
        sForIntentInfos.parcel(this.getIntents(), dest, flags);
        dest.writeBundle(this.metaData);
    }

    protected ParsedComponent(Parcel in) {
        ClassLoader boot = Object.class.getClassLoader();
        this.name = in.readString();
        this.icon = in.readInt();
        this.labelRes = in.readInt();
        this.nonLocalizedLabel = in.readCharSequence();
        this.logo = in.readInt();
        this.banner = in.readInt();
        this.descriptionRes = in.readInt();
        this.flags = in.readInt();
        this.packageName = ParsingPackageImpl.sForInternedString.unparcel(in);
        this.intents = sForIntentInfos.unparcel(in);
        this.metaData = in.readBundle(boot);
    }

    public String getName() {
        return this.name;
    }

    public int getIcon() {
        return this.icon;
    }

    public int getLabelRes() {
        return this.labelRes;
    }

    public CharSequence getNonLocalizedLabel() {
        return this.nonLocalizedLabel;
    }

    public int getLogo() {
        return this.logo;
    }

    public int getBanner() {
        return this.banner;
    }

    public int getDescriptionRes() {
        return this.descriptionRes;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Bundle getMetaData() {
        return this.metaData;
    }
}

