/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.IProcessObserver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import java.util.List;

public abstract class HomeVisibilityObserver {
    private Context mContext;
    private ActivityManager mActivityManager;
    IProcessObserver.Stub mObserver = new IProcessObserver.Stub(){

        @Override
        public void onForegroundActivitiesChanged(int pid, int uid, boolean fg) {
            boolean isHomeActivityVisible = HomeVisibilityObserver.this.isHomeActivityVisible();
            if (HomeVisibilityObserver.this.mIsHomeActivityVisible != isHomeActivityVisible) {
                HomeVisibilityObserver.this.mIsHomeActivityVisible = isHomeActivityVisible;
                HomeVisibilityObserver.this.onHomeVisibilityChanged(HomeVisibilityObserver.this.mIsHomeActivityVisible);
            }
        }

        @Override
        public void onForegroundServicesChanged(int pid, int uid, int fgServiceTypes) {
        }

        @Override
        public void onProcessDied(int pid, int uid) {
        }
    };
    boolean mIsHomeActivityVisible;

    void init(Context context, ActivityManager activityManager) {
        this.mContext = context;
        this.mActivityManager = activityManager;
        this.mIsHomeActivityVisible = this.isHomeActivityVisible();
    }

    public abstract void onHomeVisibilityChanged(boolean var1);

    private boolean isHomeActivityVisible() {
        List<ActivityManager.RunningTaskInfo> tasks = this.mActivityManager.getRunningTasks(1);
        if (tasks == null || tasks.isEmpty()) {
            return false;
        }
        String top = tasks.get((int)0).topActivity.getPackageName();
        if (top == null) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo info = this.mContext.getPackageManager().resolveActivity(intent, 65536);
        return info != null && top.equals(info.activityInfo.packageName);
    }
}

