/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class VcsLogStructureFilterImpl
implements VcsLogDetailsFilter,
VcsLogStructureFilter {
    @NotNull
    private final Collection<FilePath> myFiles;

    protected VcsLogStructureFilterImpl(@NotNull Collection<FilePath> files) {
        this.myFiles = files;
    }

    @NotNull
    public Collection<FilePath> getFiles() {
        return this.myFiles;
    }

    public boolean matches(@NotNull VcsCommitMetadata details) {
        if (details instanceof VcsFullCommitDetails) {
            for (Change change : ((VcsFullCommitDetails)details).getChanges()) {
                ContentRevision before = change.getBeforeRevision();
                if (before != null && this.matches(before.getFile().getPath())) {
                    return true;
                }
                ContentRevision after = change.getAfterRevision();
                if (after == null || !this.matches(after.getFile().getPath())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(@NotNull String path2) {
        return ContainerUtil.find(this.myFiles, file -> FileUtil.isAncestor((String)file.getPath(), (String)path2, (boolean)false)) != null;
    }

    public String toString() {
        return "files:" + this.myFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsLogStructureFilterImpl filter = (VcsLogStructureFilterImpl)o;
        return Comparing.haveEqualElements(this.getFiles(), filter.getFiles());
    }

    public int hashCode() {
        return Comparing.unorderedHashcode(this.getFiles());
    }
}

