/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.changes.ui.browser.ChangesFilterer;
import com.intellij.openapi.vcs.changes.ui.browser.FilterableChangesBrowser;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.MergedChangeDiffRequestProvider;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogChangesBrowser
extends FilterableChangesBrowser {
    @NotNull
    public static final DataKey<Boolean> HAS_AFFECTED_FILES = DataKey.create((String)"VcsLogChangesBrowser.HasAffectedFiles");
    @NotNull
    private final Project myProject;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final Function<? super CommitId, ? extends VcsShortCommitDetails> myDataGetter;
    @NotNull
    private final VcsLogUiProperties.PropertiesChangeListener myListener;
    @NotNull
    private final Set<VirtualFile> myRoots = new HashSet<VirtualFile>();
    private boolean myHasMergeCommits = false;
    @NotNull
    private final List<Change> myChanges = new ArrayList<Change>();
    @NotNull
    private final Map<CommitId, Set<Change>> myChangesToParents = new LinkedHashMap<CommitId, Set<Change>>();
    @Nullable
    private Collection<FilePath> myAffectedPaths;
    @NotNull
    private Consumer<StatusText> myUpdateEmptyText = this::updateEmptyText;
    @NotNull
    private final Wrapper myToolbarWrapper;
    @NotNull
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);

    VcsLogChangesBrowser(@NotNull Project project, @NotNull MainVcsLogUiProperties uiProperties, @NotNull Function<? super CommitId, ? extends VcsShortCommitDetails> getter, @NotNull Disposable parent) {
        super(project, false, false);
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myDataGetter = getter;
        this.myListener = new VcsLogUiProperties.PropertiesChangeListener(){

            @Override
            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                if (MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS.equals(property) || MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES.equals(property)) {
                    VcsLogChangesBrowser.this.myViewer.rebuildTree();
                }
            }
        };
        this.myUiProperties.addChangeListener(this.myListener);
        Disposer.register((Disposable)parent, (Disposable)this);
        JComponent toolbarComponent = this.getToolbar().getComponent();
        this.myToolbarWrapper = new Wrapper(toolbarComponent);
        GuiUtils.installVisibilityReferent((JComponent)this.myToolbarWrapper, (JComponent)toolbarComponent);
        this.init();
        this.myViewer.setEmptyText(VcsLogBundle.message((String)"vcs.log.changes.select.commits.to.view.changes.status", (Object[])new Object[0]));
        this.myViewer.rebuildTree();
    }

    @Override
    @NotNull
    protected JComponent createToolbarComponent() {
        return this.myToolbarWrapper;
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createCenterPanel();
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)centerPanel, JScrollPane.class);
        if (scrollPane != null) {
            ComponentUtil.putClientProperty((JComponent)scrollPane, (Key)UIUtil.KEEP_BORDER_SIDES, (Object)2);
        }
        return centerPanel;
    }

    @Override
    @NotNull
    protected Border createViewerBorder() {
        return IdeBorderFactory.createBorder((int)2);
    }

    public void setToolbarHeightReferent(@NotNull JComponent referent) {
        this.myToolbarWrapper.setVerticalSizeReferent(referent);
    }

    public void addListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myUiProperties.removeChangeListener(this.myListener);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        return ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{CustomActionsSchema.getInstance().getCorrectedAction("Vcs.Log.ChangesBrowser.Toolbar")});
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        return ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.ChangesBrowser.Popup")});
    }

    private void updateModel(@NotNull Runnable update) {
        this.myChanges.clear();
        this.myChangesToParents.clear();
        this.myRoots.clear();
        this.myHasMergeCommits = false;
        this.myUpdateEmptyText = this::updateEmptyText;
        update.run();
        this.myUpdateEmptyText.accept(this.myViewer.getEmptyText());
        this.myViewer.rebuildTree();
        ((Listener)this.myDispatcher.getMulticaster()).onModelUpdated();
    }

    public void resetSelectedDetails() {
        this.updateModel(() -> {
            this.myUpdateEmptyText = text2 -> text2.setText("");
        });
    }

    public void showText(@NotNull Consumer<StatusText> statusTextConsumer) {
        this.updateModel(() -> {
            this.myUpdateEmptyText = statusTextConsumer;
        });
    }

    @Override
    protected void onActiveChangesFilterChanges() {
        super.onActiveChangesFilterChanges();
        this.myUpdateEmptyText.accept(this.myViewer.getEmptyText());
    }

    public void setAffectedPaths(@Nullable Collection<FilePath> paths) {
        this.myAffectedPaths = paths;
        this.myUpdateEmptyText.accept(this.myViewer.getEmptyText());
        this.myViewer.rebuildTree();
    }

    public void setSelectedDetails(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
        this.updateModel(() -> {
            if (!detailsList.isEmpty()) {
                this.myRoots.addAll(ContainerUtil.map((Collection)detailsList, detail -> detail.getRoot()));
                this.myHasMergeCommits = ContainerUtil.exists((Iterable)detailsList, detail -> detail.getParents().size() > 1);
                if (detailsList.size() == 1) {
                    VcsFullCommitDetails detail2 = (VcsFullCommitDetails)Objects.requireNonNull(ContainerUtil.getFirstItem((List)detailsList));
                    this.myChanges.addAll(detail2.getChanges());
                    if (detail2.getParents().size() > 1) {
                        for (int i = 0; i < detail2.getParents().size(); ++i) {
                            ReferenceOpenHashSet changesSet = new ReferenceOpenHashSet(detail2.getChanges(i));
                            this.myChangesToParents.put(new CommitId((Hash)detail2.getParents().get(i), detail2.getRoot()), (Set<Change>)changesSet);
                        }
                    }
                } else {
                    this.myChanges.addAll(VcsLogUtil.collectChanges(detailsList, (Function<? super VcsFullCommitDetails, ? extends Collection<Change>>)((Function)VcsFullCommitDetails::getChanges)));
                }
            }
        });
    }

    private void updateEmptyText(@NotNull StatusText emptyText) {
        if (this.myRoots.isEmpty()) {
            emptyText.setText(VcsLogBundle.message((String)"vcs.log.changes.select.commits.to.view.changes.status", (Object[])new Object[0]));
        } else if (!this.myChangesToParents.isEmpty()) {
            emptyText.setText(VcsLogBundle.message((String)"vcs.log.changes.no.merge.conflicts.status", (Object[])new Object[0])).appendSecondaryText(VcsLogBundle.message((String)"vcs.log.changes.show.changes.to.parents.status.action", (Object[])new Object[0]), VcsLogUiUtil.getLinkAttributes(), e -> this.myUiProperties.set(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS, true));
        } else if (this.isShowOnlyAffectedSelected() && this.myAffectedPaths != null) {
            emptyText.setText(VcsLogBundle.message((String)"vcs.log.changes.no.changes.that.affect.selected.paths.status", (Object[])new Object[0])).appendSecondaryText(VcsLogBundle.message((String)"vcs.log.changes.show.all.paths.status.action", (Object[])new Object[0]), VcsLogUiUtil.getLinkAttributes(), e -> this.myUiProperties.set(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, false));
        } else if (!this.myHasMergeCommits && this.hasActiveChangesFilter()) {
            emptyText.setText(VcsLogBundle.message((String)"vcs.log.changes.no.changes.that.affect.selected.filters.status", (Object[])new Object[0])).appendSecondaryText(VcsLogBundle.message((String)"vcs.log.changes.show.all.changes.status.action", (Object[])new Object[0]), VcsLogUiUtil.getLinkAttributes(), e -> this.clearActiveChangesFilter());
        } else {
            emptyText.setText("");
        }
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        List<Change> changes = this.collectAffectedChanges(this.myChanges);
        ChangesFilterer.FilteredState filteredState = this.filterChanges(changes, !this.myHasMergeCommits);
        LinkedHashMap<CommitId, List<Change>> changesToParents = new LinkedHashMap<CommitId, List<Change>>();
        for (Map.Entry<CommitId, Set<Change>> entry : this.myChangesToParents.entrySet()) {
            changesToParents.put(entry.getKey(), this.collectAffectedChanges((Collection<Change>)entry.getValue()));
        }
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, this.getGrouping());
        VcsLogChangesBrowser.setFilteredChanges(builder, filteredState, null);
        if (this.isShowChangesFromParents() && !changesToParents.isEmpty()) {
            if (changes.isEmpty()) {
                builder.createTagNode(VcsLogBundle.message((String)"vcs.log.changes.no.merge.conflicts.node", (Object[])new Object[0]));
            }
            for (CommitId commitId : changesToParents.keySet()) {
                Collection changesFromParent = (Collection)changesToParents.get(commitId);
                if (changesFromParent.isEmpty()) continue;
                ChangesBrowserParentNode parentNode = new ChangesBrowserParentNode(commitId);
                parentNode.markAsHelperNode();
                builder.insertSubtreeRoot((ChangesBrowserNode)parentNode);
                builder.insertChanges(changesFromParent, parentNode);
            }
        }
        return builder.build();
    }

    @NotNull
    private List<Change> collectAffectedChanges(@NotNull Collection<Change> changes) {
        if (!this.isShowOnlyAffectedSelected() || this.myAffectedPaths == null) {
            return new ArrayList<Change>(changes);
        }
        return ContainerUtil.filter(changes, change -> ContainerUtil.or(this.myAffectedPaths, filePath -> {
            if (filePath.isDirectory()) {
                return FileHistoryUtil.affectsDirectory(change, filePath);
            }
            return FileHistoryUtil.affectsFile(change, filePath, false) || FileHistoryUtil.affectsFile(change, filePath, true);
        }));
    }

    private boolean isShowChangesFromParents() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) != false;
    }

    private boolean isShowOnlyAffectedSelected() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) != false;
    }

    @NotNull
    public List<Change> getDirectChanges() {
        return this.myChanges;
    }

    @NotNull
    public List<Change> getSelectedChanges() {
        return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (VcsDataKeys.VCS.is(dataId)) {
            AbstractVcs vcs = this.getVcs();
            if (vcs == null) {
                return null;
            }
            return vcs.getKeyInstanceMethod();
        }
        if (HAS_AFFECTED_FILES.is(dataId)) {
            return this.myAffectedPaths != null;
        }
        return super.getData(dataId);
    }

    @Nullable
    private AbstractVcs getVcs() {
        List allVcs = ContainerUtil.mapNotNull(this.myRoots, root -> ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(root));
        if (allVcs.size() == 1) {
            return (AbstractVcs)Objects.requireNonNull(ContainerUtil.getFirstItem((List)allVcs));
        }
        Set selectedVcs = ChangesUtil.getAffectedVcses(this.getSelectedChanges(), (Project)this.myProject);
        if (selectedVcs.size() == 1) {
            return (AbstractVcs)Objects.requireNonNull(ContainerUtil.getFirstItem((Collection)selectedVcs));
        }
        return null;
    }

    @Override
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        return this.getDiffRequestProducer(userObject, false);
    }

    @Nullable
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject, boolean forDiffPreview) {
        if (!(userObject instanceof Change)) {
            return null;
        }
        Change change = (Change)userObject;
        HashMap context = new HashMap();
        if (!(change instanceof MergedChange)) {
            this.putRootTagIntoChangeContext(change, context);
        }
        return VcsLogChangesBrowser.createDiffRequestProducer(this.myProject, change, context, forDiffPreview);
    }

    @Nullable
    public static ChangeDiffRequestChain.Producer createDiffRequestProducer(@NotNull Project project, @NotNull Change change, @NotNull Map<Key<?>, Object> context, boolean forDiffPreview) {
        MergedChange mergedChange;
        if (change instanceof MergedChange && (mergedChange = (MergedChange)change).getSourceChanges().size() == 2) {
            if (forDiffPreview) {
                VcsLogChangesBrowser.putFilePathsIntoMergedChangeContext(mergedChange, context);
            }
            return new MergedChangeDiffRequestProvider.MyProducer(project, mergedChange, context);
        }
        if (forDiffPreview) {
            VcsDiffUtil.putFilePathsIntoChangeContext(change, context);
        }
        return ChangeDiffRequestProducer.create(project, change, context);
    }

    private void putRootTagIntoChangeContext(@NotNull Change change, @NotNull Map<Key<?>, Object> context) {
        CommitId parentId = null;
        for (CommitId commitId : this.myChangesToParents.keySet()) {
            if (!this.myChangesToParents.get(commitId).contains(change)) continue;
            parentId = commitId;
            break;
        }
        if (parentId != null) {
            RootTag tag = new RootTag(parentId.getHash(), this.getText(parentId));
            context.put(ChangeDiffRequestProducer.TAG_KEY, tag);
        }
    }

    private static void putFilePathsIntoMergedChangeContext(@NotNull MergedChange change, @NotNull Map<Key<?>, Object> context) {
        ContentRevision centerRevision = change.getAfterRevision();
        ContentRevision leftRevision = change.getSourceChanges().get(0).getBeforeRevision();
        ContentRevision rightRevision = change.getSourceChanges().get(1).getBeforeRevision();
        FilePath centerFile = centerRevision == null ? null : centerRevision.getFile();
        FilePath leftFile = leftRevision == null ? null : leftRevision.getFile();
        FilePath rightFile = rightRevision == null ? null : rightRevision.getFile();
        context.put(DiffUserDataKeysEx.VCS_DIFF_CENTER_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(centerRevision, centerFile, null));
        context.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(rightRevision, rightFile, centerFile));
        context.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(leftRevision, leftFile, centerFile == null ? rightFile : centerFile));
    }

    @NotNull
    @Nls
    private String getText(@NotNull CommitId commitId) {
        String text2 = VcsLogBundle.message((String)"vcs.log.changes.changes.to.parent.node", (Object[])new Object[]{commitId.getHash().toShortString()});
        VcsShortCommitDetails detail = (VcsShortCommitDetails)this.myDataGetter.fun((Object)commitId);
        if (!(detail instanceof LoadingDetails) || detail instanceof IndexedDetails) {
            text2 = text2 + " " + StringUtil.shortenTextWithEllipsis((String)detail.getSubject(), (int)50, (int)0);
        }
        return text2;
    }

    private static class RootTag {
        @NotNull
        private final Hash myCommit;
        @NotNull
        private final String myText;

        RootTag(@NotNull Hash commit, @NotNull String text2) {
            this.myCommit = commit;
            this.myText = text2;
        }

        public String toString() {
            return this.myText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RootTag tag = (RootTag)o;
            return Objects.equals(this.myCommit, tag.myCommit);
        }

        public int hashCode() {
            return Objects.hash(this.myCommit);
        }
    }

    public static interface Listener
    extends EventListener {
        public void onModelUpdated();
    }

    private class ChangesBrowserParentNode
    extends ChangesBrowserNode<String> {
        protected ChangesBrowserParentNode(CommitId commitId) {
            super(VcsLogChangesBrowser.this.getText(commitId));
        }

        @Override
        public boolean shouldExpandByDefault() {
            return false;
        }
    }
}

