/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.FilterPair;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.filter.VcsStructureChooser;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureFilterPopupComponent
extends FilterPopupComponent<FilterPair<VcsLogStructureFilter, VcsLogRootFilter>, VcsLogClassicFilterUi.FileFilterModel> {
    private static final String PATHS = "Paths";
    private static final int FILTER_LABEL_LENGTH = 30;
    private static final int CHECKBOX_ICON_SIZE = 15;
    private static final FileByNameComparator FILE_BY_NAME_COMPARATOR = new FileByNameComparator();
    private static final FilePathByPathComparator FILE_PATH_BY_PATH_COMPARATOR = new FilePathByPathComparator();
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;

    public StructureFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogClassicFilterUi.FileFilterModel filterModel, @NotNull VcsLogColorManager colorManager) {
        super(VcsLogBundle.messagePointer((String)"vcs.log.filter.popup.paths", (Object[])new Object[0]), filterModel);
        this.myUiProperties = uiProperties;
        this.myColorManager = colorManager;
    }

    private static VcsLogRootFilter getRootFilter(@Nullable FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            return null;
        }
        return filter.getFilter2();
    }

    private static VcsLogStructureFilter getStructureFilter(@Nullable FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            return null;
        }
        return filter.getFilter1();
    }

    @NotNull
    private Collection<VirtualFile> getFilterRoots(@Nullable VcsLogRootFilter filter) {
        return filter != null ? filter.getRoots() : this.getAllRoots();
    }

    @NotNull
    private static Collection<FilePath> getFilterFiles(@Nullable VcsLogStructureFilter filter) {
        return filter != null ? filter.getFiles() : Collections.emptySet();
    }

    @Override
    @NotNull
    @Nls
    protected String getText(@NotNull FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter(filter);
        VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter(filter);
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(this.getAllRoots(), rootFilter, structureFilter);
        Collection<VirtualFile> roots = this.getFilterRoots(rootFilter);
        Collection<FilePath> files = StructureFilterPopupComponent.getFilterFiles(structureFilter);
        if (files.isEmpty()) {
            return StructureFilterPopupComponent.getTextFromRoots(roots, visibleRoots.size() == this.getAllRoots().size());
        }
        return StructureFilterPopupComponent.getTextFromFilePaths(files, VcsLogBundle.message((String)"vcs.log.filter.popup.no.folders", (Object[])new Object[0]), false);
    }

    @NotNull
    @Nls
    private static String getTextFromRoots(@NotNull Collection<? extends VirtualFile> files, boolean full) {
        return StructureFilterPopupComponent.getText(files, VcsLogBundle.message((String)"vcs.log.filter.popup.no.roots", (Object[])new Object[0]), FILE_BY_NAME_COMPARATOR, VirtualFile::getName, full);
    }

    @NotNull
    @Nls
    private static String getTextFromFilePaths(@NotNull Collection<? extends FilePath> files, @Nls @NotNull String categoryText, boolean full) {
        return StructureFilterPopupComponent.getText(files, categoryText, FILE_PATH_BY_PATH_COMPARATOR, file -> StringUtil.shortenPathWithEllipsis((String)file.getPresentableUrl(), (int)30), full);
    }

    @NotNull
    @Nls
    private static <F> String getText(@NotNull Collection<? extends F> files, @Nls @NotNull String categoryText, @NotNull Comparator<? super F> comparator, @NotNull NotNullFunction<? super F, String> getText2, boolean full) {
        if (full) {
            return (String)ALL.get();
        }
        if (files.isEmpty()) {
            return categoryText;
        }
        F firstFile = Collections.min(files, comparator);
        String firstFileName = (String)getText2.fun(firstFile);
        if (files.size() == 1) {
            return firstFileName;
        }
        return firstFileName + " + " + (files.size() - 1);
    }

    @Override
    @Nls
    protected String getToolTip(@NotNull FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        return this.getToolTip(this.getFilterRoots(StructureFilterPopupComponent.getRootFilter(filter)), StructureFilterPopupComponent.getFilterFiles(StructureFilterPopupComponent.getStructureFilter(filter)));
    }

    @Nls
    @NotNull
    private String getToolTip(@NotNull Collection<? extends VirtualFile> roots, @NotNull Collection<? extends FilePath> files) {
        String tooltip = "";
        if (roots.isEmpty()) {
            tooltip = tooltip + VcsLogBundle.message((String)"vcs.log.filter.tooltip.no.roots.selected", (Object[])new Object[0]);
        } else if (roots.size() != this.getAllRoots().size()) {
            tooltip = tooltip + VcsLogBundle.message((String)"vcs.log.filter.tooltip.roots", (Object[])new Object[0]) + "\n" + StructureFilterPopupComponent.getTooltipTextForRoots(roots);
        }
        if (!files.isEmpty()) {
            if (!tooltip.isEmpty()) {
                tooltip = tooltip + "\n";
            }
            tooltip = tooltip + VcsLogBundle.message((String)"vcs.log.filter.tooltip.folders", (Object[])new Object[0]) + "\n" + StructureFilterPopupComponent.getTooltipTextForFilePaths(files);
        }
        return tooltip;
    }

    @NotNull
    private static String getTooltipTextForRoots(@NotNull Collection<? extends VirtualFile> files) {
        return StructureFilterPopupComponent.getTooltipTextForFiles(files, FILE_BY_NAME_COMPARATOR, VirtualFile::getName);
    }

    @NotNull
    private static String getTooltipTextForFilePaths(@NotNull Collection<? extends FilePath> files) {
        return StructureFilterPopupComponent.getTooltipTextForFiles(files, FILE_PATH_BY_PATH_COMPARATOR, FilePath::getPresentableUrl);
    }

    @NotNull
    private static <F> String getTooltipTextForFiles(@NotNull Collection<? extends F> files, @NotNull Comparator<? super F> comparator, @NotNull NotNullFunction<? super F, String> getText2) {
        List filesToDisplay = ContainerUtil.sorted(files, comparator);
        filesToDisplay = ContainerUtil.getFirstItems((List)filesToDisplay, (int)10);
        String tooltip = StringUtil.join((Collection)filesToDisplay, getText2, (String)"\n");
        if (files.size() > 10) {
            tooltip = tooltip + "\n...";
        }
        return tooltip;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Set<VirtualFile> roots = this.getAllRoots();
        ArrayList<SelectVisibleRootAction> rootActions = new ArrayList<SelectVisibleRootAction>();
        if (this.myColorManager.hasMultiplePaths()) {
            for (VirtualFile root : ContainerUtil.sorted(roots, (Comparator)FILE_BY_NAME_COMPARATOR)) {
                rootActions.add(new SelectVisibleRootAction(root));
            }
        }
        ArrayList<SelectFromHistoryAction> structureActions = new ArrayList<SelectFromHistoryAction>();
        for (VcsLogStructureFilter filter : this.getRecentFilters()) {
            structureActions.add(new SelectFromHistoryAction(filter));
        }
        if (roots.size() > 15) {
            return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator(VcsLogBundle.messagePointer((String)"vcs.log.filter.recent", (Object[])new Object[0])), new DefaultActionGroup(structureActions), new Separator(VcsLogBundle.messagePointer((String)"vcs.log.filter.roots", (Object[])new Object[0])), new DefaultActionGroup(rootActions)});
        }
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator(VcsLogBundle.messagePointer((String)"vcs.log.filter.roots", (Object[])new Object[0])), new DefaultActionGroup(rootActions), new Separator(VcsLogBundle.messagePointer((String)"vcs.log.filter.recent", (Object[])new Object[0])), new DefaultActionGroup(structureActions)});
    }

    @NotNull
    private List<VcsLogStructureFilter> getRecentFilters() {
        List<List<String>> filterValues = this.myUiProperties.getRecentlyFilteredGroups(PATHS);
        return ContainerUtil.map2List(filterValues, values -> VcsLogClassicFilterUi.FileFilterModel.createStructureFilter(values));
    }

    private Set<VirtualFile> getAllRoots() {
        return ((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).getRoots();
    }

    private boolean isVisible(@NotNull VirtualFile root) {
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).getFilter());
        if (rootFilter != null) {
            return rootFilter.getRoots().contains(root);
        }
        return true;
    }

    private void setVisible(@NotNull VirtualFile root, boolean visible) {
        Set<VirtualFile> roots = this.getAllRoots();
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).getFilter());
        Collection<Object> visibleRoots = rootFilter == null ? (visible ? roots : ContainerUtil.subtract(roots, Collections.singleton(root))) : (visible ? ContainerUtil.union(new HashSet(rootFilter.getRoots()), Collections.singleton(root)) : ContainerUtil.subtract((Collection)rootFilter.getRoots(), Collections.singleton(root)));
        ((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).setFilter(new FilterPair<Object, VcsLogRootFilter>(null, VcsLogFilterObject.fromRoots(visibleRoots)));
    }

    private void setVisibleOnly(@NotNull VirtualFile root) {
        ((VcsLogClassicFilterUi.FileFilterModel)this.myFilterModel).setFilter(new FilterPair<Object, VcsLogRootFilter>(null, VcsLogFilterObject.fromRoot(root)));
    }

    @NotNull
    private static String getStructureActionText(@NotNull VcsLogStructureFilter filter) {
        return StructureFilterPopupComponent.getTextFromFilePaths(filter.getFiles(), VcsLogBundle.message((String)"vcs.log.filter.popup.no.items", (Object[])new Object[0]), filter.getFiles().isEmpty());
    }

    private class SelectFromHistoryAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final VcsLogStructureFilter myFilter;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final Icon myEmptyIcon;

        private SelectFromHistoryAction(VcsLogStructureFilter filter) {
            super(StructureFilterPopupComponent.getStructureActionText(filter), StructureFilterPopupComponent.getTooltipTextForFilePaths(filter.getFiles()).replace("\n", " "), null);
            this.myFilter = filter;
            this.myIcon = JBUI.scale((JBUI.JBIcon)new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, 15, 15));
            this.myEmptyIcon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return StructureFilterPopupComponent.getStructureFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()) == this.myFilter;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            ((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).setFilter(new FilterPair<VcsLogStructureFilter, Object>(this.myFilter, null));
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (this.isSelected(e)) {
                presentation.setIcon(this.myIcon);
            } else {
                presentation.setIcon(this.myEmptyIcon);
            }
        }
    }

    private class SelectFoldersAction
    extends DumbAwareAction {
        SelectFoldersAction() {
            super(VcsLogBundle.messagePointer((String)"vcs.log.filter.select.folders", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            Set<VirtualFile> roots = ((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getRoots();
            VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter());
            Collection<Object> files = structureFilter == null ? Collections.emptySet() : ContainerUtil.mapNotNull((Collection)structureFilter.getFiles(), FilePath::getVirtualFile);
            VcsStructureChooser chooser = new VcsStructureChooser(project, VcsLogBundle.message((String)"vcs.log.select.folder.dialog.title", (Object[])new Object[0]), files, new ArrayList<VirtualFile>(roots));
            if (chooser.showAndGet()) {
                VcsLogStructureFilter newFilter = VcsLogFilterObject.fromVirtualFiles(chooser.getSelectedFiles());
                ((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).setFilter(new FilterPair<VcsLogStructureFilter, Object>(newFilter, null));
                StructureFilterPopupComponent.this.myUiProperties.addRecentlyFilteredGroup(StructureFilterPopupComponent.PATHS, VcsLogClassicFilterUi.FileFilterModel.getFilterValues(newFilter));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }
    }

    private static class CheckboxColorIcon
    extends ColorIcon {
        private boolean mySelected;
        private SizedIcon mySizedIcon;

        CheckboxColorIcon(int size, @NotNull Color color) {
            super(size, color);
            this.mySizedIcon = new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, size, size);
        }

        public void prepare(boolean selected) {
            this.mySelected = selected;
        }

        @NotNull
        public CheckboxColorIcon withIconPreScaled(boolean preScaled) {
            this.mySizedIcon = (SizedIcon)this.mySizedIcon.withIconPreScaled(preScaled);
            return (CheckboxColorIcon)super.withIconPreScaled(preScaled);
        }

        public void paintIcon(Component component, Graphics g, int i, int j) {
            super.paintIcon(component, g, i, j);
            if (this.mySelected) {
                this.mySizedIcon.paintIcon(component, g, i, j);
            }
        }
    }

    private class SelectVisibleRootAction
    extends ToggleAction
    implements DumbAware,
    KeepingPopupOpenAction {
        @NotNull
        private final CheckboxColorIcon myIcon;
        @NotNull
        private final VirtualFile myRoot;

        private SelectVisibleRootAction(VirtualFile root) {
            super(null, root.getPresentableUrl(), null);
            this.getTemplatePresentation().setText(root.getName(), false);
            this.myRoot = root;
            this.myIcon = (CheckboxColorIcon)JBUI.scale((JBUI.JBIcon)new CheckboxColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(this.myRoot, StructureFilterPopupComponent.this.myColorManager)));
            this.getTemplatePresentation().setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15)));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return StructureFilterPopupComponent.this.isVisible(this.myRoot);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (!this.isEnabled()) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else if ((e.getModifiers() & this.getMask()) != 0) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else {
                StructureFilterPopupComponent.this.setVisible(this.myRoot, state);
            }
        }

        @JdkConstants.InputEventMask
        private int getMask() {
            return SystemInfo.isMac ? 4 : 2;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            this.updateIcon();
            e.getPresentation().setIcon((Icon)((Object)this.myIcon));
            String tooltip = VcsLogBundle.message((String)"vcs.log.filter.tooltip.click.to.see.only", (Object[])new Object[]{KeyEvent.getKeyModifiersText(this.getMask()), e.getPresentation().getText()});
            e.getPresentation().putClientProperty("ToolTipText", (Object)tooltip);
        }

        private void updateIcon() {
            this.myIcon.prepare(StructureFilterPopupComponent.this.isVisible(this.myRoot) && this.isEnabled());
        }

        private boolean isEnabled() {
            return StructureFilterPopupComponent.getStructureFilter((FilterPair)((VcsLogClassicFilterUi.FileFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()) == null;
        }
    }

    private static class FilePathByPathComparator
    implements Comparator<FilePath> {
        private FilePathByPathComparator() {
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    }

    private static class FileByNameComparator
    implements Comparator<VirtualFile> {
        private FileByNameComparator() {
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

