/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.PopupListElementRendererWithIcon;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.BranchFilters;
import com.intellij.vcs.log.ui.filter.BranchLogSpeedSearchPopup;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchFilterPopupComponent
extends MultipleValueFilterPopupComponent<BranchFilters, VcsLogClassicFilterUi.BranchFilterModel> {
    private final VcsLogClassicFilterUi.BranchFilterModel myBranchFilterModel;

    public BranchFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogClassicFilterUi.BranchFilterModel filterModel) {
        super("Branch", VcsLogBundle.messagePointer((String)"vcs.log.branch.filter.label", (Object[])new Object[0]), uiProperties, filterModel);
        this.myBranchFilterModel = filterModel;
    }

    @Override
    @NotNull
    protected List<String> getFilterValues(@NotNull BranchFilters filters) {
        return VcsLogClassicFilterUi.BranchFilterModel.getFilterPresentation(filters);
    }

    @Override
    @Nullable
    protected BranchFilters createFilter(@NotNull List<String> values) {
        return ((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).createFilterFromPresentation(values);
    }

    @Override
    @NotNull
    protected MultilinePopupBuilder.CompletionPrefixProvider getCompletionPrefixProvider() {
        return (text2, offset) -> {
            int index = 0;
            for (String s : BranchFilterPopupComponent.getCompletionSeparators()) {
                int separatorIndex = text2.lastIndexOf(s, offset - s.length());
                if (separatorIndex <= index) continue;
                index = separatorIndex + s.length();
            }
            String prefix = text2.substring(index, offset);
            return StringUtil.trimLeading((String)prefix, (char)'-');
        };
    }

    @Override
    @NotNull
    protected List<String> parseLocalizedValues(@NotNull Collection<String> values) {
        return new ArrayList<String>(values);
    }

    @Override
    @NotNull
    protected List<String> getLocalizedValues(@NotNull Collection<String> values) {
        return new ArrayList<String>(values);
    }

    @NotNull
    private static List<String> getCompletionSeparators() {
        ArrayList<String> separators = new ArrayList<String>();
        for (char c : MultilinePopupBuilder.SEPARATORS) {
            separators.add(String.valueOf(c));
        }
        separators.add("..");
        return separators;
    }

    @Override
    @NotNull
    protected ListPopup createPopupMenu() {
        return new MyBranchLogSpeedSearchPopup();
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.createAllAction());
        actionGroup.add(this.createSelectMultipleValuesAction());
        VcsLogDataPack logData = ((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).getDataPack();
        List<List<String>> branchFilters = BranchFilterPopupComponent.processRecentBranchFilters(ContainerUtil.map2Set((Collection)logData.getRefs().getBranches(), VcsRef::getName), this.getRecentValuesFromSettings());
        actionGroup.add((AnAction)new MyBranchPopupBuilder(logData, this.myBranchFilterModel.getVisibleRoots(), branchFilters).build());
        return actionGroup;
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        Collection branches = ((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).getDataPack().getRefs().getBranches();
        if (this.myBranchFilterModel.getVisibleRoots() != null) {
            branches = ContainerUtil.filter((Collection)branches, branch -> this.myBranchFilterModel.getVisibleRoots().contains(branch.getRoot()));
        }
        return ContainerUtil.map((Collection)branches, VcsRef::getName);
    }

    @NotNull
    private static List<List<String>> processRecentBranchFilters(@NotNull Set<String> availableBranches, @NotNull List<List<String>> recentBranchFilters) {
        if (availableBranches.isEmpty()) {
            return recentBranchFilters;
        }
        return ContainerUtil.filter(recentBranchFilters, recentFilter -> !VcsLogFilterObject.fromBranchPatterns(recentFilter, availableBranches, true).isEmpty());
    }

    private class MyBranchLogSpeedSearchPopup
    extends BranchLogSpeedSearchPopup {
        private PopupListElementRendererWithIcon myListElementRenderer;

        MyBranchLogSpeedSearchPopup() {
            super(BranchFilterPopupComponent.this.createActionGroup(), DataManager.getInstance().getDataContext((Component)BranchFilterPopupComponent.this));
        }

        protected MyBranchLogSpeedSearchPopup(@NotNull WizardPopup parent, @Nullable ListPopupStep step2, Object value) {
            super(parent, step2, DataManager.getInstance().getDataContext((Component)BranchFilterPopupComponent.this), value);
        }

        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            MyBranchPopupBuilder.BranchFilterAction branchAction = MyBranchLogSpeedSearchPopup.getSpecificAction(this.getList().getSelectedValue(), MyBranchPopupBuilder.BranchFilterAction.class);
            if (branchAction != null && e instanceof MouseEvent && this.myListElementRenderer.isIconAt(((MouseEvent)e).getPoint())) {
                branchAction.toggle();
                this.getList().repaint();
            } else {
                super.handleSelect(handleFinalChoices, e);
            }
        }

        protected PopupListElementRendererWithIcon getListElementRenderer() {
            if (this.myListElementRenderer == null) {
                this.myListElementRenderer = new PopupListElementRendererWithIcon((ListPopupImpl)this);
            }
            return this.myListElementRenderer;
        }

        protected WizardPopup createPopup(WizardPopup parent, PopupStep step2, Object parentValue) {
            if (step2 instanceof ListPopupStep) {
                return new MyBranchLogSpeedSearchPopup(parent, (ListPopupStep)step2, parentValue);
            }
            return super.createPopup(parent, step2, parentValue);
        }
    }

    private class MyBranchPopupBuilder
    extends BranchPopupBuilder {
        protected MyBranchPopupBuilder(@Nullable VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, List<? extends List<String>> recentItems) {
            super(dataPack, visibleRoots, recentItems);
        }

        @Override
        @NotNull
        public AnAction createAction(@NotNull String name, @NotNull Collection<? extends VcsRef> refs) {
            return new BranchFilterAction(() -> name, refs);
        }

        @Override
        protected void createRecentAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> recentItems) {
            actionGroup.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction(BranchFilterPopupComponent.this, recentItems));
        }

        @Override
        @NotNull
        protected AnAction createCollapsedAction(@NotNull String actionName, @NotNull Collection<? extends VcsRef> refs) {
            return new BranchFilterAction(() -> actionName, refs);
        }

        @Override
        protected void createFavoritesAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> favorites) {
            actionGroup.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction(BranchFilterPopupComponent.this, favorites, VcsLogBundle.messagePointer((String)"vcs.log.branch.filter.favorites", (Object[])new Object[0]), false));
        }

        private class BranchFilterAction
        extends MultipleValueFilterPopupComponent.PredefinedValueAction {
            @NotNull
            private final LayeredIcon myIcon;
            @NotNull
            private final LayeredIcon myHoveredIcon;
            @NotNull
            private final Collection<? extends VcsRef> myReferences;
            private boolean myIsFavorite;

            BranchFilterAction(@NotNull Supplier<String> displayName, Collection<? extends VcsRef> references) {
                super(BranchFilterPopupComponent.this, new ArrayList<String>(ContainerUtil.map2LinkedSet(references, ref -> ref.getName())), displayName, true);
                this.myReferences = references;
                this.myIcon = new LayeredIcon(new Icon[]{AllIcons.Nodes.Favorite, EmptyIcon.ICON_16});
                this.myHoveredIcon = new LayeredIcon(new Icon[]{AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover});
                this.getTemplatePresentation().setIcon((Icon)this.myIcon);
                this.getTemplatePresentation().setSelectedIcon((Icon)this.myHoveredIcon);
                this.myIsFavorite = this.isFavorite();
                this.updateIcons();
            }

            private boolean isFavorite() {
                for (VcsRef vcsRef : this.myReferences) {
                    if (!((VcsLogProvider)MyBranchPopupBuilder.this.myDataPack.getLogProviders().get(vcsRef.getRoot())).getReferenceManager().isFavorite(vcsRef)) continue;
                    return true;
                }
                return false;
            }

            private void updateIcons() {
                this.myIcon.setLayerEnabled(0, this.myIsFavorite);
                this.myHoveredIcon.setLayerEnabled(0, this.myIsFavorite);
                this.myIcon.setLayerEnabled(1, !this.myIsFavorite);
                this.myHoveredIcon.setLayerEnabled(1, !this.myIsFavorite);
            }

            public void setFavorite(boolean favorite) {
                for (VcsRef vcsRef : this.myReferences) {
                    ((VcsLogProvider)MyBranchPopupBuilder.this.myDataPack.getLogProviders().get(vcsRef.getRoot())).getReferenceManager().setFavorite(vcsRef, favorite);
                }
                this.myIsFavorite = this.isFavorite();
                this.updateIcons();
            }

            public void toggle() {
                this.setFavorite(!this.myIsFavorite);
            }
        }
    }
}

