/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.ui.actions.history.FileHistorySingleCommitAction;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowAllAffectedFromHistoryAction
extends FileHistorySingleCommitAction<VcsFullCommitDetails> {
    @Override
    @NotNull
    protected List<VcsFullCommitDetails> getSelection(@NotNull FileHistoryUi ui2) {
        return ui2.getVcsLog().getSelectedDetails();
    }

    @Override
    @NotNull
    protected DataGetter<VcsFullCommitDetails> getDetailsGetter(@NotNull FileHistoryUi ui2) {
        return ui2.getLogData().getCommitDetailsGetter();
    }

    @Override
    protected void performAction(@NotNull Project project, @NotNull FileHistoryUi ui2, @NotNull VcsFullCommitDetails detail, @NotNull AnActionEvent e) {
        FilePath file = ui2.getPathInCommit((Hash)detail.getId());
        CommittedChangeListForRevision emptyChangeList = VcsLogUtil.createCommittedChangeList(detail, false);
        ChangeListViewerDialog dialog = new ChangeListViewerDialog(project, (CommittedChangeList)emptyChangeList, file != null ? file.getVirtualFile() : null);
        dialog.loadChangesInBackground((ThrowableComputable<? extends ChangeListViewerDialog.ChangelistData, ? extends VcsException>)((ThrowableComputable)() -> {
            CommittedChangeListForRevision committedChangeList = VcsLogUtil.createCommittedChangeList(detail);
            return new ChangeListViewerDialog.ChangelistData((CommittedChangeList)committedChangeList, file);
        }));
        dialog.setTitle(VcsLogBundle.message((String)"dialog.title.paths.affected.by.commit", (Object[])new Object[]{((Hash)detail.getId()).toShortString()}));
        dialog.show();
    }
}

