/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CustomVcsLogUiFactoryProvider;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsProjectLog
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsProjectLog.class);
    public static final Topic<ProjectLogListener> VCS_PROJECT_LOG_CHANGED = Topic.create((String)"Project Vcs Log Created or Disposed", ProjectLogListener.class);
    private static final int RECREATE_LOG_TRIES = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @NotNull
    private final VcsLogTabsManager myTabsManager;
    @NotNull
    private final LazyVcsLogManager myLogManager = new LazyVcsLogManager();
    @NotNull
    private final Disposable myListenersDisposable = Disposer.newDisposable();
    @NotNull
    private final ExecutorService myExecutor;
    private volatile boolean myDisposeStarted = false;
    private int myRecreatedLogCount = 0;

    public VcsProjectLog(@NotNull Project project) {
        this.myProject = project;
        this.myMessageBus = this.myProject.getMessageBus();
        VcsLogProjectTabsProperties uiProperties = (VcsLogProjectTabsProperties)ServiceManager.getService((Project)this.myProject, VcsLogProjectTabsProperties.class);
        this.myUiProperties = uiProperties;
        this.myTabsManager = new VcsLogTabsManager(project, this.myMessageBus, uiProperties, this);
        this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Vcs Log Initialization/Dispose", (int)1);
        this.myMessageBus.connect(this.myListenersDisposable).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (VcsProjectLog.this.myProject != project) {
                    return;
                }
                VcsProjectLog.this.myDisposeStarted = true;
                Disposer.dispose((Disposable)VcsProjectLog.this.myListenersDisposable);
                VcsProjectLog.this.disposeLog(false);
                VcsProjectLog.this.myExecutor.shutdown();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    try {
                        VcsProjectLog.this.myExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }, VcsLogBundle.message((String)"vcs.log.closing.process", (Object[])new Object[0]), false, project);
            }
        });
    }

    private void subscribeToMappingsAndPluginsChanges() {
        MessageBusConnection connection = this.myMessageBus.connect(this.myListenersDisposable);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> this.disposeLog(true));
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new MyDynamicPluginUnloader());
    }

    @Nullable
    public VcsLogData getDataManager() {
        VcsLogManager cached = this.myLogManager.getCached();
        if (cached == null) {
            return null;
        }
        return cached.getDataManager();
    }

    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        VcsLogContentProvider logContentProvider = VcsLogContentProvider.getInstance(this.myProject);
        if (logContentProvider == null) {
            return null;
        }
        return (VcsLogUiImpl)logContentProvider.getUi();
    }

    @Nullable
    public VcsLogManager getLogManager() {
        return this.myLogManager.getCached();
    }

    @NotNull
    public VcsLogTabsManager getTabsManager() {
        return this.myTabsManager;
    }

    @Nullable
    public MainVcsLogUi openLogTab(@Nullable VcsLogFilterCollection filters) {
        return this.openLogTab(filters, VcsLogManager.LogWindowKind.TOOL_WINDOW);
    }

    @Nullable
    public MainVcsLogUi openLogTab(@Nullable VcsLogFilterCollection filters, @NotNull VcsLogManager.LogWindowKind kind) {
        VcsLogManager logManager = this.getLogManager();
        if (logManager == null) {
            return null;
        }
        return this.myTabsManager.openAnotherLogTab(logManager, filters, kind);
    }

    private void disposeLog(boolean recreate) {
        this.myExecutor.execute(() -> {
            VcsLogManager logManager = (VcsLogManager)VcsProjectLog.invokeAndWait(() -> {
                VcsLogManager manager = this.myLogManager.dropValue();
                if (manager != null) {
                    manager.disposeUi();
                }
                return manager;
            });
            if (logManager != null) {
                Disposer.dispose((Disposable)logManager);
            }
            if (recreate) {
                this.createLog(false);
            }
        });
    }

    private void recreateOnError(@NotNull Throwable t) {
        ++this.myRecreatedLogCount;
        String logMessage = "Recreating Vcs Log after storage corruption. Recreated count " + this.myRecreatedLogCount;
        if (this.myRecreatedLogCount % 5 == 0) {
            LOG.error(logMessage, t);
            VcsLogManager manager = this.getLogManager();
            if (manager != null && manager.isLogVisible()) {
                String balloonMessage = VcsLogBundle.message((String)"vcs.log.recreated.due.to.corruption", (Object[])new Object[]{VcsLogUtil.getVcsDisplayName(this.myProject, manager), this.myRecreatedLogCount, PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName()});
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, balloonMessage, MessageType.ERROR, new NamedRunnable[0]);
            }
        } else {
            LOG.debug(logMessage, t);
        }
        this.disposeLog(true);
    }

    @NotNull
    Future<VcsLogManager> createLogInBackground(boolean forceInit) {
        return this.myExecutor.submit(() -> this.createLog(forceInit));
    }

    @Nullable
    private VcsLogManager createLog(boolean forceInit) {
        if (this.myDisposeStarted) {
            return null;
        }
        Map<VirtualFile, VcsLogProvider> logProviders = VcsProjectLog.getLogProviders(this.myProject);
        if (!logProviders.isEmpty()) {
            VcsLogManager logManager = this.myLogManager.getValue(logProviders);
            VcsProjectLog.initialize(logManager, forceInit);
            return logManager;
        }
        return null;
    }

    private static void initialize(@NotNull VcsLogManager logManager, boolean force) {
        VcsLogCachesInvalidator invalidator;
        if (force) {
            logManager.scheduleInitialization();
            return;
        }
        if (PostponableLogRefresher.keepUpToDate() && (invalidator = (VcsLogCachesInvalidator)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class))).isValid()) {
            HeavyAwareExecutor.executeOutOfHeavyProcessLater(logManager::scheduleInitialization, 5000);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (logManager.isLogVisible()) {
                logManager.scheduleInitialization();
            }
        }, VcsProjectLog.getModality());
    }

    @NotNull
    static Map<VirtualFile, VcsLogProvider> getLogProviders(@NotNull Project project) {
        return VcsLogManager.findLogProviders(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots()), project);
    }

    public static VcsProjectLog getInstance(@NotNull Project project) {
        return (VcsProjectLog)ServiceManager.getService((Project)project, VcsProjectLog.class);
    }

    public void dispose() {
    }

    private static <T> T invokeAndWait(@NotNull Computable<T> computable) {
        Ref result2 = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set(computable.compute()), VcsProjectLog.getModality());
        return (T)result2.get();
    }

    @NotNull
    private static ModalityState getModality() {
        return ModalityState.any();
    }

    public static void runWhenLogIsReady(@NotNull Project project, final @NotNull BiConsumer<? super VcsProjectLog, ? super VcsLogManager> action) {
        final VcsProjectLog log = VcsProjectLog.getInstance(project);
        VcsLogManager manager = log.getLogManager();
        if (manager != null) {
            action.accept(log, manager);
        } else {
            final Future<VcsLogManager> futureLogManager = log.createLogInBackground(true);
            new Task.Backgroundable(project, VcsLogBundle.message((String)"vcs.log.creating.process", (Object[])new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        futureLogManager.get(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (TimeoutException e) {
                        LOG.warn((Throwable)e);
                    }
                }

                public void onSuccess() {
                    VcsLogManager manager = log.getLogManager();
                    if (manager != null) {
                        action.accept(log, manager);
                    }
                }
            }.queue();
        }
    }

    @Nullable
    public static VcsLogManager getOrCreateLog(@NotNull Project project) {
        VcsProjectLog log = VcsProjectLog.getInstance(project);
        VcsLogManager manager = log.getLogManager();
        if (manager == null) {
            try {
                manager = log.createLogInBackground(true).get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        return manager;
    }

    public static interface ProjectLogListener {
        public void logCreated(@NotNull VcsLogManager var1);

        public void logDisposed(@NotNull VcsLogManager var1);
    }

    private class MyDynamicPluginUnloader
    implements DynamicPluginListener {
        private final Set<PluginId> affectedPlugins = new HashSet<PluginId>();

        private MyDynamicPluginUnloader() {
        }

        public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            if (this.hasLogExtensions(pluginDescriptor)) {
                VcsProjectLog.this.disposeLog(true);
            }
        }

        public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            if (this.hasLogExtensions(pluginDescriptor)) {
                this.affectedPlugins.add(pluginDescriptor.getPluginId());
                LOG.debug("Disposing Vcs Log before unloading " + pluginDescriptor.getPluginId());
                VcsProjectLog.this.disposeLog(false);
            }
        }

        public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            if (this.affectedPlugins.remove(pluginDescriptor.getPluginId())) {
                LOG.debug("Recreating Vcs Log after unloading " + pluginDescriptor.getPluginId());
                VcsProjectLog.this.disposeLog(true);
            }
        }

        private boolean hasLogExtensions(@NotNull IdeaPluginDescriptor descriptor) {
            for (VcsLogProvider logProvider : (VcsLogProvider[])VcsLogProvider.LOG_PROVIDER_EP.getExtensions((AreaInstance)VcsProjectLog.this.myProject)) {
                if (logProvider.getClass().getClassLoader() != descriptor.getPluginClassLoader()) continue;
                return true;
            }
            for (CustomVcsLogUiFactoryProvider factory : CustomVcsLogUiFactoryProvider.LOG_CUSTOM_UI_FACTORY_PROVIDER_EP.getExtensions((AreaInstance)VcsProjectLog.this.myProject)) {
                if (factory.getClass().getClassLoader() != descriptor.getPluginClassLoader()) continue;
                return true;
            }
            return false;
        }
    }

    static final class InitLogStartupActivity
    implements StartupActivity {
        public InitLogStartupActivity() {
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        public void runActivity(@NotNull Project project) {
            VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
            projectLog.subscribeToMappingsAndPluginsChanges();
            projectLog.createLogInBackground(false);
        }
    }

    private class LazyVcsLogManager {
        @Nullable
        private volatile VcsLogManager myValue;

        private LazyVcsLogManager() {
        }

        @NotNull
        public VcsLogManager getValue(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
            if (this.myValue == null) {
                VcsLogManager value;
                LOG.debug("Creating Vcs Log for " + VcsLogUtil.getProvidersMapText(logProviders));
                this.myValue = value = new VcsLogManager(VcsProjectLog.this.myProject, VcsProjectLog.this.myUiProperties, logProviders, false, (Consumer<? super Throwable>)((Consumer)x$0 -> VcsProjectLog.this.recreateOnError(x$0)));
                ApplicationManager.getApplication().invokeAndWait(() -> ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logCreated(value), VcsProjectLog.getModality());
            }
            return this.myValue;
        }

        @Nullable
        public VcsLogManager dropValue() {
            LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
            if (this.myValue != null) {
                VcsLogManager oldValue = this.myValue;
                LOG.debug("Disposing Vcs Log for " + VcsLogUtil.getProvidersMapText(oldValue.getDataManager().getLogProviders()));
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logDisposed(oldValue);
                this.myValue = null;
                return oldValue;
            }
            return null;
        }

        @Nullable
        public VcsLogManager getCached() {
            return this.myValue;
        }
    }
}

