/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStatusBarProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CustomVcsLogUiFactoryProvider;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsWatcher;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @Nullable
    private final Consumer<? super Throwable> myRecreateMainLogHandler;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManagerImpl myColorManager;
    @Nullable
    private VcsLogTabsWatcher myTabsLogRefresher;
    @NotNull
    private final PostponableLogRefresher myPostponableRefresher;
    @NotNull
    private final VcsLogStatusBarProgress myStatusBarProgress;
    private boolean myDisposed;

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<? extends VcsRoot> roots) {
        this(project, uiProperties, VcsLogManager.findLogProviders(roots, project), true, null);
    }

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, boolean scheduleRefreshImmediately, @Nullable Consumer<? super Throwable> recreateHandler) {
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myRecreateMainLogHandler = recreateHandler;
        MyFatalErrorsHandler fatalErrorsHandler = new MyFatalErrorsHandler();
        this.myLogData = new VcsLogData(this.myProject, logProviders, fatalErrorsHandler, this);
        this.myPostponableRefresher = new PostponableLogRefresher(this.myLogData);
        VcsLogManager.refreshLogOnVcsEvents(logProviders, this.myPostponableRefresher, this.myLogData);
        this.myColorManager = new VcsLogColorManagerImpl(logProviders.keySet());
        this.myStatusBarProgress = new VcsLogStatusBarProgress(this.myProject, logProviders, this.myLogData.getProgress());
        if (scheduleRefreshImmediately) {
            this.scheduleInitialization();
        }
    }

    public void scheduleInitialization() {
        this.myLogData.initialize();
    }

    public boolean isLogVisible() {
        return this.myPostponableRefresher.isLogVisible();
    }

    @NotNull
    public VcsLogData getDataManager() {
        return this.myLogData;
    }

    @NotNull
    public VcsLogColorManagerImpl getColorManager() {
        return this.myColorManager;
    }

    @NotNull
    public VcsLogTabsProperties getUiProperties() {
        return this.myUiProperties;
    }

    @NotNull
    public MainVcsLogUi createLogUi(@NotNull String logId, @NotNull LogWindowKind kind, boolean isClosedOnDispose) {
        return this.createLogUi(this.getMainLogUiFactory(logId, null), kind, isClosedOnDispose);
    }

    @NotNull
    public VcsLogUiFactory<? extends MainVcsLogUi> getMainLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters) {
        CustomVcsLogUiFactoryProvider factoryProvider = (CustomVcsLogUiFactoryProvider)CustomVcsLogUiFactoryProvider.LOG_CUSTOM_UI_FACTORY_PROVIDER_EP.findFirstSafe((AreaInstance)this.myProject, p -> p.isActive(this));
        if (factoryProvider == null) {
            return new MainVcsLogUiFactory(logId, filters);
        }
        return factoryProvider.createLogUiFactory(logId, this, filters);
    }

    @NotNull
    private VcsLogTabsWatcher getTabsWatcher() {
        LOG.assertTrue(!this.myDisposed);
        if (this.myTabsLogRefresher == null) {
            this.myTabsLogRefresher = new VcsLogTabsWatcher(this.myProject, this.myPostponableRefresher);
        }
        return this.myTabsLogRefresher;
    }

    @NotNull
    public <U extends VcsLogUiEx> U createLogUi(@NotNull VcsLogUiFactory<U> factory, @NotNull LogWindowKind kind) {
        return this.createLogUi(factory, kind, true);
    }

    @NotNull
    public <U extends VcsLogUiEx> U createLogUi(@NotNull VcsLogUiFactory<U> factory, @NotNull LogWindowKind kind, boolean isClosedOnDispose) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            LOG.error("Trying to create new VcsLogUi on a disposed VcsLogManager instance");
            throw new ProcessCanceledException();
        }
        U ui2 = factory.createLogUi(this.myProject, this.myLogData);
        Disposer.register(ui2, (Disposable)this.getTabsWatcher().addTabToWatch(ui2.getId(), ui2.getRefresher(), kind, isClosedOnDispose));
        return ui2;
    }

    @ApiStatus.Internal
    @NonNls
    public String getLogWindowsInformation() {
        return StringUtil.join(this.myPostponableRefresher.getLogWindows(), window -> window.toString() + (window.isVisible() ? " (visible)" : ""), (String)"\n");
    }

    private static void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogRefresher refresher, @NotNull Disposable disposableParent) {
        MultiMap providers2roots = MultiMap.create();
        logProviders.forEach((key, value) -> providers2roots.putValue(value, key));
        for (Map.Entry entry : providers2roots.entrySet()) {
            Disposable disposable = ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), refresher);
            Disposer.register((Disposable)disposableParent, (Disposable)disposable);
        }
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<? extends VcsRoot> roots, @NotNull Project project) {
        if (roots.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<VirtualFile, VcsLogProvider> logProviders = new HashMap<VirtualFile, VcsLogProvider>();
        VcsLogProvider[] allLogProviders = (VcsLogProvider[])VcsLogProvider.LOG_PROVIDER_EP.getExtensions((AreaInstance)project);
        block0: for (VcsRoot vcsRoot : roots) {
            AbstractVcs vcs = vcsRoot.getVcs();
            VirtualFile path2 = vcsRoot.getPath();
            if (vcs == null) {
                LOG.debug("Skipping invalid VCS root: " + vcsRoot);
                continue;
            }
            for (VcsLogProvider provider : allLogProviders) {
                if (!provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                logProviders.put(path2, provider);
                continue block0;
            }
        }
        return logProviders;
    }

    void disposeUi() {
        this.myDisposed = true;
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myTabsLogRefresher != null) {
            Disposer.dispose((Disposable)this.myTabsLogRefresher);
        }
        Disposer.dispose((Disposable)this.myStatusBarProgress);
    }

    public void dispose(@Nullable Runnable callback2) {
        this.disposeUi();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Disposer.dispose((Disposable)this);
            if (callback2 != null) {
                callback2.run();
            }
        });
    }

    public void dispose() {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        LOG.debug("Disposed Vcs Log for " + VcsLogUtil.getProvidersMapText(this.myLogData.getLogProviders()));
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public static enum LogWindowKind {
        TOOL_WINDOW,
        EDITOR,
        STANDALONE;

    }

    private class MainVcsLogUiFactory
    extends BaseVcsLogUiFactory<VcsLogUiImpl> {
        MainVcsLogUiFactory(@Nullable String logId, VcsLogFilterCollection filters) {
            super(logId, filters, VcsLogManager.this.myUiProperties, VcsLogManager.this.myColorManager);
        }

        @Override
        @NotNull
        protected VcsLogUiImpl createVcsLogUiImpl(@NotNull String logId, @NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties properties, @NotNull VcsLogColorManagerImpl colorManager, @NotNull VisiblePackRefresherImpl refresher, @Nullable VcsLogFilterCollection filters) {
            return new VcsLogUiImpl(logId, logData, colorManager, properties, refresher, filters);
        }
    }

    public static abstract class BaseVcsLogUiFactory<T extends VcsLogUiImpl>
    implements VcsLogUiFactory<T> {
        @NotNull
        private final String myLogId;
        @Nullable
        private final VcsLogFilterCollection myFilters;
        @NotNull
        private final VcsLogTabsProperties myUiProperties;
        @NotNull
        private final VcsLogColorManagerImpl myColorManager;

        public BaseVcsLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters, @NotNull VcsLogTabsProperties uiProperties, @NotNull VcsLogColorManagerImpl colorManager) {
            this.myLogId = logId;
            this.myFilters = filters;
            this.myUiProperties = uiProperties;
            this.myColorManager = colorManager;
        }

        @Override
        public T createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            MainVcsLogUiProperties properties = this.myUiProperties.createProperties(this.myLogId);
            VcsLogFiltererImpl vcsLogFilterer = new VcsLogFiltererImpl(logData.getLogProviders(), logData.getStorage(), logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), logData.getIndex());
            PermanentGraph.SortType initialSortType = properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE);
            VcsLogFilterCollection initialFilters = this.myFilters == null ? VcsLogFilterObject.collection(new VcsLogFilter[0]) : this.myFilters;
            VisiblePackRefresherImpl refresher = new VisiblePackRefresherImpl(project, logData, initialFilters, initialSortType, vcsLogFilterer, this.myLogId);
            return this.createVcsLogUiImpl(this.myLogId, logData, properties, this.myColorManager, refresher, this.myFilters);
        }

        @NotNull
        protected abstract T createVcsLogUiImpl(@NotNull String var1, @NotNull VcsLogData var2, @NotNull MainVcsLogUiProperties var3, @NotNull VcsLogColorManagerImpl var4, @NotNull VisiblePackRefresherImpl var5, @Nullable VcsLogFilterCollection var6);
    }

    @FunctionalInterface
    public static interface VcsLogUiFactory<T extends VcsLogUiEx> {
        public T createLogUi(@NotNull Project var1, @NotNull VcsLogData var2);
    }

    private class MyFatalErrorsHandler
    implements FatalErrorHandler {
        private final AtomicBoolean myIsBroken = new AtomicBoolean(false);

        private MyFatalErrorsHandler() {
        }

        @Override
        public void consume(@Nullable Object source, @NotNull Throwable e) {
            if (this.myIsBroken.compareAndSet(false, true)) {
                this.processError(source, e);
            } else {
                LOG.debug("Vcs Log storage is broken and is being recreated", e);
            }
        }

        protected void processError(@Nullable Object source, @NotNull Throwable e) {
            if (VcsLogManager.this.myRecreateMainLogHandler != null) {
                ApplicationManager.getApplication().invokeLater(() -> VcsLogManager.this.myRecreateMainLogHandler.consume((Object)e));
            } else {
                LOG.error(e);
            }
            if (source instanceof VcsLogStorage) {
                ((VcsLogModifiableIndex)VcsLogManager.this.myLogData.getIndex()).markCorrupted();
            }
        }

        @Override
        public void displayFatalErrorMessage(@Nls @NotNull String message) {
            VcsBalloonProblemNotifier.showOverChangesView(VcsLogManager.this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
        }
    }
}

