/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PostponableLogRefresher
implements VcsLogRefresher {
    private static final Logger LOG = Logger.getInstance(PostponableLogRefresher.class);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final Set<VirtualFile> myRootsToRefresh = new HashSet<VirtualFile>();
    @NotNull
    private final Set<VcsLogWindow> myLogWindows = new HashSet<VcsLogWindow>();

    public PostponableLogRefresher(@NotNull VcsLogData logData) {
        this.myLogData = logData;
        this.myLogData.addDataPackChangeListener(dataPack -> {
            LOG.debug("Refreshing log windows " + this.myLogWindows);
            for (VcsLogWindow window : this.myLogWindows) {
                PostponableLogRefresher.dataPackArrived(window.getRefresher(), window.isVisible());
            }
        });
    }

    @NotNull
    public Disposable addLogWindow(@NotNull VcsLogWindow window) {
        LOG.assertTrue(!ContainerUtil.exists(this.myLogWindows, w -> w.getId().equals(window.getId())), (Object)("Log window with id '" + window.getId() + "' was already added."));
        this.myLogWindows.add(window);
        this.refresherActivated(window.getRefresher(), true);
        return () -> {
            LOG.debug("Removing disposed log window " + window.toString());
            this.myLogWindows.remove(window);
        };
    }

    public static boolean keepUpToDate() {
        return Registry.is((String)"vcs.log.keep.up.to.date") && !PowerSaveMode.isEnabled();
    }

    private boolean canRefreshNow() {
        if (PostponableLogRefresher.keepUpToDate()) {
            return true;
        }
        return this.isLogVisible();
    }

    public boolean isLogVisible() {
        for (VcsLogWindow window : this.myLogWindows) {
            if (!window.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void refresherActivated(@NotNull VisiblePackRefresher refresher, boolean firstTime) {
        this.myLogData.initialize();
        if (!this.myRootsToRefresh.isEmpty()) {
            this.refreshPostponedRoots();
        } else {
            refresher.setValid(true, firstTime);
        }
    }

    private static void dataPackArrived(@NotNull VisiblePackRefresher refresher, boolean visible) {
        refresher.setValid(visible, true);
    }

    public void refresh(@NotNull VirtualFile root) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.canRefreshNow()) {
                this.myLogData.refresh(Collections.singleton(root));
            } else {
                LOG.debug("Postponed refresh for " + root);
                this.myRootsToRefresh.add(root);
            }
        }, ModalityState.any());
    }

    private void refreshPostponedRoots() {
        HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>(this.myRootsToRefresh);
        this.myRootsToRefresh.removeAll(toRefresh);
        this.myLogData.refresh(toRefresh);
    }

    @NotNull
    public Set<VcsLogWindow> getLogWindows() {
        return this.myLogWindows;
    }

    public static class VcsLogWindow {
        @NotNull
        private final String myId;
        @NotNull
        private final VisiblePackRefresher myRefresher;

        public VcsLogWindow(@NotNull String id, @NotNull VisiblePackRefresher refresher) {
            this.myId = id;
            this.myRefresher = refresher;
        }

        @NotNull
        public VisiblePackRefresher getRefresher() {
            return this.myRefresher;
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public String getId() {
            return this.myId;
        }

        public String toString() {
            return "VcsLogWindow '" + this.myId + "'";
        }
    }
}

