/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraph;
import com.intellij.vcs.log.graph.utils.IntIntMultiMap;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LinearBekGraphBuilder {
    private static final int MAX_BLOCK_SIZE = 200;
    private static final int MAGIC_SET_SIZE = 30;
    private static final GraphEdgeToDownNode GRAPH_EDGE_TO_DOWN_NODE = new GraphEdgeToDownNode();
    @NotNull
    private final GraphLayout myGraphLayout;
    private final LinearBekGraph myLinearBekGraph;

    LinearBekGraphBuilder(@NotNull LinearBekGraph bekGraph, @NotNull GraphLayout graphLayout) {
        this.myLinearBekGraph = bekGraph;
        this.myGraphLayout = graphLayout;
    }

    public void collapseAll() {
        for (int i = this.myLinearBekGraph.myGraph.nodesCount() - 1; i >= 0; --i) {
            MergeFragment fragment = this.getFragment(i);
            if (fragment == null) continue;
            fragment.collapse(this.myLinearBekGraph);
        }
    }

    @Nullable
    public MergeFragment collapseFragment(int mergeCommit) {
        MergeFragment fragment = this.getFragment(mergeCommit);
        if (fragment != null) {
            fragment.collapse(this.myLinearBekGraph);
            return fragment;
        }
        return null;
    }

    @Nullable
    public MergeFragment getFragment(int mergeCommit) {
        List downNodes = ContainerUtil.sorted(LinearGraphUtils.getDownNodes(this.myLinearBekGraph, mergeCommit));
        if (downNodes.size() != 2) {
            return null;
        }
        return this.getFragment((Integer)downNodes.get(1), (Integer)downNodes.get(0), mergeCommit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private MergeFragment getFragment(int leftChild, int rightChild, int parent) {
        MergeFragment fragment = new MergeFragment(parent, leftChild, rightChild);
        int leftLi = this.myGraphLayout.getLayoutIndex(leftChild);
        int rightLi = this.myGraphLayout.getLayoutIndex(rightChild);
        int rowsCount = 1;
        int blockSize = 1;
        PriorityQueue<GraphEdge> queue2 = new PriorityQueue<GraphEdge>(200, new GraphEdgeComparator());
        queue2.addAll(this.myLinearBekGraph.getAdjacentEdges(rightChild, EdgeFilter.NORMAL_DOWN));
        Set<Integer> magicSet = null;
        while (!queue2.isEmpty()) {
            GraphEdge nextEdge = queue2.poll();
            Integer next = nextEdge.getDownNodeIndex();
            Integer upNodeIndex = nextEdge.getUpNodeIndex();
            assert (upNodeIndex != null);
            if (next == null) {
                fragment.addTail(upNodeIndex);
                continue;
            }
            if (next == leftChild) {
                fragment.addTail(upNodeIndex);
                fragment.setMergeWithOldCommit(true);
            } else if (next == rightChild + rowsCount) {
                ++rowsCount;
                ++blockSize;
                queue2.addAll(this.myLinearBekGraph.getAdjacentEdges(next, EdgeFilter.NORMAL_DOWN));
                fragment.addBody(upNodeIndex);
            } else if (next > rightChild + rowsCount && next < leftChild) {
                rowsCount = next - rightChild + 1;
                ++blockSize;
                queue2.addAll(this.myLinearBekGraph.getAdjacentEdges(next, EdgeFilter.NORMAL_DOWN));
                fragment.addBody(upNodeIndex);
            } else if (next > leftChild) {
                int li = this.myGraphLayout.getLayoutIndex(next);
                if (leftLi > rightLi && !fragment.isMergeWithOldCommit()) {
                    if (next > leftChild + 30) {
                        return null;
                    }
                    if (magicSet == null) {
                        magicSet = this.calculateMagicSet(leftChild);
                    }
                    if (!magicSet.contains(next)) return null;
                    fragment.addTailEdge(upNodeIndex, next);
                } else if (li > leftLi && li < rightLi || li == leftLi) {
                    fragment.addTailEdge(upNodeIndex, next);
                } else {
                    if (li >= rightLi) {
                        return null;
                    }
                    if (next > leftChild + 30) {
                        if (!fragment.hasTailEdge(upNodeIndex) && !fragment.isBody(upNodeIndex)) {
                            return null;
                        }
                    } else {
                        if (magicSet == null) {
                            magicSet = this.calculateMagicSet(leftChild);
                        }
                        if (!magicSet.contains(next)) return null;
                        fragment.addTailEdge(upNodeIndex, next);
                    }
                }
            }
            if (blockSize < 200) continue;
            return null;
        }
        if (!fragment.getTails().isEmpty()) return fragment;
        return null;
    }

    @NotNull
    private Set<Integer> calculateMagicSet(int node) {
        Integer i;
        HashSet<Integer> magicSet = new HashSet<Integer>(30);
        PriorityQueue magicQueue = new PriorityQueue(30);
        magicQueue.addAll(ContainerUtil.map(this.myLinearBekGraph.getAdjacentEdges(node, EdgeFilter.NORMAL_DOWN), (Function)GRAPH_EDGE_TO_DOWN_NODE));
        while (!magicQueue.isEmpty() && (i = (Integer)magicQueue.poll()) <= node + 30) {
            magicSet.add(i);
            magicQueue.addAll(ContainerUtil.map(this.myLinearBekGraph.getAdjacentEdges(i, EdgeFilter.NORMAL_DOWN), (Function)GRAPH_EDGE_TO_DOWN_NODE));
        }
        return magicSet;
    }

    private static class GraphEdgeToDownNode
    implements Function<GraphEdge, Integer> {
        private GraphEdgeToDownNode() {
        }

        public Integer fun(GraphEdge graphEdge) {
            return graphEdge.getDownNodeIndex();
        }
    }

    private static class GraphEdgeComparator
    implements Comparator<GraphEdge> {
        private GraphEdgeComparator() {
        }

        @Override
        public int compare(@NotNull GraphEdge e1, @NotNull GraphEdge e2) {
            Integer d1 = e1.getDownNodeIndex();
            Integer d2 = e2.getDownNodeIndex();
            if (d1 == null) {
                if (d2 == null) {
                    return e1.hashCode() - e2.hashCode();
                }
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            return d1.compareTo(d2);
        }
    }

    public static final class MergeFragment {
        private final int myParent;
        private final int myLeftChild;
        private final int myRightChild;
        private boolean myMergeWithOldCommit = false;
        @NotNull
        private final IntIntMultiMap myTailEdges = new IntIntMultiMap();
        @NotNull
        private final IntOpenHashSet myBlockBody = new IntOpenHashSet();
        @NotNull
        private final IntOpenHashSet myTails = new IntOpenHashSet();

        private MergeFragment(int parent, int leftChild, int rightChild) {
            this.myParent = parent;
            this.myLeftChild = leftChild;
            this.myRightChild = rightChild;
        }

        public boolean isMergeWithOldCommit() {
            return this.myMergeWithOldCommit;
        }

        public void setMergeWithOldCommit(boolean mergeWithOldCommit) {
            this.myMergeWithOldCommit = mergeWithOldCommit;
        }

        public void addTail(int tail) {
            if (!this.myBlockBody.contains(tail)) {
                this.myTails.add(tail);
            }
        }

        public void addTailEdge(int upNodeIndex, int downNodeIndex) {
            if (!this.myBlockBody.contains(upNodeIndex)) {
                this.myTails.add(upNodeIndex);
                this.myTailEdges.putValue(upNodeIndex, downNodeIndex);
            }
        }

        public void addBody(int body) {
            this.myBlockBody.add(body);
        }

        @NotNull
        public IntOpenHashSet getTails() {
            return this.myTails;
        }

        public Set<Integer> getTailsAndBody() {
            HashSet<Integer> nodes = new HashSet<Integer>();
            IntIterator it = this.myBlockBody.iterator();
            while (it.hasNext()) {
                nodes.add(it.nextInt());
            }
            it = this.myTails.iterator();
            while (it.hasNext()) {
                nodes.add(it.nextInt());
            }
            return nodes;
        }

        public Set<Integer> getAllNodes() {
            HashSet<Integer> nodes = new HashSet<Integer>();
            nodes.add(this.myParent);
            nodes.add(this.myLeftChild);
            nodes.add(this.myRightChild);
            nodes.addAll(this.getTailsAndBody());
            return nodes;
        }

        public void collapse(LinearBekGraph graph) {
            for (int upNodeIndex : this.myTailEdges.keys()) {
                for (int downNodeIndex : this.myTailEdges.get(upNodeIndex)) {
                    MergeFragment.removeEdge(graph, upNodeIndex, downNodeIndex);
                }
            }
            IntIterator it = this.myTails.iterator();
            while (it.hasNext()) {
                int tail = it.nextInt();
                if (!LinearGraphUtils.getDownNodes(graph, tail).contains(this.myLeftChild)) {
                    MergeFragment.addEdge(graph, tail, this.myLeftChild);
                    continue;
                }
                MergeFragment.replaceEdge(graph, tail, this.myLeftChild);
            }
            MergeFragment.removeEdge(graph, this.myParent, this.myLeftChild);
        }

        private static void addEdge(LinearBekGraph graph, int up, int down) {
            graph.myDottedEdges.createEdge(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
        }

        private static void removeEdge(LinearBekGraph graph, int up, int down) {
            if (graph.myDottedEdges.hasEdge(up, down)) {
                graph.myDottedEdges.removeEdge(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
                graph.myHiddenEdges.createEdge(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
            } else {
                GraphEdge edge = LinearGraphUtils.getEdge(graph.myGraph, up, down);
                assert (edge != null) : "No edge between " + up + " and " + down;
                graph.myHiddenEdges.createEdge(edge);
            }
        }

        private static void replaceEdge(LinearBekGraph graph, int up, int down) {
            if (!graph.myDottedEdges.hasEdge(up, down)) {
                GraphEdge edge = LinearGraphUtils.getEdge(graph.myGraph, up, down);
                assert (edge != null) : "No edge between " + up + " and " + down;
                graph.myHiddenEdges.createEdge(edge);
                graph.myDottedEdges.createEdge(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
            }
        }

        public int getParent() {
            return this.myParent;
        }

        public boolean hasTailEdge(Integer index) {
            return !this.myTailEdges.get(index).isEmpty();
        }

        public boolean isBody(int index) {
            return this.myBlockBody.contains(index);
        }
    }
}

