/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EdgesInRowGenerator {
    private static final int CACHE_SIZE = 10;
    private static final int BLOCK_SIZE = 40;
    private final int WALK_SIZE;
    @NotNull
    private final LinearGraph myGraph;
    @NotNull
    private final SLRUMap<Integer, GraphEdges> cacheNU = new SLRUMap(10, 20);
    @NotNull
    private final SLRUMap<Integer, GraphEdges> cacheND = new SLRUMap(10, 20);

    public EdgesInRowGenerator(@NotNull LinearGraph graph) {
        this(graph, 1000);
    }

    public EdgesInRowGenerator(@NotNull LinearGraph graph, int walk_size) {
        this.myGraph = graph;
        this.WALK_SIZE = walk_size;
    }

    @NotNull
    public Set<GraphEdge> getEdgesInRow(int rowIndex) {
        GraphEdges neighborU = this.getNeighborU(rowIndex);
        while (neighborU.myRow < rowIndex) {
            neighborU = this.oneDownStep(neighborU);
        }
        GraphEdges neighborD = this.getNeighborD(rowIndex);
        while (neighborD.myRow > rowIndex) {
            neighborD = this.oneUpStep(neighborD);
        }
        Set result2 = neighborU.myEdges;
        result2.addAll(neighborD.myEdges);
        return result2;
    }

    public void invalidate() {
        this.cacheNU.clear();
        this.cacheND.clear();
    }

    @NotNull
    private GraphEdges getNeighborU(int rowIndex) {
        int upNeighborIndex = EdgesInRowGenerator.getUpNeighborIndex(rowIndex);
        GraphEdges graphEdges = (GraphEdges)this.cacheNU.get((Object)upNeighborIndex);
        if (graphEdges == null) {
            graphEdges = this.getUCorrectEdges(upNeighborIndex);
            this.cacheNU.put((Object)upNeighborIndex, (Object)graphEdges);
        }
        return graphEdges.copyInstance();
    }

    @NotNull
    private GraphEdges getNeighborD(int rowIndex) {
        int downNeighborIndex = EdgesInRowGenerator.getUpNeighborIndex(rowIndex) + 40;
        if (downNeighborIndex >= this.myGraph.nodesCount()) {
            return new GraphEdges(this.myGraph.nodesCount() - 1);
        }
        GraphEdges graphEdges = (GraphEdges)this.cacheND.get((Object)downNeighborIndex);
        if (graphEdges == null) {
            graphEdges = this.getDCorrectEdges(downNeighborIndex);
            this.cacheND.put((Object)downNeighborIndex, (Object)graphEdges);
        }
        return graphEdges.copyInstance();
    }

    private static int getUpNeighborIndex(int rowIndex) {
        return rowIndex / 40 * 40;
    }

    @NotNull
    private GraphEdges getUCorrectEdges(int rowIndex) {
        int startCalculateIndex = Math.max(rowIndex - this.WALK_SIZE, 0);
        GraphEdges graphEdges = new GraphEdges(startCalculateIndex);
        for (int i = startCalculateIndex; i < rowIndex; ++i) {
            graphEdges = this.oneDownStep(graphEdges);
        }
        return graphEdges;
    }

    @NotNull
    private GraphEdges getDCorrectEdges(int rowIndex) {
        int endCalculateIndex = Math.min(rowIndex + this.WALK_SIZE, this.myGraph.nodesCount() - 1);
        GraphEdges graphEdges = new GraphEdges(endCalculateIndex);
        for (int i = endCalculateIndex; i > rowIndex; --i) {
            graphEdges = this.oneUpStep(graphEdges);
        }
        return graphEdges;
    }

    @NotNull
    private GraphEdges oneDownStep(@NotNull GraphEdges graphEdges) {
        Set edgesInCurrentRow = graphEdges.myEdges;
        int currentRow = graphEdges.myRow;
        edgesInCurrentRow.addAll(this.createDownEdges(currentRow));
        edgesInCurrentRow.removeAll(this.createUpEdges(currentRow + 1));
        return new GraphEdges(edgesInCurrentRow, currentRow + 1);
    }

    @NotNull
    private GraphEdges oneUpStep(@NotNull GraphEdges graphEdges) {
        Set edgesInCurrentRow = graphEdges.myEdges;
        int currentRow = graphEdges.myRow;
        edgesInCurrentRow.addAll(this.createUpEdges(currentRow));
        edgesInCurrentRow.removeAll(this.createDownEdges(currentRow - 1));
        return new GraphEdges(edgesInCurrentRow, currentRow - 1);
    }

    public List<GraphEdge> createUpEdges(int nodeIndex) {
        return this.myGraph.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_UP);
    }

    public List<GraphEdge> createDownEdges(int nodeIndex) {
        return this.myGraph.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_DOWN);
    }

    private static class GraphEdges {
        @NotNull
        private final Set<GraphEdge> myEdges;
        private final int myRow;

        private GraphEdges(int row2) {
            this(new HashSet<GraphEdge>(), row2);
        }

        private GraphEdges(@NotNull Set<GraphEdge> edges, int row2) {
            this.myEdges = edges;
            this.myRow = row2;
        }

        @NotNull
        GraphEdges copyInstance() {
            return new GraphEdges(new HashSet<GraphEdge>(this.myEdges), this.myRow);
        }
    }
}

