/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtilKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class GraphLayoutBuilder {
    private static final Logger LOG = Logger.getInstance(GraphLayoutBuilder.class);
    @NotNull
    private final LinearGraph myGraph;
    private final int @NotNull [] myLayoutIndex;
    @NotNull
    private final List<Integer> myHeadNodeIndex;
    private final int @NotNull [] myStartLayoutIndexForHead;
    private int currentLayoutIndex = 1;

    @NotNull
    public static GraphLayoutImpl build(@NotNull LinearGraph graph, @NotNull Comparator<? super Integer> headNodeIndexComparator) {
        List<Integer> heads = new ArrayList();
        for (int i = 0; i < graph.nodesCount(); ++i) {
            if (LinearGraphUtils.getUpNodes(graph, i).size() != 0) continue;
            heads.add(i);
        }
        try {
            heads = ContainerUtil.sorted(heads, headNodeIndexComparator);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        GraphLayoutBuilder builder = new GraphLayoutBuilder(graph, heads);
        return builder.build();
    }

    private GraphLayoutBuilder(@NotNull LinearGraph graph, @NotNull List<Integer> headNodeIndex) {
        this.myGraph = graph;
        this.myLayoutIndex = new int[graph.nodesCount()];
        this.myHeadNodeIndex = headNodeIndex;
        this.myStartLayoutIndexForHead = new int[headNodeIndex.size()];
    }

    private void dfs(int nodeIndex) {
        DfsUtilKt.walk(nodeIndex, (Function1<? super Integer, Integer>)((Function1)currentNode -> {
            boolean firstVisit;
            boolean bl = firstVisit = this.myLayoutIndex[currentNode] == 0;
            if (firstVisit) {
                this.myLayoutIndex[currentNode.intValue()] = this.currentLayoutIndex;
            }
            int childWithoutLayoutIndex = -1;
            for (int childNodeIndex : LinearGraphUtils.getDownNodes(this.myGraph, currentNode)) {
                if (this.myLayoutIndex[childNodeIndex] != 0) continue;
                childWithoutLayoutIndex = childNodeIndex;
                break;
            }
            if (childWithoutLayoutIndex == -1) {
                if (firstVisit) {
                    ++this.currentLayoutIndex;
                }
                return -1;
            }
            return childWithoutLayoutIndex;
        }));
    }

    @NotNull
    private GraphLayoutImpl build() {
        for (int i = 0; i < this.myHeadNodeIndex.size(); ++i) {
            int headNodeIndex = this.myHeadNodeIndex.get(i);
            this.myStartLayoutIndexForHead[i] = this.currentLayoutIndex;
            this.dfs(headNodeIndex);
        }
        return new GraphLayoutImpl(this.myLayoutIndex, this.myHeadNodeIndex, this.myStartLayoutIndexForHead);
    }
}

