/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranch;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class BekBranchMerger {
    @NotNull
    private final List<? extends BekBranch> myBekBranches;
    @NotNull
    private final BekEdgeRestrictions myEdgeRestrictions;
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final List<Integer> myInverseResultList = new ArrayList<Integer>();

    BekBranchMerger(@NotNull List<? extends BekBranch> bekBranches, @NotNull BekEdgeRestrictions edgeRestrictions, @NotNull TimestampGetter timestampGetter) {
        this.myBekBranches = bekBranches;
        this.myEdgeRestrictions = edgeRestrictions;
        this.myTimestampGetter = timestampGetter;
    }

    private boolean prepareLastPartsForBranches() {
        boolean hasUndoneBranches = false;
        for (BekBranch bekBranch : this.myBekBranches) {
            if (bekBranch.isDone()) continue;
            hasUndoneBranches = true;
            if (bekBranch.getPrepareForInsertPart() != null) continue;
            bekBranch.updatePrepareForInsertPart(this.myTimestampGetter, this.myEdgeRestrictions);
        }
        return hasUndoneBranches;
    }

    private long getBranchLastPartTimestamp(BekBranch bekBranch) {
        List<Integer> prepareForInsertPart = bekBranch.getPrepareForInsertPart();
        if (prepareForInsertPart == null) {
            return Long.MAX_VALUE;
        }
        assert (!prepareForInsertPart.isEmpty());
        int nodeIndex = prepareForInsertPart.get(0);
        return this.myTimestampGetter.getTimestamp(nodeIndex);
    }

    private void step() {
        BekBranch selectBranch = this.myBekBranches.get(0);
        for (BekBranch bekBranch : this.myBekBranches) {
            if (this.getBranchLastPartTimestamp(selectBranch) <= this.getBranchLastPartTimestamp(bekBranch)) continue;
            selectBranch = bekBranch;
        }
        List<Integer> prepareForInsertPart = selectBranch.getPrepareForInsertPart();
        assert (prepareForInsertPart != null);
        for (int insertedNode : prepareForInsertPart) {
            this.myEdgeRestrictions.removeRestriction(insertedNode);
        }
        this.myInverseResultList.addAll(ContainerUtil.reverse(prepareForInsertPart));
        selectBranch.doneInsertPreparedPart();
    }

    @NotNull
    public List<Integer> getResult() {
        while (this.prepareLastPartsForBranches()) {
            this.step();
        }
        return ContainerUtil.reverse(this.myInverseResultList);
    }
}

