/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranch;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtilKt;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

class BekBranchCreator {
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final GraphLayoutImpl myGraphLayout;
    @NotNull
    private final Flags myDoneNodes;
    @NotNull
    private final BekEdgeRestrictions myEdgeRestrictions = new BekEdgeRestrictions();

    BekBranchCreator(@NotNull LinearGraph permanentGraph, @NotNull GraphLayoutImpl graphLayout) {
        this.myPermanentGraph = permanentGraph;
        this.myGraphLayout = graphLayout;
        this.myDoneNodes = new BitSetFlags(permanentGraph.nodesCount(), false);
    }

    @NotNull
    public Pair<List<BekBranch>, BekEdgeRestrictions> getResult() {
        ArrayList<BekBranch> bekBranches = new ArrayList<BekBranch>();
        for (int headNode : this.myGraphLayout.getHeadNodeIndex()) {
            List<Integer> nextBranch = this.createNextBranch(headNode);
            bekBranches.add(new BekBranch(this.myPermanentGraph, nextBranch));
        }
        return Pair.create(bekBranches, (Object)this.myEdgeRestrictions);
    }

    public List<Integer> createNextBranch(int headNode) {
        ArrayList<Integer> nodeIndexes = new ArrayList<Integer>();
        assert (!this.myDoneNodes.get(headNode));
        this.myDoneNodes.set(headNode, true);
        nodeIndexes.add(headNode);
        int startLayout = this.myGraphLayout.getLayoutIndex(headNode);
        DfsUtilKt.walk(headNode, (Function1<? super Integer, Integer>)((Function1)currentNode -> {
            int currentLayout = this.myGraphLayout.getLayoutIndex((int)currentNode);
            List<Integer> downNodes = LinearGraphUtils.getDownNodes(this.myPermanentGraph, currentNode);
            for (int i = downNodes.size() - 1; i >= 0; --i) {
                int downNode = downNodes.get(i);
                if (this.myDoneNodes.get(downNode)) {
                    if (this.myGraphLayout.getLayoutIndex(downNode) >= startLayout) continue;
                    this.myEdgeRestrictions.addRestriction((int)currentNode, downNode);
                    continue;
                }
                if (currentLayout > this.myGraphLayout.getLayoutIndex(downNode)) continue;
                boolean hasUndoneUpNodes = false;
                for (int upNode : LinearGraphUtils.getUpNodes(this.myPermanentGraph, downNode)) {
                    if (this.myDoneNodes.get(upNode) || this.myGraphLayout.getLayoutIndex(upNode) > this.myGraphLayout.getLayoutIndex(downNode)) continue;
                    hasUndoneUpNodes = true;
                    break;
                }
                if (hasUndoneUpNodes) continue;
                this.myDoneNodes.set(downNode, true);
                nodeIndexes.add(downNode);
                return downNode;
            }
            return -1;
        }));
        return nodeIndexes;
    }
}

