/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsUserKeyDescriptor;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import gnu.trove.THashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUserIndex
extends VcsLogFullDetailsIndex<Void, VcsShortCommitDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogUserIndex.class);
    @NonNls
    private static final String USERS = "users";
    @NonNls
    private static final String USERS_IDS = "users-ids";
    @NotNull
    private final UserIndexer myUserIndexer;

    public VcsLogUserIndex(@NotNull StorageId storageId, @NotNull VcsUserRegistry userRegistry, @NotNull FatalErrorHandler consumer, @NotNull Disposable disposableParent) throws IOException {
        super(storageId, USERS, new UserIndexer(VcsLogUserIndex.createUsersEnumerator(storageId, userRegistry)), VoidDataExternalizer.INSTANCE, consumer, disposableParent);
        this.myUserIndexer = (UserIndexer)this.myIndexer;
        ((UserIndexer)this.myIndexer).setFatalErrorConsumer((Consumer<? super Exception>)((Consumer)e -> consumer.consume(this, (Throwable)e)));
    }

    @Override
    @Nullable
    protected Pair<ForwardIndex, ForwardIndexAccessor<Integer, Void>> createdForwardIndex() throws IOException {
        return Pair.create((Object)new PersistentMapBasedForwardIndex(this.myStorageId.getStorageFile(this.myName + ".idx"), false), (Object)new KeyCollectionForwardIndexAccessor((DataExternalizer)new IntCollectionDataExternalizer()));
    }

    @NotNull
    private static PersistentEnumeratorBase<VcsUser> createUsersEnumerator(@NotNull StorageId storageId, @NotNull VcsUserRegistry userRegistry) throws IOException {
        Path storageFile = storageId.getStorageFile(USERS_IDS);
        return new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)new VcsUserKeyDescriptor(userRegistry), Page.PAGE_SIZE, null, storageId.getVersion());
    }

    public IntSet getCommitsForUsers(@NotNull Set<? extends VcsUser> users) throws IOException, StorageException {
        IntOpenHashSet ids = new IntOpenHashSet();
        for (VcsUser vcsUser : users) {
            ids.add(this.myUserIndexer.getUserId(vcsUser));
        }
        return this.getCommitsWithAnyKey((IntSet)ids);
    }

    @Nullable
    public VcsUser getAuthorForCommit(int commit) throws IOException {
        Collection<Integer> userIds = this.getKeysForCommit(commit);
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        LOG.assertTrue(userIds.size() == 1);
        return this.myUserIndexer.getUserById((Integer)Objects.requireNonNull(ContainerUtil.getFirstItem(userIds)));
    }

    public int getUserId(@NotNull VcsUser user) throws IOException {
        return this.myUserIndexer.getUserId(user);
    }

    @Nullable
    public VcsUser getUserById(int id) throws IOException {
        return this.myUserIndexer.getUserById(id);
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myUserIndexer.flush();
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myUserIndexer.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    private static class UserIndexer
    implements DataIndexer<Integer, Void, VcsShortCommitDetails> {
        @NotNull
        private final PersistentEnumeratorBase<VcsUser> myUserEnumerator;
        @NotNull
        private Consumer<? super Exception> myFatalErrorConsumer = arg_0 -> ((Logger)VcsLogUserIndex.access$000()).error(arg_0);

        UserIndexer(@NotNull PersistentEnumeratorBase<VcsUser> userEnumerator) {
            this.myUserEnumerator = userEnumerator;
        }

        @NotNull
        public Map<Integer, Void> map(@NotNull VcsShortCommitDetails inputData) {
            THashMap result2 = new THashMap();
            try {
                result2.put(this.myUserEnumerator.enumerate((Object)inputData.getAuthor()), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
            return result2;
        }

        @Nullable
        public VcsUser getUserById(int id) throws IOException {
            return (VcsUser)this.myUserEnumerator.valueOf(id);
        }

        public int getUserId(@NotNull VcsUser user) throws IOException {
            return this.myUserEnumerator.enumerate((Object)user);
        }

        public void setFatalErrorConsumer(@NotNull Consumer<? super Exception> fatalErrorConsumer) {
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        public void flush() {
            this.myUserEnumerator.force();
        }

        public void close() throws IOException {
            this.myUserEnumerator.close();
        }
    }
}

