/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IntListDataExternalizer;
import com.intellij.vcs.log.data.index.LongPairDataExternalizer;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogMessagesTrigramIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogUserIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.VcsIndexableLogProvider;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.statistics.VcsLogIndexCollector;
import com.intellij.vcs.log.util.PersistentSet;
import com.intellij.vcs.log.util.PersistentSetImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NonNls
public class VcsLogPersistentIndex
implements VcsLogModifiableIndex,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogPersistentIndex.class);
    private static final int VERSION = 15;
    public static final VcsLogProgress.ProgressKey INDEXING = new VcsLogProgress.ProgressKey("index");
    @NotNull
    private final Project myProject;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogProgress myProgress;
    @NotNull
    private final Map<VirtualFile, VcsLogIndexer> myIndexers;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final VcsLogBigRepositoriesList myBigRepositoriesList;
    @NotNull
    private final VcsLogIndexCollector myIndexCollector;
    @Nullable
    private final IndexStorage myIndexStorage;
    @Nullable
    private final IndexDataGetter myDataGetter;
    @NotNull
    private final SingleTaskController<IndexingRequest, Void> mySingleTaskController;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myNumberOfTasks = new HashMap<VirtualFile, AtomicInteger>();
    @NotNull
    private final Map<VirtualFile, AtomicLong> myIndexingTime = new HashMap<VirtualFile, AtomicLong>();
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myIndexingLimit = new HashMap<VirtualFile, AtomicInteger>();
    @NotNull
    private final Map<VirtualFile, ConcurrentIntObjectMap<Integer>> myIndexingErrors = new HashMap<VirtualFile, ConcurrentIntObjectMap<Integer>>();
    @NotNull
    private final List<VcsLogIndex.IndexingFinishedListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private Map<VirtualFile, TIntHashSet> myCommitsToIndex = new HashMap<VirtualFile, TIntHashSet>();

    public VcsLogPersistentIndex(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull VcsLogProgress progress, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull FatalErrorHandler fatalErrorsConsumer, @NotNull Disposable disposableParent) {
        this.myStorage = storage;
        this.myProject = project;
        this.myProgress = progress;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        this.myBigRepositoriesList = VcsLogBigRepositoriesList.getInstance();
        this.myIndexCollector = VcsLogIndexCollector.getInstance(this.myProject);
        this.myIndexers = VcsLogPersistentIndex.getAvailableIndexers(providers);
        this.myRoots = new LinkedHashSet<VirtualFile>(this.myIndexers.keySet());
        VcsUserRegistry userRegistry = (VcsUserRegistry)ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        this.myIndexStorage = this.createIndexStorage(fatalErrorsConsumer, this.myProject.getName(), PersistentUtil.calcIndexId(this.myProject, this.myIndexers), userRegistry);
        this.myDataGetter = this.myIndexStorage != null ? new IndexDataGetter(this.myProject, this.myRoots, this.myIndexStorage, this.myStorage, this.myFatalErrorsConsumer) : null;
        for (VirtualFile root : this.myRoots) {
            this.myNumberOfTasks.put(root, new AtomicInteger());
            this.myIndexingTime.put(root, new AtomicLong());
            this.myIndexingLimit.put(root, new AtomicInteger(VcsLogPersistentIndex.getIndexingLimit()));
            this.myIndexingErrors.put(root, (ConcurrentIntObjectMap<Integer>)ContainerUtil.createConcurrentIntObjectMap());
        }
        this.mySingleTaskController = new MySingleTaskController(project, (Disposable)(this.myIndexStorage != null ? this.myIndexStorage : this));
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    private static int getIndexingLimit() {
        return Math.max(1, Registry.intValue((String)"vcs.log.index.limit.minutes"));
    }

    protected IndexStorage createIndexStorage(@NotNull FatalErrorHandler fatalErrorHandler, @NotNull String projectName, @NotNull String logId, @NotNull VcsUserRegistry registry) {
        try {
            return (IndexStorage)IOUtil.openCleanOrResetBroken(() -> new IndexStorage(projectName, logId, this.myStorage, registry, this.myRoots, fatalErrorHandler, this), () -> IndexStorage.cleanup(projectName, logId));
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    @Override
    public void scheduleIndex(boolean full) {
        this.doScheduleIndex(full, (Consumer<IndexingRequest>)((Consumer)request -> this.mySingleTaskController.request((IndexingRequest[])new IndexingRequest[]{request})));
    }

    void indexNow(boolean full) {
        this.doScheduleIndex(full, (Consumer<IndexingRequest>)((Consumer)request -> request.run(this.myProgress.createProgressIndicator(INDEXING))));
    }

    private synchronized void doScheduleIndex(boolean full, @NotNull Consumer<IndexingRequest> requestConsumer) {
        boolean isFull;
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (this.myCommitsToIndex.isEmpty() || this.myIndexStorage == null) {
            return;
        }
        if (this.myIndexStorage.isFresh() && !full) {
            return;
        }
        Map<VirtualFile, TIntHashSet> commitsToIndex = this.myCommitsToIndex;
        this.myCommitsToIndex = new HashMap<VirtualFile, TIntHashSet>();
        boolean bl = isFull = full && this.myIndexStorage.isFresh();
        if (isFull) {
            LOG.debug("Index storage for project " + this.myProject.getName() + " is fresh, scheduling full reindex");
        }
        for (VirtualFile root : commitsToIndex.keySet()) {
            TIntHashSet commits = commitsToIndex.get(root);
            if (commits.isEmpty()) continue;
            if (this.myBigRepositoriesList.isBig(root)) {
                this.myCommitsToIndex.put(root, commits);
                LOG.info("Indexing repository " + root.getName() + " is skipped");
                continue;
            }
            requestConsumer.consume((Object)new IndexingRequest(root, this.myIndexStorage.paths.getPathsEncoder(), commits, isFull));
        }
        if (isFull) {
            this.myIndexCollector.reportFreshIndex();
            this.myIndexStorage.unmarkFresh();
        }
    }

    private void storeDetail(@NotNull VcsLogIndexer.CompressedDetails detail) {
        if (this.myIndexStorage == null) {
            return;
        }
        try {
            int index = this.myStorage.getCommitIndex((Hash)detail.getId(), detail.getRoot());
            this.myIndexStorage.messages.put((Object)index, (Object)detail.getFullMessage());
            this.myIndexStorage.trigrams.update(index, detail);
            this.myIndexStorage.users.update(index, detail);
            this.myIndexStorage.paths.update(index, detail);
            this.myIndexStorage.parents.put((Object)index, (Object)ContainerUtil.map((Collection)detail.getParents(), p -> this.myStorage.getCommitIndex((Hash)p, detail.getRoot())));
            if (!detail.getAuthor().equals(detail.getCommitter())) {
                this.myIndexStorage.committers.put((Object)index, (Object)this.myIndexStorage.users.getUserId(detail.getCommitter()));
            }
            this.myIndexStorage.timestamps.put((Object)index, (Object)Pair.create((Object)detail.getAuthorTime(), (Object)detail.getCommitTime()));
            this.myIndexStorage.commits.put(index);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    private void flush() {
        try {
            if (this.myIndexStorage != null) {
                this.myIndexStorage.messages.force();
                this.myIndexStorage.trigrams.flush();
                this.myIndexStorage.users.flush();
                this.myIndexStorage.paths.flush();
                this.myIndexStorage.parents.force();
                this.myIndexStorage.commits.flush();
                this.myIndexStorage.committers.force();
                this.myIndexStorage.timestamps.force();
            }
        }
        catch (StorageException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    @Override
    public void markCorrupted() {
        if (this.myIndexStorage != null) {
            this.myIndexStorage.commits.markCorrupted();
        }
    }

    @Override
    public boolean isIndexed(int commit) {
        try {
            return this.myIndexStorage == null || this.myIndexStorage.commits.contains(commit);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
    }

    @Override
    public synchronized boolean isIndexed(@NotNull VirtualFile root) {
        return this.isIndexingEnabled(root) && !this.myCommitsToIndex.containsKey(root) && this.myNumberOfTasks.get(root).get() == 0;
    }

    @Override
    public boolean isIndexingEnabled(@NotNull VirtualFile root) {
        if (this.myIndexStorage == null) {
            return false;
        }
        return this.myRoots.contains(root) && !this.myBigRepositoriesList.isBig(root);
    }

    @Override
    public synchronized void markForIndexing(int index, @NotNull VirtualFile root) {
        if (this.isIndexed(index) || !this.myRoots.contains(root)) {
            return;
        }
        TroveUtil.add(this.myCommitsToIndex, root, index);
    }

    @Override
    @Nullable
    public IndexDataGetter getDataGetter() {
        if (this.myIndexStorage == null) {
            return null;
        }
        return this.myDataGetter;
    }

    @Override
    public void addListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        this.myListeners.add(l);
    }

    @Override
    public void removeListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        this.myListeners.remove(l);
    }

    public void dispose() {
    }

    @NotNull
    private static Map<VirtualFile, VcsLogIndexer> getAvailableIndexers(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        LinkedHashMap<VirtualFile, VcsLogIndexer> indexers = new LinkedHashMap<VirtualFile, VcsLogIndexer>();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsLogProvider provider = entry.getValue();
            if (!((Boolean)VcsLogProperties.SUPPORTS_INDEXING.getOrDefault(provider)).booleanValue() || !(provider instanceof VcsIndexableLogProvider)) continue;
            indexers.put(root, ((VcsIndexableLogProvider)provider).getIndexer());
        }
        return indexers;
    }

    @NotNull
    public static Set<VirtualFile> getRootsForIndexing(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        return VcsLogPersistentIndex.getAvailableIndexers(providers).keySet();
    }

    private class IndexingRequest {
        private static final int BATCH_SIZE = 20000;
        private static final int FLUSHED_COMMITS_NUMBER = 15000;
        private static final int LOGGED_ERRORS_COUNT = 10;
        private static final int STOPPING_ERROR_COUNT = 100;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final TIntHashSet myCommits;
        @NotNull
        private final VcsLogIndexer.PathsEncoder myPathsEncoder;
        private final boolean myFull;
        @NotNull
        private final AtomicInteger myNewIndexedCommits = new AtomicInteger();
        @NotNull
        private final AtomicInteger myOldCommits = new AtomicInteger();
        private volatile long myStartTime;

        IndexingRequest(@NotNull VirtualFile root, @NotNull VcsLogIndexer.PathsEncoder encoder, TIntHashSet commits, boolean full) {
            this.myRoot = root;
            this.myPathsEncoder = encoder;
            this.myCommits = commits;
            this.myFull = full;
            ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(root)).incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(this.myRoot)) {
                LOG.info("Indexing repository " + this.myRoot.getName() + " is skipped");
                this.markCommits();
                ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(this.myRoot)).decrementAndGet();
                return;
            }
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            this.myStartTime = this.getCurrentTimeMillis();
            LOG.info("Indexing " + (this.myFull ? "full repository" : this.myCommits.size() + " commits") + " in " + this.myRoot.getName());
            try {
                try {
                    if (this.myFull) {
                        this.indexAll(indicator);
                    } else {
                        IntStream commits = TroveUtil.stream(this.myCommits).filter(c -> {
                            if (VcsLogPersistentIndex.this.isIndexed(c)) {
                                this.myOldCommits.incrementAndGet();
                                return false;
                            }
                            return true;
                        });
                        this.indexOneByOne(commits, indicator);
                    }
                }
                catch (ProcessCanceledException e) {
                    this.scheduleReindex();
                    throw e;
                }
                catch (VcsException e) {
                    this.processException(e);
                    this.scheduleReindex();
                }
            }
            finally {
                ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(this.myRoot)).decrementAndGet();
                ((AtomicLong)VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot)).updateAndGet(t -> t + (this.getCurrentTimeMillis() - this.myStartTime));
                if (VcsLogPersistentIndex.this.isIndexed(this.myRoot)) {
                    long time = ((AtomicLong)VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot)).getAndSet(0L);
                    VcsLogPersistentIndex.this.myIndexCollector.reportIndexingTime(time);
                    VcsLogPersistentIndex.this.myListeners.forEach(listener2 -> listener2.indexingFinished(this.myRoot));
                }
                this.report();
                VcsLogPersistentIndex.this.flush();
            }
        }

        private void processException(@NotNull VcsException e) {
            int errorHash = ThrowableInterner.computeTraceHashCode((Throwable)e);
            int errors = (Integer)((ConcurrentIntObjectMap)VcsLogPersistentIndex.this.myIndexingErrors.get(this.myRoot)).cacheOrGet(errorHash, (Object)0);
            ((ConcurrentIntObjectMap)VcsLogPersistentIndex.this.myIndexingErrors.get(this.myRoot)).put(errorHash, (Object)(errors + 1));
            if (errors <= 10) {
                LOG.error((Throwable)e);
            } else if (errors >= 100) {
                VcsLogPersistentIndex.this.myBigRepositoriesList.addRepository(this.myRoot);
                LOG.error("Stopping indexing of " + this.myRoot.getName() + " due to the large amount of exceptions.", (Throwable)e);
            }
        }

        private long getCurrentTimeMillis() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        }

        private void report() {
            String formattedTime = StopWatch.formatTime(this.getCurrentTimeMillis() - this.myStartTime);
            if (this.myFull) {
                LOG.info(formattedTime + " for indexing " + this.myNewIndexedCommits + " commits in " + this.myRoot.getName());
            } else {
                int leftCommits = this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get();
                String leftCommitsMessage = leftCommits > 0 ? ". " + leftCommits + " commits left" : "";
                LOG.info(formattedTime + " for indexing " + this.myNewIndexedCommits + " new commits out of " + this.myCommits.size() + " in " + this.myRoot.getName() + leftCommitsMessage);
            }
        }

        private void scheduleReindex() {
            LOG.debug("Schedule reindexing of " + (this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get()) + " commits in " + this.myRoot.getName());
            this.markCommits();
            VcsLogPersistentIndex.this.scheduleIndex(false);
        }

        private void markCommits() {
            this.myCommits.forEach(value -> {
                VcsLogPersistentIndex.this.markForIndexing(value, this.myRoot);
                return true;
            });
        }

        private void indexOneByOne(@NotNull IntStream commits, @NotNull ProgressIndicator indicator) throws VcsException {
            TroveUtil.processBatches(commits, 20000, (ThrowableConsumer<? super TIntHashSet, ? extends VcsException>)((ThrowableConsumer)batch -> {
                indicator.checkCanceled();
                List<String> hashes = TroveUtil.map2List(batch, value -> VcsLogPersistentIndex.this.myStorage.getCommitId(value).getHash().asString());
                ((VcsLogIndexer)VcsLogPersistentIndex.this.myIndexers.get(this.myRoot)).readFullDetails(this.myRoot, hashes, this.myPathsEncoder, (Consumer<? super VcsLogIndexer.CompressedDetails>)((Consumer)detail -> {
                    VcsLogPersistentIndex.this.storeDetail(detail);
                    this.myNewIndexedCommits.incrementAndGet();
                    this.checkShouldCancel(indicator);
                }));
            }));
        }

        public void indexAll(@NotNull ProgressIndicator indicator) throws VcsException {
            ((VcsLogIndexer)VcsLogPersistentIndex.this.myIndexers.get(this.myRoot)).readAllFullDetails(this.myRoot, this.myPathsEncoder, (Consumer<? super VcsLogIndexer.CompressedDetails>)((Consumer)details -> {
                VcsLogPersistentIndex.this.storeDetail(details);
                if (this.myNewIndexedCommits.incrementAndGet() % 15000 == 0) {
                    VcsLogPersistentIndex.this.flush();
                }
                this.checkShouldCancel(indicator);
            }));
        }

        private void checkShouldCancel(@NotNull ProgressIndicator indicator) {
            int limit;
            boolean isOvertime;
            long time = ((AtomicLong)VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot)).get() + (this.getCurrentTimeMillis() - this.myStartTime);
            boolean bl = isOvertime = time >= Math.max((long)(limit = ((AtomicInteger)VcsLogPersistentIndex.this.myIndexingLimit.get(this.myRoot)).get()), 1L) * 60L * 1000L && !VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(this.myRoot);
            if (isOvertime || VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(this.myRoot) && !indicator.isCanceled()) {
                LOG.warn("Indexing " + this.myRoot.getName() + " was cancelled after " + StopWatch.formatTime(time));
                if (isOvertime) {
                    VcsLogPersistentIndex.this.myBigRepositoriesList.addRepository(this.myRoot);
                    ((AtomicInteger)VcsLogPersistentIndex.this.myIndexingLimit.get(this.myRoot)).compareAndSet(limit, Math.max(limit + VcsLogPersistentIndex.getIndexingLimit(), (int)((time / (long)(VcsLogPersistentIndex.getIndexingLimit() * 60000) + 1L) * (long)VcsLogPersistentIndex.getIndexingLimit())));
                }
                indicator.cancel();
            }
        }

        public String toString() {
            return "IndexingRequest of " + this.myCommits.size() + " commits in " + this.myRoot.getName() + (this.myFull ? " (full)" : "");
        }
    }

    private class MySingleTaskController
    extends SingleTaskController<IndexingRequest, Void> {
        private static final int LOW_PRIORITY = 1;
        @NotNull
        private final HeavyAwareExecutor myHeavyAwareExecutor;

        MySingleTaskController(@NotNull Project project, Disposable parent) {
            super("index", EmptyConsumer.getInstance(), parent);
            this.myHeavyAwareExecutor = new HeavyAwareExecutor(project, 50, 100, VcsLogPersistentIndex.this);
        }

        @Override
        @NotNull
        protected SingleTaskController.SingleTask startNewBackgroundTask() {
            ProgressIndicator indicator = VcsLogPersistentIndex.this.myProgress.createProgressIndicator(true, INDEXING);
            Consumer task2 = progressIndicator -> {
                int previousPriority = this.setMinimumPriority();
                try {
                    IndexingRequest request;
                    while ((request = (IndexingRequest)this.popRequest()) != null) {
                        try {
                            request.run((ProgressIndicator)progressIndicator);
                            progressIndicator.checkCanceled();
                        }
                        catch (ProcessCanceledException reThrown) {
                            throw reThrown;
                        }
                        catch (Throwable t) {
                            LOG.error("Error while indexing", t);
                        }
                    }
                }
                finally {
                    this.taskCompleted(null);
                    this.resetPriority(previousPriority);
                }
            };
            Future<?> future2 = this.myHeavyAwareExecutor.executeOutOfHeavyOrPowerSave((Consumer<? super ProgressIndicator>)task2, indicator);
            return new SingleTaskController.SingleTaskImpl(future2, indicator);
        }

        public void resetPriority(int previousPriority) {
            if (Thread.currentThread().getPriority() == 1) {
                Thread.currentThread().setPriority(previousPriority);
            }
        }

        public int setMinimumPriority() {
            int previousPriority = Thread.currentThread().getPriority();
            try {
                Thread.currentThread().setPriority(1);
            }
            catch (SecurityException e) {
                LOG.debug("Could not set indexing thread priority", (Throwable)e);
            }
            return previousPriority;
        }
    }

    static class IndexStorage
    implements Disposable {
        private static final String COMMITS = "commits";
        private static final String MESSAGES = "messages";
        private static final String PARENTS = "parents";
        private static final String COMMITTERS = "committers";
        private static final String TIMESTAMPS = "timestamps";
        private static final int MESSAGES_VERSION = 0;
        @NotNull
        public final PersistentSet<Integer> commits;
        @NotNull
        public final PersistentMap<Integer, String> messages;
        @NotNull
        public final PersistentMap<Integer, List<Integer>> parents;
        @NotNull
        public final PersistentMap<Integer, Integer> committers;
        @NotNull
        public final PersistentMap<Integer, Pair<Long, Long>> timestamps;
        @NotNull
        public final VcsLogMessagesTrigramIndex trigrams;
        @NotNull
        public final VcsLogUserIndex users;
        @NotNull
        public final VcsLogPathsIndex paths;
        private volatile boolean myIsFresh;

        IndexStorage(@NotNull String projectName, @NotNull String logId, @NotNull VcsLogStorage storage, @NotNull VcsUserRegistry userRegistry, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable parentDisposable) throws IOException {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
            try {
                StorageId storageId = new StorageId(projectName, "index", logId, IndexStorage.getVersion());
                Path commitsStorage = storageId.getStorageFile(COMMITS);
                this.myIsFresh = !Files.exists(commitsStorage, new LinkOption[0]);
                this.commits = new PersistentSetImpl<Integer>(commitsStorage, (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE, Page.PAGE_SIZE, null, storageId.getVersion());
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::close)));
                Path messagesStorage = new StorageId(projectName, "index", logId, 8).getStorageFile(MESSAGES);
                this.messages = new PersistentHashMap(messagesStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, Page.PAGE_SIZE);
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.messages.close())));
                this.trigrams = new VcsLogMessagesTrigramIndex(storageId, fatalErrorHandler, this);
                this.users = new VcsLogUserIndex(storageId, userRegistry, fatalErrorHandler, this);
                this.paths = new VcsLogPathsIndex(storageId, storage, roots, fatalErrorHandler, this);
                Path parentsStorage = storageId.getStorageFile(PARENTS);
                this.parents = new PersistentHashMap(parentsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntListDataExternalizer(), Page.PAGE_SIZE, storageId.getVersion());
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.parents.close())));
                Path committersStorage = storageId.getStorageFile(COMMITTERS);
                this.committers = new PersistentHashMap(committersStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE, Page.PAGE_SIZE, storageId.getVersion());
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.committers.close())));
                Path timestampsStorage = storageId.getStorageFile(TIMESTAMPS);
                this.timestamps = new PersistentHashMap(timestampsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new LongPairDataExternalizer(), Page.PAGE_SIZE, storageId.getVersion());
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.timestamps.close())));
            }
            catch (Throwable t) {
                Disposer.dispose((Disposable)this);
                throw t;
            }
        }

        void markCorrupted() {
            IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::markCorrupted));
        }

        private static void catchAndWarn(@NotNull ThrowableRunnable<IOException> runnable) {
            try {
                runnable.run();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        private static void cleanup(@NotNull String projectName, @NotNull String logId) {
            StorageId storageId = new StorageId(projectName, "index", logId, IndexStorage.getVersion());
            if (!storageId.cleanupAllStorageFiles()) {
                LOG.error("Could not clean up storage files in " + storageId.getSubdir());
            }
        }

        private static int getVersion() {
            return 23;
        }

        public void unmarkFresh() {
            this.myIsFresh = false;
        }

        public boolean isFresh() {
            return this.myIsFresh;
        }

        public void dispose() {
        }
    }
}

