/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CurrentBranchConditionCache;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\bR \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/data/CurrentBranchConditionCache;", "Lcom/intellij/openapi/Disposable;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "parent", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/openapi/Disposable;)V", "conditions", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$ConditionHolder;", "executor", "Ljava/util/concurrent/ExecutorService;", "clear", "", "dispose", "doGetContainedInCurrentBranchCondition", "Lcom/intellij/openapi/util/Condition;", "", "root", "getContainedInCurrentBranchCondition", "ConditionHolder", "State", "intellij.platform.vcs.log.impl"})
public final class CurrentBranchConditionCache
implements Disposable {
    private final ExecutorService executor;
    private Map<VirtualFile, ? extends AtomicReference<ConditionHolder>> conditions;
    private final VcsLogData logData;

    @NotNull
    public final Condition<Integer> getContainedInCurrentBranchCondition(@NotNull VirtualFile root) {
        ConditionHolder inProgress;
        AtomicReference<ConditionHolder> atomicReference = this.conditions.get(root);
        if (atomicReference == null) {
            return Conditions.alwaysFalse();
        }
        AtomicReference<ConditionHolder> holder = atomicReference;
        ConditionHolder oldCondition = holder.get();
        if (oldCondition.isOutdated() && holder.compareAndSet(oldCondition, inProgress = oldCondition.inProgress())) {
            this.executor.submit(new Runnable(this, inProgress, holder, root){
                final /* synthetic */ CurrentBranchConditionCache this$0;
                final /* synthetic */ ConditionHolder $inProgress;
                final /* synthetic */ AtomicReference $holder;
                final /* synthetic */ VirtualFile $root;

                public final void run() {
                    if (Intrinsics.areEqual((Object)((ConditionHolder)this.$holder.get()), (Object)this.$inProgress)) {
                        this.$holder.compareAndSet(this.$inProgress, new ConditionHolder((Condition<Integer>)CurrentBranchConditionCache.access$doGetContainedInCurrentBranchCondition(this.this$0, this.$root), State.VALID));
                    }
                }
                {
                    this.this$0 = currentBranchConditionCache;
                    this.$inProgress = conditionHolder;
                    this.$holder = atomicReference;
                    this.$root = virtualFile;
                }
            });
        }
        return holder.get().getCondition();
    }

    private final Condition<Integer> doGetContainedInCurrentBranchCondition(VirtualFile root) {
        DataPack dataPack = this.logData.getDataPack();
        if (dataPack == DataPack.EMPTY) {
            return Conditions.alwaysFalse();
        }
        try {
            String string = this.logData.getLogProvider(root).getCurrentBranch(root);
            if (string == null) {
                return Conditions.alwaysFalse();
            }
            String branchName = string;
            VcsRef vcsRef = VcsLogUtil.findBranch(dataPack.getRefsModel(), root, branchName);
            if (vcsRef == null) {
                return Conditions.alwaysFalse();
            }
            VcsRef branchRef = vcsRef;
            int branchIndex = this.logData.getCommitIndex(branchRef.getCommitHash(), branchRef.getRoot());
            return dataPack.getPermanentGraph().getContainedInBranchCondition((Collection)SetsKt.setOf((Object)branchIndex));
        }
        catch (ProcessCanceledException e) {
            return Conditions.alwaysFalse();
        }
    }

    public final void clear() {
        Map<VirtualFile, ? extends AtomicReference<ConditionHolder>> $this$forEach$iv = this.conditions;
        boolean $i$f$forEach = false;
        Map<VirtualFile, ? extends AtomicReference<ConditionHolder>> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<VirtualFile, ? extends AtomicReference<ConditionHolder>>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VirtualFile, ? extends AtomicReference<ConditionHolder>> element$iv;
            Map.Entry<VirtualFile, ? extends AtomicReference<ConditionHolder>> $dstr$_u24__u24$holder = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<VirtualFile, ? extends AtomicReference<ConditionHolder>> entry = $dstr$_u24__u24$holder;
            boolean bl3 = false;
            AtomicReference<ConditionHolder> holder = entry.getValue();
            holder.updateAndGet(clear.1.1.INSTANCE);
        }
    }

    public void dispose() {
        this.executor.shutdownNow();
    }

    /*
     * WARNING - void declaration
     */
    public CurrentBranchConditionCache(@NotNull VcsLogData logData, @NotNull Disposable parent) {
        Map map2;
        void $this$associateWith$iv;
        this.logData = logData;
        this.executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"VcsLog Current Branch Condition", (int)1);
        Iterable iterable = this.logData.getRoots();
        CurrentBranchConditionCache currentBranchConditionCache = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            Object t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            AtomicReference<ConditionHolder> atomicReference = new AtomicReference<ConditionHolder>(new ConditionHolder((Condition<Integer>)Conditions.alwaysFalse(), State.OUTDATED));
            map2.put(t, atomicReference);
        }
        currentBranchConditionCache.conditions = map2 = (Map)result$iv;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public static final /* synthetic */ Condition access$doGetContainedInCurrentBranchCondition(CurrentBranchConditionCache $this, VirtualFile root) {
        return $this.doGetContainedInCurrentBranchCondition(root);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$ConditionHolder;", "", "condition", "Lcom/intellij/openapi/util/Condition;", "", "state", "Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$State;", "(Lcom/intellij/openapi/util/Condition;Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$State;)V", "getCondition", "()Lcom/intellij/openapi/util/Condition;", "getState", "()Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$State;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "inProgress", "isOutdated", "outdated", "toString", "", "withState", "s", "intellij.platform.vcs.log.impl"})
    private static final class ConditionHolder {
        @NotNull
        private final Condition<Integer> condition;
        @NotNull
        private final State state;

        private final ConditionHolder withState(State s) {
            return this.state == s ? this : new ConditionHolder(this.condition, s);
        }

        @NotNull
        public final ConditionHolder outdated() {
            return this.withState(State.OUTDATED);
        }

        @NotNull
        public final ConditionHolder inProgress() {
            return this.withState(State.IN_PROGRESS);
        }

        public final boolean isOutdated() {
            return this.state == State.OUTDATED;
        }

        @NotNull
        public final Condition<Integer> getCondition() {
            return this.condition;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        public ConditionHolder(@NotNull Condition<Integer> condition, @NotNull State state) {
            this.condition = condition;
            this.state = state;
        }

        @NotNull
        public final Condition<Integer> component1() {
            return this.condition;
        }

        @NotNull
        public final State component2() {
            return this.state;
        }

        @NotNull
        public final ConditionHolder copy(@NotNull Condition<Integer> condition, @NotNull State state) {
            return new ConditionHolder(condition, state);
        }

        public static /* synthetic */ ConditionHolder copy$default(ConditionHolder conditionHolder, Condition condition, State state, int n, Object object) {
            if ((n & 1) != 0) {
                condition = conditionHolder.condition;
            }
            if ((n & 2) != 0) {
                state = conditionHolder.state;
            }
            return conditionHolder.copy(condition, state);
        }

        @NotNull
        public String toString() {
            return "ConditionHolder(condition=" + this.condition + ", state=" + (Object)((Object)this.state) + ")";
        }

        public int hashCode() {
            Condition<Integer> condition = this.condition;
            State state = this.state;
            return (condition != null ? condition.hashCode() : 0) * 31 + (state != null ? ((Object)((Object)state)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ConditionHolder)) break block3;
                    ConditionHolder conditionHolder = (ConditionHolder)object;
                    if (!Intrinsics.areEqual(this.condition, conditionHolder.condition) || !Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)conditionHolder.state))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$State;", "", "(Ljava/lang/String;I)V", "VALID", "OUTDATED", "IN_PROGRESS", "intellij.platform.vcs.log.impl"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State VALID;
        public static final /* enum */ State OUTDATED;
        public static final /* enum */ State IN_PROGRESS;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = VALID = new State();
            stateArray[1] = OUTDATED = new State();
            stateArray[2] = IN_PROGRESS = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

