/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CurrentBranchConditionCache;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import com.intellij.vcs.log.util.StopWatch;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainingBranchesGetter {
    private static final Logger LOG = Logger.getInstance(ContainingBranchesGetter.class);
    @NotNull
    private final SequentialLimitedLifoExecutor<CachingTask> myTaskExecutor;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final List<Runnable> myLoadingFinishedListeners = new ArrayList<Runnable>();
    @NotNull
    private SLRUMap<CommitId, List<String>> myCache = ContainingBranchesGetter.createCache();
    @NotNull
    private final CurrentBranchConditionCache myConditionsCache;
    private int myCurrentBranchesChecksum;

    ContainingBranchesGetter(@NotNull VcsLogData logData, @NotNull Disposable parentDisposable) {
        this.myLogData = logData;
        this.myConditionsCache = new CurrentBranchConditionCache(logData, parentDisposable);
        this.myTaskExecutor = new SequentialLimitedLifoExecutor(parentDisposable, 10, CachingTask::run);
        this.myLogData.addDataPackChangeListener(dataPack -> {
            Collection<VcsRef> currentBranches = dataPack.getRefsModel().getBranches();
            int checksum = currentBranches.hashCode();
            if (this.myCurrentBranchesChecksum != 0 && this.myCurrentBranchesChecksum != checksum) {
                this.clearCache();
            }
            this.myCurrentBranchesChecksum = checksum;
        });
    }

    private void clearCache() {
        this.myCache = ContainingBranchesGetter.createCache();
        this.myTaskExecutor.clear();
        this.myConditionsCache.clear();
        ApplicationManager.getApplication().invokeLater(this::notifyListeners);
    }

    public void addTaskCompletedListener(@NotNull Runnable runnable) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.add(runnable);
    }

    public void removeTaskCompletedListener(@NotNull Runnable runnable) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.remove(runnable);
    }

    private void notifyListeners() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        for (Runnable listener2 : this.myLoadingFinishedListeners) {
            listener2.run();
        }
    }

    @Nullable
    public List<String> requestContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        List<String> refs = this.getContainingBranchesFromCache(root, hash);
        if (refs == null) {
            this.myTaskExecutor.queue(new CachingTask(this.createTask(root, hash, this.myLogData.getDataPack()), this.myCache));
        }
        return refs;
    }

    @Nullable
    public List<String> getContainingBranchesFromCache(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        return (List)this.myCache.get((Object)new CommitId(hash, root));
    }

    @Nullable
    public List<String> getContainingBranchesQuickly(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        CommitId commitId = new CommitId(hash, root);
        List<String> branches = (List<String>)this.myCache.get((Object)commitId);
        if (branches == null) {
            int nodeId;
            int index = this.myLogData.getCommitIndex(hash, root);
            PermanentGraph<Integer> pg = this.myLogData.getDataPack().getPermanentGraph();
            if (pg instanceof PermanentGraphInfo && (branches = (nodeId = ((PermanentGraphInfo)pg).getPermanentCommitsInfo().getNodeId(index)) < 10000 && ContainingBranchesGetter.canUseGraphForComputation(this.myLogData.getLogProvider(root)) ? this.getContainingBranchesSynchronously(root, hash) : (List)BackgroundTaskUtil.tryComputeFast(indicator -> this.getContainingBranchesSynchronously(root, hash), (long)100L)) != null) {
                this.myCache.put((Object)commitId, branches);
            }
        }
        return branches;
    }

    @NotNull
    public Condition<Integer> getContainedInCurrentBranchCondition(@NotNull VirtualFile root) {
        return this.myConditionsCache.getContainedInCurrentBranchCondition(root);
    }

    @NotNull
    private static SLRUMap<CommitId, List<String>> createCache() {
        return new SLRUMap(1000, 1000);
    }

    @NotNull
    public List<String> getContainingBranchesSynchronously(@NotNull VirtualFile root, @NotNull Hash hash) {
        return this.createTask(root, hash, this.myLogData.getDataPack()).getContainingBranches();
    }

    @NotNull
    private Task createTask(@NotNull VirtualFile root, @NotNull Hash hash, @NotNull DataPack dataPack) {
        VcsLogProvider provider = this.myLogData.getLogProvider(root);
        if (ContainingBranchesGetter.canUseGraphForComputation(provider)) {
            return new GraphTask(provider, root, hash, dataPack);
        }
        return new ProviderTask(provider, root, hash);
    }

    private static boolean canUseGraphForComputation(@NotNull VcsLogProvider logProvider) {
        return (Boolean)VcsLogProperties.LIGHTWEIGHT_BRANCHES.getOrDefault(logProvider);
    }

    private class CachingTask {
        @NotNull
        private final Task myTask;
        @NotNull
        private final SLRUMap<CommitId, List<String>> myCache;

        CachingTask(@NotNull Task task2, SLRUMap<CommitId, List<String>> cache) {
            this.myTask = task2;
            this.myCache = cache;
        }

        public void run() {
            List<String> branches = this.myTask.getContainingBranches();
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myCache.put((Object)new CommitId(this.myTask.myHash, this.myTask.myRoot), (Object)branches);
                ContainingBranchesGetter.this.notifyListeners();
            });
        }
    }

    private static class ProviderTask
    extends Task {
        ProviderTask(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) {
            super(provider, root, hash);
        }

        @Override
        @NotNull
        public List<String> getContainingBranches(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
            ArrayList<String> branches = new ArrayList<String>(provider.getContainingBranches(root, hash));
            Collections.sort(branches);
            return branches;
        }
    }

    private class GraphTask
    extends Task {
        @NotNull
        private final RefsModel myRefs;
        @NotNull
        private final PermanentGraph<Integer> myGraph;

        GraphTask(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash, DataPack dataPack) {
            super(provider, root, hash);
            this.myGraph = dataPack.getPermanentGraph();
            this.myRefs = dataPack.getRefsModel();
        }

        @Override
        @NotNull
        protected List<String> getContainingBranches(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) {
            Set branchesIndexes = this.myGraph.getContainingBranches((Object)ContainingBranchesGetter.this.myLogData.getCommitIndex(hash, root));
            Collection branchesRefs = new HashSet();
            for (Integer index : branchesIndexes) {
                this.myRefs.refsToCommit(index).stream().filter(ref -> ref.getType().isBranch()).forEach(branchesRefs::add);
            }
            branchesRefs = ContainerUtil.sorted(branchesRefs, (Comparator)provider.getReferenceManager().getLabelsOrderComparator());
            ArrayList<String> branchesList = new ArrayList<String>();
            for (VcsRef ref2 : branchesRefs) {
                branchesList.add(ref2.getName());
            }
            return branchesList;
        }
    }

    private static abstract class Task {
        @NotNull
        private final VcsLogProvider myProvider;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final Hash myHash;

        Task(@NotNull VcsLogProvider provider, @NotNull VirtualFile root, @NotNull Hash hash) {
            this.myProvider = provider;
            this.myRoot = root;
            this.myHash = hash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public List<String> getContainingBranches() {
            StopWatch sw = StopWatch.start("get containing branches");
            try {
                List<String> list = this.getContainingBranches(this.myProvider, this.myRoot, this.myHash);
                return list;
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                List<String> list = Collections.emptyList();
                return list;
            }
            finally {
                sw.report();
            }
        }

        @NotNull
        protected abstract List<String> getContainingBranches(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull Hash var3) throws VcsException;
    }
}

