/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.ArrayDeque;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class ProgressManagerQueue {
    private static final Logger LOG = Logger.getInstance(ProgressManagerQueue.class);
    private final Task.Backgroundable myQueuePollTask;
    private final Object myLock = new Object();
    private final Queue<Runnable> myQueue = new ArrayDeque<Runnable>();
    @NotNull
    private final Project myProject;
    private boolean myIsStarted;
    private boolean myActive;

    public ProgressManagerQueue(@NotNull Project project, @NotNull String title2) {
        this.myProject = project;
        this.myQueuePollTask = new Task.Backgroundable(project, title2){

            public void run(@NotNull ProgressIndicator indicator) {
                ProgressManagerQueue.this.pumpQueue();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.myLock;
        synchronized (object) {
            this.myIsStarted = true;
        }
        this.startProgressIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProgressIfNeeded() {
        if (this.myProject.isDisposed()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myIsStarted || this.myActive || this.myQueue.isEmpty()) {
                return;
            }
            this.myActive = true;
        }
        this.myQueuePollTask.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Runnable stuff) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            stuff.run();
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myQueue.add(stuff);
        }
        this.startProgressIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpQueue() {
        while (true) {
            Runnable stuff;
            Object object = this.myLock;
            synchronized (object) {
                stuff = this.myQueue.poll();
                if (stuff == null) {
                    this.myActive = false;
                    return;
                }
            }
            try {
                stuff.run();
                continue;
            }
            catch (ProcessCanceledException processCanceledException) {
                continue;
            }
            catch (Throwable t) {
                LOG.warn(t);
                continue;
            }
            break;
        }
    }
}

