/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;

public interface ScopeInfo {
    public static final ScopeInfo PROJECT = new ScopeInfo(){

        @Override
        public String getScopeName(VcsContext dataContext, ActionInfo actionInfo) {
            return VcsBundle.message((String)"update.project.scope.name", (Object[])new Object[0]);
        }

        @Override
        public boolean filterExistsInVcs() {
            return true;
        }

        @Override
        public FilePath[] getRoots(VcsContext context, ActionInfo actionInfo) {
            AbstractVcs[] vcses;
            ArrayList<FilePath> result2 = new ArrayList<FilePath>();
            Project project = context.getProject();
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
            for (AbstractVcs vcs : vcses = vcsManager2.getAllActiveVcss()) {
                VirtualFile[] files;
                if (actionInfo.getEnvironment(vcs) == null) continue;
                for (VirtualFile file : files = vcsManager2.getRootsUnderVcs(vcs)) {
                    result2.add(VcsUtil.getFilePath((VirtualFile)file));
                }
            }
            return result2.toArray(new FilePath[0]);
        }
    };
    public static final ScopeInfo FILES = new ScopeInfo(){

        @Override
        public String getScopeName(VcsContext dataContext, ActionInfo actionInfo) {
            FilePath[] roots = this.getRoots(dataContext, actionInfo);
            if (roots == null || roots.length == 0) {
                return VcsBundle.message((String)"update.files.scope.name", (Object[])new Object[0]);
            }
            boolean directory = roots[0].isDirectory();
            if (roots.length == 1) {
                if (directory) {
                    return VcsBundle.message((String)"update.directory.scope.name", (Object[])new Object[0]);
                }
                return VcsBundle.message((String)"update.file.scope.name", (Object[])new Object[0]);
            }
            if (directory) {
                return VcsBundle.message((String)"update.directories.scope.name", (Object[])new Object[0]);
            }
            return VcsBundle.message((String)"update.files.scope.name", (Object[])new Object[0]);
        }

        @Override
        public boolean filterExistsInVcs() {
            return true;
        }

        @Override
        public FilePath[] getRoots(VcsContext context, ActionInfo actionInfo) {
            return context.getSelectedFilePaths();
        }
    };

    public FilePath[] getRoots(VcsContext var1, ActionInfo var2);

    public String getScopeName(VcsContext var1, ActionInfo var2);

    public boolean filterExistsInVcs();
}

