/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.impl.projectlevelman.FilePathMapping;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RecursiveFilePathSet {
    private final FilePathMapping<FilePath> myMapping;

    public RecursiveFilePathSet(boolean caseSensitive) {
        this.myMapping = new FilePathMapping(caseSensitive);
    }

    public void add(@NotNull FilePath filePath) {
        this.myMapping.add(filePath.getPath(), filePath);
    }

    public void remove(@NotNull FilePath filePath) {
        this.myMapping.remove(filePath.getPath());
    }

    public boolean hasAncestor(@NotNull FilePath filePath) {
        return this.myMapping.getMappingFor(filePath) != null;
    }

    @NotNull
    public Collection<FilePath> filePaths() {
        return this.myMapping.values();
    }
}

