/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangesUnderRoots {
    private final ChangeListManager myChangeManager;
    private final ProjectLevelVcsManager myVcsManager;

    public LocalChangesUnderRoots(@NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        this.myChangeManager = changeListManager;
        this.myVcsManager = projectLevelVcsManager;
    }

    @NotNull
    public Map<String, Map<VirtualFile, Collection<Change>>> getChangesByLists(@NotNull Collection<? extends VirtualFile> rootsToSave) {
        HashMap<String, Map<VirtualFile, Collection<Change>>> result2 = new HashMap<String, Map<VirtualFile, Collection<Change>>>();
        for (LocalChangeList list : this.myChangeManager.getChangeListsCopy()) {
            result2.put(list.getName(), this.groupChanges(rootsToSave, list.getChanges()));
        }
        return result2;
    }

    @NotNull
    public Map<VirtualFile, Collection<Change>> getChangesUnderRoots(@NotNull Collection<? extends VirtualFile> rootsToSave) {
        return this.groupChanges(rootsToSave, this.myChangeManager.getAllChanges());
    }

    @NotNull
    private Map<VirtualFile, Collection<Change>> groupChanges(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull Collection<? extends Change> allChanges) {
        HashMap<VirtualFile, Collection<Change>> result2 = new HashMap<VirtualFile, Collection<Change>>();
        for (Change change : allChanges) {
            VirtualFile root = this.getRootForChange(change);
            if (root == null || !rootsToSave.contains(root)) continue;
            Collection changes = result2.computeIfAbsent(root, key -> new HashSet());
            changes.add(change);
        }
        return result2;
    }

    @Nullable
    private VirtualFile getRootForChange(@NotNull Change change) {
        FilePath bPath = ChangesUtil.getBeforePath((Change)change);
        FilePath aPath = ChangesUtil.getAfterPath((Change)change);
        VirtualFile root = this.getRootForPath(aPath);
        if (root == null && !Comparing.equal((Object)bPath, (Object)aPath)) {
            root = this.getRootForPath(bPath);
        }
        return root;
    }

    @Nullable
    private VirtualFile getRootForPath(@Nullable FilePath file) {
        if (file == null) {
            return null;
        }
        return this.myVcsManager.getVcsRootFor(file);
    }
}

