/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.impl;

import com.intellij.CommonBundle;
import com.intellij.diff.Block;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IntPair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsSelectionHistoryDialog
extends FrameWrapper
implements DataProvider {
    private static final DataKey<VcsSelectionHistoryDialog> SELECTION_HISTORY_DIALOG_KEY = DataKey.create((String)"VCS_SELECTION_HISTORY_DIALOG");
    private static final VcsRevisionNumber LOCAL_REVISION_NUMBER = new VcsRevisionNumber(){

        @Nls
        @NotNull
        public String asString() {
            return VcsBundle.message((String)"selection.history.local.revision.text", (Object[])new Object[0]);
        }

        public int compareTo(@NotNull VcsRevisionNumber vcsRevisionNumber) {
            return 0;
        }

        @NonNls
        public String toString() {
            return "Local Changes";
        }
    };
    private static final float DIFF_SPLITTER_PROPORTION = 0.5f;
    private static final float COMMENTS_SPLITTER_PROPORTION = 0.8f;
    private static final String DIFF_SPLITTER_PROPORTION_KEY = "file.history.selection.diff.splitter.proportion";
    private static final String COMMENTS_SPLITTER_PROPORTION_KEY = "file.history.selection.comments.splitter.proportion";
    private static final Block EMPTY_BLOCK = new Block("", 0, 0);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final AbstractVcs myActiveVcs;
    @NotNull
    private final VcsHistoryProvider myVcsHistoryProvider;
    private final ColumnInfo[] myDefaultColumns;
    private ListTableModel<VcsFileRevision> myListModel;
    private final TableView<VcsFileRevision> myList;
    private final Splitter mySplitter;
    private final DiffRequestPanel myDiffPanel;
    private final JCheckBox myChangesOnlyCheckBox = new JCheckBox(VcsBundle.message((String)"checkbox.show.changed.revisions.only", (Object[])new Object[0]));
    private final JLabel myStatusLabel = new JBLabel();
    private final AnimatedIcon myStatusSpinner = new AsyncProcessIcon("VcsSelectionHistoryDialog");
    private final JEditorPane myComments;
    private final Wrapper myDetailsPanel = new Wrapper();
    @Nullable
    private Consumer<VcsFileRevision> mySelectedRevisionListener;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @NotNull
    private final BlockLoader myBlockLoader;
    private boolean myRevisionsLoaded = false;
    private boolean myIsDuringUpdate = false;
    private boolean myIsDisposed = false;

    public VcsSelectionHistoryDialog(@NotNull Project project, @NotNull VirtualFile file, @NotNull Document document, @NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull AbstractVcs vcs, int selectionStart, int selectionEnd, @NotNull String title2) {
        super(project, "VCS.FileHistoryDialog");
        this.myProject = project;
        this.myFile = file;
        this.myActiveVcs = vcs;
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myComments = new JEditorPane("text/html", "");
        this.myComments.setPreferredSize((Dimension)new JBDimension(150, 100));
        this.myComments.setEditable(false);
        this.myComments.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myDefaultColumns = new ColumnInfo[]{new FileHistoryPanelImpl.RevisionColumnInfo(null), new FileHistoryPanelImpl.DateColumnInfo(), new FileHistoryPanelImpl.AuthorColumnInfo(), new FileHistoryPanelImpl.MessageColumnInfo(project)};
        this.myListModel = new ListTableModel(this.myDefaultColumns);
        this.myListModel.setSortable(false);
        this.myList = new TableView(this.myListModel);
        new TableLinkMouseListener().installOn((Component)this.myList);
        this.myList.getEmptyText().setText(VcsBundle.message((String)"history.loading.revisions", (Object[])new Object[0]));
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(this.myProject, (Disposable)this, this.getFrame());
        this.myUpdateQueue = new MergingUpdateQueue("VcsSelectionHistoryDialog", 300, true, this.myList, (Disposable)this);
        this.mySplitter = new JBSplitter(true, DIFF_SPLITTER_PROPORTION_KEY, 0.5f);
        this.mySplitter.setFirstComponent(this.myDiffPanel.getComponent());
        this.mySplitter.setSecondComponent(this.createBottomPanel());
        ListSelectionListener selectionListener2 = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VcsFileRevision revision;
                if (VcsSelectionHistoryDialog.this.myList.getSelectedRowCount() == 1 && !VcsSelectionHistoryDialog.this.myList.isEmpty()) {
                    revision = (VcsFileRevision)VcsSelectionHistoryDialog.this.myList.getItems().get(VcsSelectionHistoryDialog.this.myList.getSelectedRow());
                    String message = IssueLinkHtmlRenderer.formatTextIntoHtml(VcsSelectionHistoryDialog.this.myProject, Objects.requireNonNull(revision.getCommitMessage()));
                    VcsSelectionHistoryDialog.this.myComments.setText(message);
                    VcsSelectionHistoryDialog.this.myComments.setCaretPosition(0);
                } else {
                    revision = null;
                    VcsSelectionHistoryDialog.this.myComments.setText("");
                }
                if (VcsSelectionHistoryDialog.this.mySelectedRevisionListener != null) {
                    VcsSelectionHistoryDialog.this.mySelectedRevisionListener.consume((Object)revision);
                }
                VcsSelectionHistoryDialog.this.updateDiff();
            }
        };
        this.myList.getSelectionModel().addListSelectionListener(selectionListener2);
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myChangesOnlyCheckBox.setSelected(configuration.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF);
        this.myChangesOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                configuration.SHOW_ONLY_CHANGED_IN_SELECTION_DIFF = VcsSelectionHistoryDialog.this.myChangesOnlyCheckBox.isSelected();
                VcsSelectionHistoryDialog.this.updateRevisionsList();
            }
        });
        ActionGroup popupActions = (ActionGroup)ActionManager.getInstance().getAction("VcsSelectionHistoryDialog.Popup");
        PopupHandler.installPopupHandler(this.myList, (ActionGroup)popupActions, (String)"UpdatePopup", (ActionManager)ActionManager.getInstance());
        this.setTitle(title2);
        this.setComponent((JComponent)this.mySplitter);
        this.setPreferredFocusedComponent((JComponent)this.myList);
        this.closeOnEsc();
        this.myBlockLoader = new BlockLoader(this.myActiveVcs, this.myFile, document, selectionStart, selectionEnd){

            @Override
            protected void notifyError(@NotNull VcsException e) {
                this.runOnEdt(() -> PopupUtil.showBalloonForComponent((Component)VcsSelectionHistoryDialog.this.mySplitter, (String)VcsSelectionHistoryDialog.canNoLoadMessage(e), (MessageType)MessageType.ERROR, (boolean)true, (Disposable)VcsSelectionHistoryDialog.this.myProject));
            }

            @Override
            protected void notifyUpdate(boolean shouldFlush) {
                VcsSelectionHistoryDialog.this.myUpdateQueue.queue(new Update(this){

                    public void run() {
                        VcsSelectionHistoryDialog.this.updateStatusPanel();
                        VcsSelectionHistoryDialog.this.updateRevisionsList();
                    }
                });
                if (shouldFlush) {
                    this.runOnEdt(() -> VcsSelectionHistoryDialog.this.myUpdateQueue.flush());
                }
            }

            private void runOnEdt(@NotNull Runnable task2) {
                GuiUtils.invokeLaterIfNeeded(() -> {
                    VcsSelectionHistoryDialog dialog = VcsSelectionHistoryDialog.this;
                    if (!dialog.isDisposed() && dialog.getFrame().isShowing()) {
                        task2.run();
                    }
                }, (ModalityState)ModalityState.stateForComponent((Component)VcsSelectionHistoryDialog.this.mySplitter));
            }
        };
        this.myBlockLoader.start((Disposable)this);
        this.updateRevisionsList();
        this.updateDiff();
    }

    @Nls
    @NotNull
    private static String canNoLoadMessage(@Nullable VcsException e) {
        return VcsBundle.message((String)"selection.history.can.not.load.message", (Object[])new Object[0]) + (e != null ? ": " + e.getLocalizedMessage() : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRevisionsList() {
        if (this.myIsDuringUpdate) {
            return;
        }
        try {
            this.myIsDuringUpdate = true;
            BlockData data = this.myBlockLoader.getLoadedData();
            if (data.getRevisions().isEmpty()) {
                return;
            }
            if (!this.myRevisionsLoaded) {
                this.myRevisionsLoaded = true;
                JRootPane rootPane = ((RootPaneContainer)((Object)this.getFrame())).getRootPane();
                VcsDependentHistoryComponents components = this.myVcsHistoryProvider.getUICustomization(data.getSession(), (JComponent)rootPane);
                Object[] additionalColumns = components.getColumns();
                this.myListModel = new ListTableModel((ColumnInfo[])ArrayUtil.mergeArrays((Object[])this.myDefaultColumns, (Object[])additionalColumns, ColumnInfo[]::new));
                this.myListModel.setSortable(false);
                this.myList.setModel(this.myListModel);
                this.mySelectedRevisionListener = components.getRevisionListener();
                this.myDetailsPanel.setContent(components.getDetailsComponent());
            }
            List<VcsFileRevision> newItems = this.myChangesOnlyCheckBox.isSelected() ? this.filteredRevisions(data) : data.getRevisions();
            IntPair range = this.getSelectedRevisionsRange(data);
            List oldSelection = data.getRevisions().subList(range.first, range.second);
            this.myListModel.setItems(newItems);
            this.myList.setSelection(oldSelection);
            if (this.myList.getSelectedRowCount() == 0) {
                int index = this.getNearestVisibleRevision((VcsFileRevision)ContainerUtil.getFirstItem(oldSelection), data);
                if (this.myList.getRowCount() != 0) {
                    this.myList.getSelectionModel().setSelectionInterval(index, index);
                }
            }
            TableUtil.scrollSelectionToVisible(this.myList);
        }
        finally {
            this.myIsDuringUpdate = false;
        }
        this.updateDiff();
    }

    private void updateStatusPanel() {
        BlockData data = this.myBlockLoader.getLoadedData();
        if (data.isLoading()) {
            VcsFileRevision revision = data.getCurrentLoadingRevision();
            String message = revision != null ? VcsBundle.message((String)"selection.history.loading.revision.status", (Object[])new Object[]{XmlStringUtil.wrapInHtmlTag((String)VcsUtil.getShortRevisionString((VcsRevisionNumber)revision.getRevisionNumber()), (String)"tt")}) : CommonBundle.getLoadingTreeNodeText();
            int totalRevisions = data.getRevisions().size();
            if (totalRevisions != 0) {
                message = message + String.format(" (%s/%s)", data.myBlocks.size(), totalRevisions);
            }
            this.myStatusLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)message));
            this.myStatusSpinner.resume();
            this.myStatusSpinner.setVisible(true);
        } else {
            this.myStatusLabel.setText("");
            this.myStatusSpinner.suspend();
            this.myStatusSpinner.setVisible(false);
        }
    }

    @NotNull
    private IntPair getSelectedRevisionsRange(@NotNull BlockData blockData) {
        List selection = this.myList.getSelectedObjects();
        if (selection.isEmpty()) {
            return new IntPair(0, 0);
        }
        int startIndex = blockData.getRevisions().indexOf(ContainerUtil.getFirstItem((List)selection));
        int endIndex = blockData.getRevisions().indexOf(ContainerUtil.getLastItem((List)selection));
        return new IntPair(startIndex, endIndex + 1);
    }

    private int getNearestVisibleRevision(@Nullable VcsFileRevision anchor, @NotNull BlockData blockData) {
        int anchorIndex = blockData.getRevisions().indexOf(anchor);
        if (anchorIndex == -1) {
            return 0;
        }
        for (int i = anchorIndex - 1; i > 0; --i) {
            int index = this.myListModel.indexOf(blockData.getRevisions().get(i));
            if (index == -1) continue;
            return index;
        }
        return 0;
    }

    private List<VcsFileRevision> filteredRevisions(@NotNull BlockData blockData) {
        int initialCommit;
        Block initialCommitBlock;
        ArrayList<VcsFileRevision> result2 = new ArrayList<VcsFileRevision>();
        BlockData data = this.myBlockLoader.getLoadedData();
        for (int i = 1; i < blockData.getRevisions().size(); ++i) {
            Block block1 = data.getBlock(i - 1);
            Block block2 = data.getBlock(i);
            if (block1 == null || block2 == null) break;
            if (!block1.getLines().equals(block2.getLines())) {
                result2.add((VcsFileRevision)blockData.getRevisions().get(i - 1));
            }
            if (block2 == EMPTY_BLOCK) break;
        }
        if ((initialCommitBlock = data.getBlock(initialCommit = blockData.getRevisions().size() - 1)) != null && initialCommitBlock != EMPTY_BLOCK) {
            result2.add((VcsFileRevision)blockData.getRevisions().get(initialCommit));
        }
        return result2;
    }

    private void updateDiff() {
        if (this.myIsDisposed || this.myIsDuringUpdate) {
            return;
        }
        if (this.myList.getSelectedRowCount() == 0) {
            this.myDiffPanel.setRequest((DiffRequest)NoDiffRequest.INSTANCE);
            return;
        }
        BlockData blockData = this.myBlockLoader.getLoadedData();
        int count = blockData.getRevisions().size();
        if (count == 0) {
            this.myDiffPanel.setRequest((DiffRequest)new LoadingDiffRequest());
            return;
        }
        IntPair range = this.getSelectedRevisionsRange(blockData);
        int revIndex1 = range.second;
        int revIndex2 = range.first;
        if (revIndex1 == count && revIndex2 == count) {
            this.myDiffPanel.setRequest((DiffRequest)NoDiffRequest.INSTANCE);
            return;
        }
        DiffContent content1 = this.createDiffContent(revIndex1, blockData);
        DiffContent content2 = this.createDiffContent(revIndex2, blockData);
        String title1 = VcsSelectionHistoryDialog.createDiffContentTitle(revIndex1, blockData);
        String title2 = VcsSelectionHistoryDialog.createDiffContentTitle(revIndex2, blockData);
        if (content1 != null && content2 != null) {
            this.myDiffPanel.setRequest((DiffRequest)new SimpleDiffRequest(null, content1, content2, title1, title2), (Object)new IntPair(revIndex1, revIndex2));
            return;
        }
        if (blockData.isLoading()) {
            this.myDiffPanel.setRequest((DiffRequest)new LoadingDiffRequest());
        } else {
            this.myDiffPanel.setRequest((DiffRequest)new MessageDiffRequest(VcsSelectionHistoryDialog.canNoLoadMessage(blockData.getException())));
        }
    }

    @Nullable
    private static String createDiffContentTitle(int index, @NotNull BlockData data) {
        if (index >= data.getRevisions().size()) {
            return null;
        }
        return VcsBundle.message((String)"diff.content.title.revision.number", (Object[])new Object[]{((VcsFileRevision)data.getRevisions().get(index)).getRevisionNumber()});
    }

    @Nullable
    private DiffContent createDiffContent(int index, @NotNull BlockData data) {
        if (index >= data.getRevisions().size()) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        Block block = data.getBlock(index);
        if (block == null) {
            return null;
        }
        if (block == EMPTY_BLOCK) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(block.getBlockContent(), this.myFile.getFileType());
        documentContent.putUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR, value -> value + block.getStart());
        return documentContent;
    }

    public void dispose() {
        this.myIsDisposed = true;
        super.dispose();
    }

    private JComponent createBottomPanel() {
        JBSplitter splitter = new JBSplitter(true, COMMENTS_SPLITTER_PROPORTION_KEY, 0.8f);
        splitter.setDividerWidth(4);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)ScrollPaneFactory.createScrollPane(this.myList), "Center");
        JPanel statusPanel = new JPanel(new FlowLayout());
        statusPanel.add((Component)this.myStatusSpinner);
        statusPanel.add(this.myStatusLabel);
        JPanel separatorPanel = new JPanel(new BorderLayout());
        separatorPanel.add((Component)this.myChangesOnlyCheckBox, "West");
        separatorPanel.add((Component)statusPanel, "East");
        tablePanel.add((Component)separatorPanel, "North");
        splitter.setFirstComponent((JComponent)tablePanel);
        splitter.setSecondComponent(this.createComments());
        return splitter;
    }

    private JComponent createComments() {
        JPanel panel2 = new JPanel(new BorderLayout(4, 4));
        panel2.add((Component)new JLabel(VcsBundle.message((String)"selection.history.commit.message.label", (Object[])new Object[0])), "North");
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myComments), "Center");
        Splitter splitter = new Splitter(false);
        splitter.setFirstComponent((JComponent)panel2);
        splitter.setSecondComponent((JComponent)this.myDetailsPanel);
        return splitter;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (SELECTION_HISTORY_DIALOG_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            VcsFileRevision selectedObject = (VcsFileRevision)this.myList.getSelectedObject();
            return selectedObject instanceof CurrentRevision ? null : selectedObject;
        }
        if (VcsDataKeys.VCS_FILE_REVISIONS.is(dataId)) {
            return ContainerUtil.filter((Collection)this.myList.getSelectedObjects(), (Condition)Conditions.notEqualTo((Object)this.myBlockLoader.getLocalRevision())).toArray(new VcsFileRevision[0]);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            return this.myActiveVcs.getKeyInstanceMethod();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return ObjectUtils.notNull((Object)this.myVcsHistoryProvider.getHelpId(), (Object)"reference.dialogs.vcs.selection.history");
        }
        return null;
    }

    @NotNull
    private DiffFromHistoryHandler getDiffHandler() {
        VcsHistoryProvider historyProvider = this.myActiveVcs.getVcsHistoryProvider();
        DiffFromHistoryHandler handler = historyProvider != null ? historyProvider.getHistoryDiffHandler() : null;
        return handler != null ? handler : new StandardDiffFromHistoryHandler();
    }

    public static class MyDiffAfterWithLocalAction
    implements AnActionExtensionProvider {
        public boolean isActive(@NotNull AnActionEvent e) {
            return e.getData(SELECTION_HISTORY_DIALOG_KEY) != null;
        }

        public void update(@NotNull AnActionEvent e) {
            VcsSelectionHistoryDialog dialog = (VcsSelectionHistoryDialog)((Object)e.getRequiredData(SELECTION_HISTORY_DIALOG_KEY));
            e.getPresentation().setEnabled(dialog.myList.getSelectedRowCount() == 1 && dialog.myList.getSelectedObject() != dialog.myBlockLoader.getLocalRevision());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VcsSelectionHistoryDialog dialog = (VcsSelectionHistoryDialog)((Object)e.getRequiredData(SELECTION_HISTORY_DIALOG_KEY));
            VcsFileRevision revision = (VcsFileRevision)dialog.myList.getSelectedObject();
            if (revision == null) {
                return;
            }
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)dialog.myFile);
            dialog.getDiffHandler().showDiffForTwo(dialog.myProject, filePath, revision, dialog.myBlockLoader.getLocalRevision());
        }
    }

    public static class MyDiffAction
    implements AnActionExtensionProvider {
        public boolean isActive(@NotNull AnActionEvent e) {
            return e.getData(SELECTION_HISTORY_DIALOG_KEY) != null;
        }

        public void update(@NotNull AnActionEvent e) {
            VcsSelectionHistoryDialog dialog = (VcsSelectionHistoryDialog)((Object)e.getRequiredData(SELECTION_HISTORY_DIALOG_KEY));
            e.getPresentation().setText(VcsBundle.message((String)"action.name.compare", (Object[])new Object[0]));
            e.getPresentation().setDescription(VcsBundle.message((String)"action.description.compare", (Object[])new Object[0]));
            e.getPresentation().setEnabled(dialog.myList.getSelectedRowCount() > 1 || dialog.myList.getSelectedRowCount() == 1 && dialog.myList.getSelectedObject() != dialog.myBlockLoader.getLocalRevision());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VcsSelectionHistoryDialog dialog = (VcsSelectionHistoryDialog)((Object)e.getRequiredData(SELECTION_HISTORY_DIALOG_KEY));
            BlockData blockData = dialog.myBlockLoader.getLoadedData();
            if (blockData.getRevisions().isEmpty()) {
                return;
            }
            IntPair range = dialog.getSelectedRevisionsRange(blockData);
            List revisions = blockData.getRevisions();
            VcsFileRevision beforeRevision = range.second < revisions.size() ? (VcsFileRevision)revisions.get(range.second) : VcsFileRevision.NULL;
            VcsFileRevision afterRevision = (VcsFileRevision)revisions.get(range.first);
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)dialog.myFile);
            if (range.second - range.first > 1) {
                dialog.getDiffHandler().showDiffForTwo(dialog.myProject, filePath, beforeRevision, afterRevision);
            } else {
                dialog.getDiffHandler().showDiffForOne(e, dialog.myProject, filePath, beforeRevision, afterRevision);
            }
        }
    }

    private static class BlockData {
        private final boolean myIsLoading;
        private final VcsHistorySession mySession;
        @NotNull
        private final List<VcsFileRevision> myRevisions;
        @NotNull
        private final List<? extends Block> myBlocks;
        @Nullable
        private final VcsException myException;
        @Nullable
        private final VcsFileRevision myCurrentLoadingRevision;

        BlockData(boolean isLoading, @Nullable VcsHistorySession session, @NotNull List<VcsFileRevision> revisions, @NotNull List<? extends Block> blocks, @Nullable VcsException exception, @Nullable VcsFileRevision currentLoadingRevision) {
            this.myIsLoading = isLoading;
            this.mySession = session;
            this.myRevisions = revisions;
            this.myBlocks = blocks;
            this.myException = exception;
            this.myCurrentLoadingRevision = currentLoadingRevision;
        }

        public boolean isLoading() {
            return this.myIsLoading;
        }

        @Nullable
        public VcsException getException() {
            return this.myException;
        }

        @Nullable
        public VcsFileRevision getCurrentLoadingRevision() {
            return this.myCurrentLoadingRevision;
        }

        @Nullable
        public Block getBlock(int index) {
            if (this.myBlocks.size() <= index) {
                return null;
            }
            return this.myBlocks.get(index);
        }

        @Nullable
        private VcsHistorySession getSession() {
            return this.mySession;
        }

        @NotNull
        private List<VcsFileRevision> getRevisions() {
            return this.myRevisions;
        }
    }

    private static abstract class BlockLoader {
        @NotNull
        private final Object LOCK = new Object();
        private final AbstractVcs myVcs;
        private final VirtualFile myFile;
        private final VcsFileRevision myLocalRevision;
        private VcsHistorySession mySession;
        private final List<VcsFileRevision> myRevisions = new ArrayList<VcsFileRevision>();
        private final List<Block> myBlocks = new ArrayList<Block>();
        @Nullable
        private VcsException myException;
        private boolean myIsLoading = true;
        private VcsFileRevision myCurrentLoadingRevision;

        BlockLoader(@NotNull AbstractVcs vcs, @NotNull VirtualFile file, @NotNull Document document, int selectionStart, int selectionEnd) {
            this.myVcs = vcs;
            this.myFile = file;
            this.myLocalRevision = new CurrentRevision(file, LOCAL_REVISION_NUMBER);
            String[] lastContent = Block.tokenize(document.getText());
            this.myBlocks.add(new Block(lastContent, selectionStart, selectionEnd + 1));
        }

        public VcsFileRevision getLocalRevision() {
            return this.myLocalRevision;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public BlockData getLoadedData() {
            Object object = this.LOCK;
            synchronized (object) {
                return new BlockData(this.myIsLoading, this.mySession, new ArrayList<VcsFileRevision>(this.myRevisions), new ArrayList<Block>(this.myBlocks), this.myException, this.myCurrentLoadingRevision);
            }
        }

        public void start(@NotNull Disposable disposable) {
            this.notifyUpdate(true);
            BackgroundTaskUtil.executeOnPooledThread((Disposable)disposable, () -> {
                try {
                    Object session = VcsCachingHistory.collectSession(this.myVcs, VcsUtil.getFilePath((VirtualFile)this.myFile), null);
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.mySession = session;
                        this.myRevisions.add(this.myLocalRevision);
                        this.myRevisions.addAll(session.getRevisionList());
                    }
                    this.notifyUpdate(true);
                    for (int index = 1; index < this.myRevisions.size(); ++index) {
                        ProgressManager.checkCanceled();
                        Block block = this.myBlocks.get(index - 1);
                        VcsFileRevision revision = this.myRevisions.get(index);
                        Object object2 = this.LOCK;
                        synchronized (object2) {
                            this.myCurrentLoadingRevision = revision;
                        }
                        this.notifyUpdate(false);
                        Block previousBlock = this.createBlock(block, revision);
                        Object object3 = this.LOCK;
                        synchronized (object3) {
                            this.myBlocks.add(previousBlock);
                        }
                        this.notifyUpdate(false);
                    }
                }
                catch (VcsException e) {
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.myException = e;
                    }
                    this.notifyError(e);
                }
                finally {
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.myIsLoading = false;
                        this.myCurrentLoadingRevision = null;
                    }
                    this.notifyUpdate(true);
                }
            });
        }

        protected abstract void notifyError(@NotNull VcsException var1);

        protected abstract void notifyUpdate(boolean var1);

        @NotNull
        private Block createBlock(@NotNull Block block, @NotNull VcsFileRevision revision) throws VcsException {
            if (block == EMPTY_BLOCK) {
                return EMPTY_BLOCK;
            }
            String revisionContent = this.loadContents(revision);
            Block newBlock = block.createPreviousBlock(revisionContent);
            return newBlock.getStart() != newBlock.getEnd() ? newBlock : EMPTY_BLOCK;
        }

        @NotNull
        private String loadContents(@NotNull VcsFileRevision revision) throws VcsException {
            try {
                byte[] bytes = revision.loadContent();
                if (bytes == null) {
                    throw new VcsException("Failed to load content for revision " + revision.getRevisionNumber().asString());
                }
                return new String(bytes, this.myFile.getCharset());
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }
    }
}

