/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkout.CompositeCheckoutListener;
import com.intellij.openapi.vcs.checkout.VcsAwareCheckoutListener;
import java.nio.file.Path;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class RegisterMappingCheckoutListener
implements VcsAwareCheckoutListener {
    RegisterMappingCheckoutListener() {
    }

    public boolean processCheckedOutDirectory(Project currentProject, @NotNull Path directory, VcsKey vcsKey) {
        Project project = CompositeCheckoutListener.findProjectByBaseDirLocation(directory);
        if (project == null) {
            return false;
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        if (!vcsManager2.hasAnyMappings()) {
            vcsManager2.setDirectoryMappings(Collections.singletonList(VcsDirectoryMapping.createDefault((String)vcsKey.getName())));
        }
        return true;
    }
}

