/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.StepIntersection;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.LightIndexPatternSearch;
import com.intellij.psi.impl.search.TodoItemsCreator;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoCheckinHandlerWorker {
    private static final Logger LOG = Logger.getInstance(TodoCheckinHandler.class);
    private final Project myProject;
    private final Collection<? extends Change> myChanges;
    private final TodoFilter myTodoFilter;
    private final Set<TodoItem> myAddedOrEditedTodos = new HashSet<TodoItem>();
    private final Set<TodoItem> myInChangedTodos = new HashSet<TodoItem>();
    private final List<Pair<FilePath, String>> mySkipped = new SmartList();
    private static final String ourInvalidFile = "Invalid file (s)";
    private static final String ourCannotLoadPreviousRevision = "Can not load previous revision";
    private static final String ourCannotLoadCurrentRevision = "Can not load current revision";
    private static final Convertor<TodoItem, TextRange> TODO_ITEM_CONVERTOR = o -> {
        TextRange textRange = o.getTextRange();
        List additionalRanges = o.getAdditionalTextRanges();
        return new TextRange(textRange.getStartOffset(), (additionalRanges.isEmpty() ? textRange : (TextRange)additionalRanges.get(additionalRanges.size() - 1)).getEndOffset() - 1);
    };

    public TodoCheckinHandlerWorker(@NotNull Project project, @NotNull Collection<? extends Change> changes, @Nullable TodoFilter todoFilter) {
        this.myProject = project;
        this.myChanges = changes;
        this.myTodoFilter = todoFilter;
    }

    public void execute() {
        for (Change change : this.myChanges) {
            ProgressManager.checkCanceled();
            if (change.getAfterRevision() == null) continue;
            FilePath afterFilePath = change.getAfterRevision().getFile();
            VirtualFile afterFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(afterFilePath.getPath());
            MyEditedFileProcessor fileProcessor = (MyEditedFileProcessor)ReadAction.compute(() -> {
                PsiFile afterPsiFile;
                if (afterFile == null || afterFile.isDirectory() || afterFile.getFileType().isBinary()) {
                    return null;
                }
                PsiFile psiFile = afterPsiFile = afterFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(afterFile) : null;
                if (afterPsiFile == null) {
                    this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)ourInvalidFile));
                    return null;
                }
                PsiTodoSearchHelper searchHelper = PsiTodoSearchHelper.SERVICE.getInstance((Project)this.myProject);
                ArrayList newTodoItems = ContainerUtil.newArrayList((Object[])searchHelper.findTodoItems(afterPsiFile));
                TodoCheckinHandlerWorker.applyFilterAndRemoveDuplicatesAndSort(newTodoItems, this.myTodoFilter);
                if (change.getBeforeRevision() == null) {
                    this.myAddedOrEditedTodos.addAll(newTodoItems);
                    return null;
                }
                String rawBeforeContent = TodoCheckinHandlerWorker.getRevisionContent(change.getBeforeRevision());
                if (rawBeforeContent == null) {
                    this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)ourCannotLoadPreviousRevision));
                    return null;
                }
                Document afterDocument = FileDocumentManager.getInstance().getDocument(afterFile);
                if (afterDocument == null) {
                    this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)ourCannotLoadCurrentRevision));
                    return null;
                }
                String beforeContent = StringUtil.convertLineSeparators((String)rawBeforeContent);
                String afterContent = afterDocument.getText();
                return new MyEditedFileProcessor(this.myProject, afterFilePath, beforeContent, afterContent, newTodoItems, this.myTodoFilter);
            });
            try {
                if (fileProcessor == null) continue;
                fileProcessor.process();
            }
            catch (DiffTooBigException e) {
                LOG.info("File " + afterFilePath.getPath() + " is too big and there are too many changes to build a diff");
                this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)ourCannotLoadPreviousRevision));
            }
        }
    }

    private static void applyFilterAndRemoveDuplicatesAndSort(List<TodoItem> todoItems, TodoFilter filter) {
        todoItems.sort(TodoItem.BY_START_OFFSET);
        TodoItem previous = null;
        Iterator<TodoItem> iterator = todoItems.iterator();
        while (iterator.hasNext()) {
            TodoItem next = iterator.next();
            if (filter != null && !filter.contains(next.getPattern())) {
                iterator.remove();
                continue;
            }
            if (previous != null && next.getTextRange().equals((Object)previous.getTextRange())) {
                iterator.remove();
                continue;
            }
            previous = next;
        }
    }

    public Set<TodoItem> getAddedOrEditedTodos() {
        return this.myAddedOrEditedTodos;
    }

    public Set<TodoItem> getInChangedTodos() {
        return this.myInChangedTodos;
    }

    public List<Pair<FilePath, String>> getSkipped() {
        return this.mySkipped;
    }

    private static String getTodoText(TodoItem item, String content2) {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add(TodoCheckinHandlerWorker.getTodoPartText(content2, item.getTextRange()));
        item.getAdditionalTextRanges().forEach(r -> joiner.add(TodoCheckinHandlerWorker.getTodoPartText(content2, r)));
        return joiner.toString();
    }

    private static String getTodoPartText(String content2, TextRange textRange) {
        String fragment = textRange.substring(content2);
        return StringUtil.join((String[])fragment.split("\\s"), (String)" ");
    }

    private static List<LineFragment> getLineFragments(@NotNull String beforeContent, @NotNull String afterContent) throws DiffTooBigException {
        ProgressIndicator indicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)DumbProgressIndicator.INSTANCE);
        return ComparisonManager.getInstance().compareLines((CharSequence)beforeContent, (CharSequence)afterContent, ComparisonPolicy.DEFAULT, indicator);
    }

    @Nullable
    private static String getRevisionContent(@NotNull ContentRevision revision) {
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public Set<TodoItem> inOneList() {
        HashSet<TodoItem> set = new HashSet<TodoItem>();
        set.addAll(this.getAddedOrEditedTodos());
        set.addAll(this.getInChangedTodos());
        return set;
    }

    private static class RightLineFragmentConvertor
    implements Convertor<LineFragment, TextRange> {
        private final String myContent;

        private RightLineFragmentConvertor(String content2) {
            this.myContent = content2;
        }

        public TextRange convert(LineFragment o) {
            int start2 = o.getStartOffset2();
            int end = o.getEndOffset2();
            int prevLineStart = this.myContent.lastIndexOf(10, start2 - 2) + 1;
            return new TextRange(prevLineStart, Math.max(start2, end - 1));
        }
    }

    private static class LeftLineFragmentConvertor
    implements Convertor<LineFragment, TextRange> {
        private final String myContent;

        private LeftLineFragmentConvertor(String content2) {
            this.myContent = content2;
        }

        public TextRange convert(LineFragment o) {
            int start2 = o.getStartOffset1();
            int end = o.getEndOffset1();
            int prevLineStart = this.myContent.lastIndexOf(10, start2 - 2) + 1;
            return new TextRange(prevLineStart, Math.max(start2, end - 1));
        }
    }

    private class MyEditedFileProcessor {
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myBeforeContent;
        @NotNull
        private final String myAfterContent;
        @NotNull
        private final FilePath myAfterFile;
        @NotNull
        private final List<? extends TodoItem> myNewTodoItems;
        private final TodoFilter myTodoFilter;

        private MyEditedFileProcessor(@NotNull Project project, @NotNull FilePath afterFilePath, @NotNull String beforeContent, @NotNull String afterContent, @Nullable List<? extends TodoItem> newTodoItems, TodoFilter todoFilter) {
            this.myProject = project;
            this.myAfterFile = afterFilePath;
            this.myBeforeContent = beforeContent;
            this.myAfterContent = afterContent;
            this.myNewTodoItems = newTodoItems;
            this.myTodoFilter = todoFilter;
        }

        public void process() throws DiffTooBigException {
            List lineFragments = TodoCheckinHandlerWorker.getLineFragments(this.myBeforeContent, this.myAfterContent);
            ArrayList changedTodoItems = new ArrayList();
            StepIntersection.processIntersections(this.myNewTodoItems, lineFragments, TODO_ITEM_CONVERTOR, new RightLineFragmentConvertor(this.myAfterContent), (todoItem, lineFragment) -> changedTodoItems.add(Pair.create((Object)todoItem, (Object)lineFragment)));
            if (changedTodoItems.isEmpty()) {
                return;
            }
            PsiFile beforePsiFile = (PsiFile)ReadAction.compute(() -> PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("old" + this.myAfterFile.getName(), this.myAfterFile.getFileType(), (CharSequence)this.myBeforeContent));
            IndexPatternSearch.SearchParameters searchParameters = new IndexPatternSearch.SearchParameters(beforePsiFile, (IndexPatternProvider)TodoIndexPatternProvider.getInstance(), TodoConfiguration.getInstance().isMultiLine());
            Collection patternOccurrences = LightIndexPatternSearch.SEARCH.createQuery((Object)searchParameters).findAll();
            if (patternOccurrences.isEmpty()) {
                for (Pair pair : changedTodoItems) {
                    TodoCheckinHandlerWorker.this.myAddedOrEditedTodos.add(pair.first);
                }
                return;
            }
            ArrayList<TodoItem> oldTodoItems = new ArrayList<TodoItem>();
            TodoItemsCreator todoItemsCreator = new TodoItemsCreator();
            for (IndexPatternOccurrence occurrence : patternOccurrences) {
                oldTodoItems.add(todoItemsCreator.createTodo(occurrence));
            }
            TodoCheckinHandlerWorker.applyFilterAndRemoveDuplicatesAndSort(oldTodoItems, this.myTodoFilter);
            LineFragment lastLineFragment = null;
            HashSet oldTodoTexts = new HashSet();
            for (Pair pair : changedTodoItems) {
                String text2;
                TodoItem todoItem2 = (TodoItem)pair.first;
                LineFragment lineFragment2 = (LineFragment)pair.second;
                if (lineFragment2 != lastLineFragment) {
                    oldTodoTexts.clear();
                    StepIntersection.processElementIntersections(lineFragment2, oldTodoItems, new LeftLineFragmentConvertor(this.myBeforeContent), TODO_ITEM_CONVERTOR, (fragment, oldTodoItem) -> oldTodoTexts.add(TodoCheckinHandlerWorker.getTodoText(oldTodoItem, this.myBeforeContent)));
                    lastLineFragment = lineFragment2;
                }
                if (!oldTodoTexts.contains(text2 = TodoCheckinHandlerWorker.getTodoText(todoItem2, this.myAfterContent))) {
                    TodoCheckinHandlerWorker.this.myAddedOrEditedTodos.add(todoItem2);
                    continue;
                }
                if (((TextRange)TODO_ITEM_CONVERTOR.convert((Object)todoItem2)).getEndOffset() < lineFragment2.getStartOffset2()) continue;
                TodoCheckinHandlerWorker.this.myInChangedTodos.add(todoItem2);
            }
            TodoCheckinHandlerWorker.this.myInChangedTodos.removeAll(TodoCheckinHandlerWorker.this.myAddedOrEditedTodos);
        }
    }
}

