/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticFilePath {
    private final String myKey;
    private final String myPath;
    private final boolean myIsDirectory;
    private final VirtualFile myVf;

    public StaticFilePath(boolean isDirectory, @NotNull String path2, @Nullable VirtualFile vf) {
        this(isDirectory, path2, FilePathsHelper.convertPath((String)path2), vf);
    }

    private StaticFilePath(boolean isDirectory, @NotNull String path2, @NotNull String key, @Nullable VirtualFile vf) {
        this.myIsDirectory = isDirectory;
        this.myPath = path2;
        this.myKey = key;
        this.myVf = vf;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @NotNull
    public String getKey() {
        return this.myKey;
    }

    @Nullable
    public VirtualFile getVf() {
        return this.myVf;
    }

    @Nullable
    public StaticFilePath getParent() {
        int idx = this.myKey.lastIndexOf(47);
        if (idx == -1 || idx == 0) {
            return null;
        }
        return new StaticFilePath(true, this.myPath.substring(0, idx), this.myKey.substring(0, idx), this.myVf == null ? null : this.myVf.getParent());
    }

    @Nullable
    public VirtualFile resolve() {
        VirtualFile result2 = this.getVf();
        if (result2 != null) {
            return result2;
        }
        return LocalFileSystem.getInstance().findFileByPath(this.getPath());
    }
}

