/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.ui.BaseInclusionModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016J\u0016\u0010\u0016\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016J\u0016\u0010\u0017\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultInclusionModel;", "Lcom/intellij/openapi/vcs/changes/ui/BaseInclusionModel;", "inclusionHashingStrategy", "Lgnu/trove/TObjectHashingStrategy;", "", "(Lgnu/trove/TObjectHashingStrategy;)V", "inclusion", "Lgnu/trove/THashSet;", "kotlin.jvm.PlatformType", "addInclusion", "", "items", "", "clearInclusion", "getInclusion", "", "getInclusionState", "Lcom/intellij/util/ui/ThreeStateCheckBox$State;", "item", "isInclusionEmpty", "", "removeInclusion", "retainInclusion", "setInclusion", "intellij.platform.vcs.impl"})
public final class DefaultInclusionModel
extends BaseInclusionModel {
    private final THashSet<Object> inclusion;
    private final TObjectHashingStrategy<Object> inclusionHashingStrategy;

    @NotNull
    public Set<Object> getInclusion() {
        return Collections.unmodifiableSet((Set)new THashSet((Collection)this.inclusion, this.inclusionHashingStrategy));
    }

    @NotNull
    public ThreeStateCheckBox.State getInclusionState(@NotNull Object item) {
        return this.inclusion.contains(item) ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED;
    }

    public boolean isInclusionEmpty() {
        return this.inclusion.isEmpty();
    }

    public void addInclusion(@NotNull Collection<? extends Object> items) {
        if (this.inclusion.addAll(items)) {
            this.fireInclusionChanged();
        }
    }

    public void removeInclusion(@NotNull Collection<? extends Object> items) {
        if (this.inclusion.removeAll(items)) {
            this.fireInclusionChanged();
        }
    }

    public void setInclusion(@NotNull Collection<? extends Object> items) {
        Set<Object> oldInclusion = this.getInclusion();
        this.inclusion.clear();
        this.inclusion.addAll(items);
        if (Intrinsics.areEqual(oldInclusion, this.inclusion) ^ true) {
            this.fireInclusionChanged();
        }
    }

    public void retainInclusion(@NotNull Collection<? extends Object> items) {
        if (this.inclusion.retainAll(items)) {
            this.fireInclusionChanged();
        }
    }

    public void clearInclusion() {
        Collection collection = (Collection)this.inclusion;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.inclusion.clear();
            this.fireInclusionChanged();
        }
    }

    public DefaultInclusionModel(@NotNull TObjectHashingStrategy<Object> inclusionHashingStrategy) {
        this.inclusionHashingStrategy = inclusionHashingStrategy;
        this.inclusion = new THashSet(this.inclusionHashingStrategy);
    }

    public /* synthetic */ DefaultInclusionModel(TObjectHashingStrategy tObjectHashingStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tObjectHashingStrategy = ContainerUtil.canonicalStrategy();
        }
        this((TObjectHashingStrategy<Object>)tObjectHashingStrategy);
    }

    public DefaultInclusionModel() {
        this(null, 1, null);
    }
}

