/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.ChangesViewCommitPanelKt;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesListView
extends ChangesTree
implements DataProvider,
DnDAware {
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<ChangesListView> DATA_KEY = DataKey.create((String)"ChangeListView");
    @NonNls
    public static final DataKey<Stream<FilePath>> UNVERSIONED_FILE_PATHS_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> EXACTLY_SELECTED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.ExactlySelectedFiles");
    @NonNls
    public static final DataKey<Stream<FilePath>> IGNORED_FILE_PATHS_DATA_KEY = DataKey.create((String)"ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create((String)"ChangeListView.LocallyDeletedChanges");

    public ChangesListView(@NotNull Project project, boolean showCheckboxes) {
        super(project, showCheckboxes, true);
        this.setDragEnabled(true);
    }

    @Override
    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        return new ChangesGroupingSupport(this.myProject, (Object)this, true);
    }

    @Override
    public int getToggleClickCount() {
        return 2;
    }

    @Override
    protected boolean isInclusionVisible(@NotNull ChangesBrowserNode<?> node) {
        Object subtreeRootObject = ChangesViewCommitPanelKt.subtreeRootObject(node);
        if (subtreeRootObject instanceof LocalChangeList) {
            return !((LocalChangeList)subtreeRootObject).getChanges().isEmpty();
        }
        return subtreeRootObject == ChangesBrowserNode.UNVERSIONED_FILES_TAG;
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public void updateModel(@NotNull DefaultTreeModel newModel) {
        TreeState state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        state.setScrollToSelection(false);
        ChangesBrowserNode<?> oldRoot = this.getRoot();
        this.setModel(newModel);
        ChangesBrowserNode<?> newRoot = this.getRoot();
        state.applyTo((JTree)((Object)this), newRoot);
        this.initTreeStateIfNeeded(oldRoot, newRoot);
    }

    @Override
    public void rebuildTree() {
    }

    private void initTreeStateIfNeeded(ChangesBrowserNode<?> oldRoot, ChangesBrowserNode<?> newRoot) {
        ChangesBrowserNode<?> defaultListNode = ChangesListView.getDefaultChangelistNode(newRoot);
        if (defaultListNode == null) {
            return;
        }
        if (this.getSelectionCount() == 0) {
            TreeUtil.selectNode((JTree)((Object)this), defaultListNode);
        }
        if (oldRoot.getFileCount() == 0 && TreeUtil.collectExpandedPaths((JTree)((Object)this)).size() == 0) {
            this.expandSafe(defaultListNode);
        }
    }

    @Nullable
    private static ChangesBrowserNode<?> getDefaultChangelistNode(@NotNull ChangesBrowserNode<?> root) {
        Enumeration<TreeNode> children = root.children();
        Iterator nodes = ContainerUtil.iterate(children);
        return (ChangesBrowserNode)ContainerUtil.find((Iterator)nodes, node -> {
            if (node instanceof ChangesBrowserChangeListNode) {
                ChangeList list = (ChangeList)((ChangesBrowserChangeListNode)node).getUserObject();
                return list instanceof LocalChangeList && ((LocalChangeList)list).isDefault();
            }
            return false;
        });
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getSelectedChanges().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return this.getLeadSelection().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return this.getSelectedChangeLists().toArray(ChangeList[]::new);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getSelectedFiles().toArray(VirtualFile[]::new);
        }
        if (VcsDataKeys.VIRTUAL_FILE_STREAM.is(dataId)) {
            return this.getSelectedFiles();
        }
        if (VcsDataKeys.FILE_PATH_STREAM.is(dataId)) {
            return this.getSelectedFilePaths();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile file = (VirtualFile)UtilKt.getIfSingle(this.getNavigatableFiles());
            return file != null && !file.isDirectory() ? PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file, 0) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return ChangesUtil.getNavigatableArray((Project)this.myProject, this.getNavigatableFiles());
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.getSelectionObjectsStream().anyMatch(userObject -> !(userObject instanceof ChangeList)) ? new VirtualFileDeleteProvider() : null;
        }
        if (UNVERSIONED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return this.getSelectedUnversionedFiles();
        }
        if (EXACTLY_SELECTED_FILES_DATA_KEY.is(dataId)) {
            return ChangesListView.getExactlySelectedVirtualFiles((JTree)((Object)this));
        }
        if (IGNORED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return this.getSelectedIgnoredFiles();
        }
        if (VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().collect(Collectors.toList());
        }
        if (LOCALLY_DELETED_CHANGES.is(dataId)) {
            return this.getSelectedLocallyDeletedChanges().collect(Collectors.toList());
        }
        if (MISSING_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedMissingFiles().collect(Collectors.toList());
        }
        if (VcsDataKeys.HAVE_LOCALLY_DELETED.is(dataId)) {
            return this.getSelectedMissingFiles().findAny().isPresent();
        }
        if (VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().findAny().isPresent();
        }
        if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
            return !UtilKt.isEmpty(this.getSelectedChanges());
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @NotNull
    public Stream<FilePath> getUnversionedFiles() {
        Enumeration<TreeNode> nodes = this.getRoot().children();
        ChangesBrowserUnversionedFilesNode node = (ChangesBrowserUnversionedFilesNode)ContainerUtil.findInstance((Iterator)ContainerUtil.iterate(nodes), ChangesBrowserUnversionedFilesNode.class);
        if (node == null) {
            return Stream.empty();
        }
        return node.getFilePathsUnderStream();
    }

    @NotNull
    static Stream<FilePath> getSelectedUnversionedFiles(@NotNull JTree tree) {
        return ChangesListView.getSelectedFilePaths(tree, ChangesBrowserNode.UNVERSIONED_FILES_TAG);
    }

    @NotNull
    public Stream<FilePath> getSelectedUnversionedFiles() {
        return ChangesListView.getSelectedUnversionedFiles((JTree)((Object)this));
    }

    @NotNull
    private Stream<FilePath> getSelectedIgnoredFiles() {
        return this.getSelectedFilePaths(ChangesBrowserNode.IGNORED_FILES_TAG);
    }

    @NotNull
    private Stream<VirtualFile> getSelectedModifiedWithoutEditing() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
    }

    @NotNull
    protected Stream<VirtualFile> getSelectedVirtualFiles(@Nullable Object tag) {
        return ChangesListView.getSelectionNodesStream((JTree)((Object)this), tag).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
    }

    @NotNull
    protected Stream<FilePath> getSelectedFilePaths(@Nullable Object tag) {
        return ChangesListView.getSelectedFilePaths((JTree)((Object)this), tag);
    }

    @NotNull
    private static Stream<FilePath> getSelectedFilePaths(@NotNull JTree tree, @Nullable Object tag) {
        return ChangesListView.getSelectionNodesStream(tree, tag).flatMap(ChangesBrowserNode::getFilePathsUnderStream).distinct();
    }

    @NotNull
    static Stream<VirtualFile> getExactlySelectedVirtualFiles(@NotNull JTree tree) {
        VcsTreeModelData exactlySelected = VcsTreeModelData.exactlySelected(tree);
        return exactlySelected.rawUserObjectsStream().map(object -> {
            if (object instanceof VirtualFile) {
                return (VirtualFile)object;
            }
            if (object instanceof FilePath) {
                return ((FilePath)object).getVirtualFile();
            }
            return null;
        }).filter(Objects::nonNull);
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream() {
        return ChangesListView.getSelectionNodesStream((JTree)((Object)this), null);
    }

    @NotNull
    private static Stream<ChangesBrowserNode<?>> getSelectionNodesStream(@NotNull JTree tree, @Nullable Object tag) {
        return UtilKt.stream((Object[])tree.getSelectionPaths()).filter(path2 -> ChangesListView.isUnderTag(path2, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node);
    }

    @NotNull
    private Stream<Object> getSelectionObjectsStream() {
        return this.getSelectionNodesStream().map(ChangesBrowserNode::getUserObject);
    }

    @NotNull
    static Stream<VirtualFile> getVirtualFiles(TreePath @Nullable [] paths, @Nullable Object tag) {
        return UtilKt.stream((Object[])paths).filter(path2 -> ChangesListView.isUnderTag(path2, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
    }

    @NotNull
    static Stream<FilePath> getFilePaths(TreePath @Nullable [] paths, @Nullable Object tag) {
        return UtilKt.stream((Object[])paths).filter(path2 -> ChangesListView.isUnderTag(path2, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilePathsUnderStream).distinct();
    }

    static boolean isUnderTag(@NotNull TreePath path2, @Nullable Object tag) {
        boolean result2 = true;
        if (tag != null) {
            result2 = path2.getPathCount() > 1 && ((ChangesBrowserNode)path2.getPathComponent(1)).getUserObject() == tag;
        }
        return result2;
    }

    @NotNull
    static Stream<Change> getChanges(@NotNull Project project, TreePath @Nullable [] paths) {
        Stream<Change> changes = UtilKt.stream((Object[])paths).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(node -> node.getObjectsUnderStream(Change.class)).map(Change.class::cast);
        Stream<Change> hijackedChanges = ChangesListView.getVirtualFiles(paths, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).map(file -> ChangesListView.toHijackedChange(project, file)).filter(Objects::nonNull);
        return Stream.concat(changes, hijackedChanges).filter(new DistinctChangePredicate());
    }

    @Nullable
    private static Change toHijackedChange(@NotNull Project project, @NotNull VirtualFile file) {
        VcsCurrentRevisionProxy before = VcsCurrentRevisionProxy.create(file, project);
        if (before != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file));
            return new Change((ContentRevision)before, (ContentRevision)afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private Stream<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        return ChangesListView.getSelectionNodesStream((JTree)((Object)this), ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).flatMap(node -> node.getObjectsUnderStream(LocallyDeletedChange.class)).distinct();
    }

    @NotNull
    private Stream<FilePath> getSelectedMissingFiles() {
        return this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath);
    }

    @NotNull
    private Stream<FilePath> getSelectedFilePaths() {
        return UtilKt.concat((Stream[])new Stream[]{this.getSelectedChanges().map(ChangesUtil::getFilePath), this.getSelectedVirtualFiles(null).map(VcsUtil::getFilePath), this.getSelectedFilePaths(null)}).distinct();
    }

    @NotNull
    private Stream<VirtualFile> getSelectedFiles() {
        return UtilKt.concat((Stream[])new Stream[]{ChangesUtil.getAfterRevisionsFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null), ChangesUtil.getFilesFromPaths(this.getSelectedFilePaths(null))}).distinct();
    }

    @NotNull
    private Stream<VirtualFile> getNavigatableFiles() {
        return UtilKt.concat((Stream[])new Stream[]{ChangesUtil.getFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null), ChangesUtil.getFilesFromPaths(this.getSelectedFilePaths(null))}).distinct();
    }

    @NotNull
    private Stream<Change> getLeadSelection() {
        return this.getSelectionNodesStream().filter(node -> node instanceof ChangesBrowserChangeNode).map(ChangesBrowserChangeNode.class::cast).map(ChangesBrowserNode::getUserObject).filter(new DistinctChangePredicate());
    }

    @NotNull
    public Stream<Change> getChanges() {
        return this.getRoot().getObjectsUnderStream(Change.class);
    }

    @Nullable
    public List<Change> getAllChangesFromSameChangelist(@NotNull Change change) {
        for (DefaultMutableTreeNode node = this.findNodeInTree(change); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
            if (node instanceof ChangesBrowserChangeListNode) {
                return ((ChangesBrowserChangeListNode)node).getAllChangesUnder();
            }
            if (node != this.getRoot() || !Registry.is((String)"vcs.skip.single.default.changelist")) continue;
            return this.getRoot().getAllChangesUnder();
        }
        return null;
    }

    @NotNull
    public Stream<Change> getSelectedChanges() {
        return ChangesListView.getChanges(this.myProject, this.getSelectionPaths());
    }

    @NotNull
    private Stream<ChangeList> getSelectedChangeLists() {
        return this.getSelectionObjectsStream().filter(userObject -> userObject instanceof ChangeList).map(ChangeList.class::cast).distinct();
    }

    @Override
    public void installPopupHandler(@NotNull ActionGroup group) {
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)group, (String)"ChangesViewPopup", (ActionManager)ActionManager.getInstance());
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    public void processMouseEvent(MouseEvent e) {
        if (!(502 != e.getID() || this.isSelectionEmpty() || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isPopupTrigger() || !this.isOverSelection(e.getPoint()))) {
            this.clearSelection();
            TreePath path2 = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (path2 != null) {
                this.setSelectionPath(path2);
            }
        }
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @Nullable
    public DefaultMutableTreeNode findNodeInTree(Object userObject) {
        if (userObject instanceof LocalChangeList) {
            return (DefaultMutableTreeNode)TreeUtil.nodeChildren(this.getRoot()).filter(DefaultMutableTreeNode.class).find(node -> userObject.equals(node.getUserObject()));
        }
        if (userObject instanceof ChangeListChange) {
            return TreeUtil.findNode(this.getRoot(), node -> ChangeListChange.HASHING_STRATEGY.equals(node.getUserObject(), userObject));
        }
        return TreeUtil.findNodeWithObject(this.getRoot(), (Object)userObject);
    }

    @Nullable
    public TreePath findNodePathInTree(Object userObject) {
        DefaultMutableTreeNode node = this.findNodeInTree(userObject);
        return node != null ? TreeUtil.getPathFromRoot((TreeNode)node) : null;
    }

    public void expandSafe(@NotNull DefaultMutableTreeNode node) {
        if (node.getChildCount() <= 10000) {
            this.expandPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    private static class DistinctChangePredicate
    implements Predicate<Change> {
        private final Set<Object> seen = new THashSet(ChangeListChange.HASHING_STRATEGY);

        private DistinctChangePredicate() {
        }

        @Override
        public boolean test(Change change) {
            return this.seen.add(change);
        }
    }
}

