/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchDiffRequest;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchMergeRequest;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchDiffRequestFactory {
    @NotNull
    public static DiffRequest createDiffRequest(@Nullable Project project, @NotNull Change change, @NotNull String name, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
        ChangeDiffRequestProducer proxyProducer = ChangeDiffRequestProducer.create(project, change);
        if (proxyProducer == null) {
            throw new DiffRequestProducerException("Can't show diff for '" + name + "'");
        }
        return proxyProducer.process(context, indicator);
    }

    @NotNull
    public static DiffRequest createConflictDiffRequest(@Nullable Project project, @Nullable VirtualFile file, @NotNull TextFilePatch patch, @NotNull String afterTitle, @NotNull ApplyPatchForBaseRevisionTexts texts, @NotNull String name) throws DiffRequestProducerException {
        if (file == null) {
            throw new DiffRequestProducerException("Can't show diff for '" + name + "'");
        }
        if (file.getFileType().isBinary()) {
            throw new DiffRequestProducerException("Can't show diff for binary file '" + name + "'");
        }
        if (texts.getBase() == null) {
            String localContent = texts.getLocal();
            GenericPatchApplier applier = new GenericPatchApplier(localContent, patch.getHunks());
            applier.execute();
            AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
            return PatchDiffRequestFactory.createBadDiffRequest(project, file, localContent, appliedTextPatch, null, null, DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]), null);
        }
        String localContent = texts.getLocal();
        String baseContent = texts.getBase();
        String patchedContent = texts.getPatched();
        return PatchDiffRequestFactory.createDiffRequest(project, file, Arrays.asList(localContent, baseContent, patchedContent), null, Arrays.asList(DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]), DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]), afterTitle));
    }

    @NotNull
    public static DiffRequest createDiffRequest(@Nullable Project project, @Nullable VirtualFile file, @NotNull List<String> contents, @Nullable String windowTitle, @NotNull List<String> titles) {
        DocumentContent localContent;
        assert (contents.size() == 3);
        assert (titles.size() == 3);
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getPatchTitle(file);
        }
        String localTitle = StringUtil.notNullize((String)titles.get(0), (String)VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]));
        String baseTitle = StringUtil.notNullize((String)titles.get(1), (String)DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]));
        String patchedTitle = StringUtil.notNullize((String)titles.get(2), (String)VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]));
        FileType fileType = file != null ? file.getFileType() : null;
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DocumentContent documentContent = localContent = file != null ? contentFactory.createDocument(project, file) : null;
        if (localContent == null) {
            localContent = contentFactory.create(project, contents.get(0), fileType);
        }
        DocumentContent baseContent = contentFactory.create(project, contents.get(1), fileType);
        DocumentContent patchedContent = contentFactory.create(project, contents.get(2), fileType);
        return new SimpleDiffRequest(windowTitle, (DiffContent)localContent, (DiffContent)baseContent, (DiffContent)patchedContent, localTitle, baseTitle, patchedTitle);
    }

    @NotNull
    public static DiffRequest createBadDiffRequest(@Nullable Project project, @NotNull VirtualFile file, @NotNull String localContent, @NotNull AppliedTextPatch textPatch, @Nullable String windowTitle, @Nullable String localTitle, @Nullable String resultTitle, @Nullable String patchTitle) {
        DocumentContent resultContent;
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getBadPatchTitle(file);
        }
        if (localTitle == null) {
            localTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
        }
        if (resultTitle == null) {
            resultTitle = VcsBundle.message((String)"patch.apply.conflict.patched.somehow.version", (Object[])new Object[0]);
        }
        if (patchTitle == null) {
            patchTitle = VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]);
        }
        if ((resultContent = DiffContentFactory.getInstance().createDocument(project, file)) == null) {
            resultContent = DiffContentFactory.getInstance().create(project, localContent, file);
        }
        return new ApplyPatchDiffRequest(resultContent, textPatch, localContent, windowTitle, localTitle, resultTitle, patchTitle);
    }

    @NotNull
    public static MergeRequest createMergeRequest(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file, @NotNull String baseContent, @NotNull String localContent, @NotNull String patchedContent, @Nullable Consumer<? super MergeResult> callback2) throws InvalidDiffRequestException {
        List<String> titles = Arrays.asList(null, null, null);
        List<String> contents = Arrays.asList(localContent, baseContent, patchedContent);
        return PatchDiffRequestFactory.createMergeRequest(project, document, file, contents, null, titles, callback2);
    }

    @NotNull
    public static MergeRequest createBadMergeRequest(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file, @NotNull String localContent, @NotNull AppliedTextPatch textPatch, @Nullable Consumer<? super MergeResult> callback2) throws InvalidDiffRequestException {
        return PatchDiffRequestFactory.createBadMergeRequest(project, document, file, localContent, textPatch, null, null, null, null, callback2);
    }

    @NotNull
    public static MergeRequest createMergeRequest(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile file, @NotNull List<String> contents, @Nullable String windowTitle, @NotNull List<String> titles, @Nullable Consumer<? super MergeResult> callback2) throws InvalidDiffRequestException {
        assert (contents.size() == 3);
        assert (titles.size() == 3);
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getPatchTitle(file);
        }
        String localTitle = StringUtil.notNullize((String)titles.get(0), (String)VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]));
        String baseTitle = StringUtil.notNullize((String)titles.get(1), (String)VcsBundle.message((String)"patch.apply.conflict.merged.version", (Object[])new Object[0]));
        String patchedTitle = StringUtil.notNullize((String)titles.get(2), (String)VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]));
        List<String> actualTitles = Arrays.asList(localTitle, baseTitle, patchedTitle);
        FileType fileType = file != null ? file.getFileType() : null;
        return DiffRequestFactory.getInstance().createMergeRequest(project, fileType, document, contents, windowTitle, actualTitles, callback2);
    }

    @NotNull
    public static MergeRequest createBadMergeRequest(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile file, @NotNull String localContent, @NotNull AppliedTextPatch textPatch, @Nullable String windowTitle, @Nullable String localTitle, @Nullable String resultTitle, @Nullable String patchTitle, @Nullable Consumer<? super MergeResult> callback2) throws InvalidDiffRequestException {
        if (!DiffUtil.canMakeWritable((Document)document)) {
            throw new InvalidDiffRequestException("Output is read only" + (file != null ? " : '" + file.getPresentableUrl() + "'" : ""));
        }
        if (windowTitle == null) {
            windowTitle = PatchDiffRequestFactory.getBadPatchTitle(file);
        }
        if (localTitle == null) {
            localTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
        }
        if (resultTitle == null) {
            resultTitle = VcsBundle.message((String)"patch.apply.conflict.patched.somehow.version", (Object[])new Object[0]);
        }
        if (patchTitle == null) {
            patchTitle = VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]);
        }
        DocumentContent resultContent = DiffContentFactory.getInstance().create(project, document, file);
        ApplyPatchMergeRequest request = new ApplyPatchMergeRequest(project, resultContent, textPatch, localContent, windowTitle, localTitle, resultTitle, patchTitle);
        return MergeCallback.register((MergeRequest)request, callback2);
    }

    @NotNull
    private static String getPatchTitle(@Nullable VirtualFile file) {
        if (file != null) {
            return VcsBundle.message((String)"patch.apply.conflict.for.title", (Object[])new Object[]{PatchDiffRequestFactory.getPresentablePath(file)});
        }
        return VcsBundle.message((String)"patch.apply.conflict.title", (Object[])new Object[0]);
    }

    @NotNull
    private static String getBadPatchTitle(@Nullable VirtualFile file) {
        if (file != null) {
            return VcsBundle.message((String)"patch.apply.bad.diff.to.title", (Object[])new Object[]{PatchDiffRequestFactory.getPresentablePath(file)});
        }
        return VcsBundle.message((String)"patch.apply.bad.diff.title", (Object[])new Object[0]);
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile file) {
        String fullPath = file.getParent() == null ? file.getPath() : file.getParent().getPath();
        return file.getName() + " (" + fullPath + ")";
    }
}

