/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.DefaultPatchBaseVersionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchForBaseRevisionTexts {
    private static final Logger LOG = Logger.getInstance(ApplyPatchForBaseRevisionTexts.class);
    @NotNull
    private final String myLocal;
    @Nullable
    private final String myBase;
    @NotNull
    private final String myPatched;
    private final boolean myIsAppliedSomehow;

    public ApplyPatchForBaseRevisionTexts(@NotNull String patched, @NotNull String local, @Nullable String base, boolean isAppliedSomehow) {
        this.myLocal = local;
        this.myBase = base;
        this.myPatched = patched;
        this.myIsAppliedSomehow = isAppliedSomehow;
    }

    @NotNull
    public String getLocal() {
        return this.myLocal;
    }

    @Nullable
    public String getBase() {
        return this.myBase;
    }

    @NotNull
    public String getPatched() {
        return this.myPatched;
    }

    public boolean isAppliedSomehow() {
        return this.myIsAppliedSomehow;
    }

    public boolean isBaseRevisionLoaded() {
        return this.myBase != null;
    }

    @NotNull
    public static ApplyPatchForBaseRevisionTexts create(@NotNull Project project, @NotNull VirtualFile file, @NotNull FilePath pathBeforeRename, @NotNull TextFilePatch patch, @Nullable CharSequence baseContents) {
        ApplyPatchForBaseRevisionTexts result2;
        ApplyPatchForBaseRevisionTexts result3;
        assert (!patch.isNewFile());
        String localContent = ApplyPatchForBaseRevisionTexts.getLocalFileContent(file);
        if (baseContents != null && (result3 = ApplyPatchForBaseRevisionTexts.createFromStoredBase(localContent, patch, baseContents)) != null) {
            return result3;
        }
        String beforeVersionId = patch.getBeforeVersionId();
        if (beforeVersionId != null && (result2 = ApplyPatchForBaseRevisionTexts.createFromBaseVersionProvider(project, localContent, patch, beforeVersionId, file, pathBeforeRename)) != null) {
            return result2;
        }
        return ApplyPatchForBaseRevisionTexts.createFromLocal(localContent, patch);
    }

    @NotNull
    private static ApplyPatchForBaseRevisionTexts createFromLocal(@NotNull String localContent, @NotNull TextFilePatch patch) {
        GenericPatchApplier.AppliedSomehowPatch appliedPatch = GenericPatchApplier.applySomehow(localContent, patch.getHunks());
        String patchedContent = StringUtil.convertLineSeparators((String)appliedPatch.patchedText);
        return new ApplyPatchForBaseRevisionTexts(patchedContent, localContent, null, appliedPatch.isAppliedSomehow);
    }

    @Nullable
    private static ApplyPatchForBaseRevisionTexts createFromBaseVersionProvider(@NotNull Project project, @NotNull String localContent, @NotNull TextFilePatch patch, @NotNull String beforeVersionId, @NotNull VirtualFile file, @NotNull FilePath pathBeforeRename) {
        try {
            List hunks = patch.getHunks();
            Ref baseRef = new Ref();
            Ref patchedRef = new Ref();
            DefaultPatchBaseVersionProvider.getBaseVersionContent(project, beforeVersionId, file, pathBeforeRename, (Processor<? super String>)((Processor)base -> {
                GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(base, hunks);
                if (appliedPatch == null) {
                    return true;
                }
                baseRef.set(base);
                patchedRef.set((Object)StringUtil.convertLineSeparators((String)appliedPatch.patchedText));
                return false;
            }));
            String base2 = (String)baseRef.get();
            String patched = (String)patchedRef.get();
            if (base2 == null || patched == null) {
                return null;
            }
            return new ApplyPatchForBaseRevisionTexts(patched, localContent, base2, false);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ApplyPatchForBaseRevisionTexts createFromStoredBase(@NotNull String localContent, @NotNull TextFilePatch patch, @NotNull CharSequence baseContents) {
        List hunks = patch.getHunks();
        String base = baseContents.toString();
        GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(base, hunks);
        if (appliedPatch == null) {
            LOG.warn(VcsBundle.message((String)"patch.apply.wrong.base.and.can.t.be.applied.warning", (Object[])new Object[]{ObjectUtils.chooseNotNull((Object)patch.getBeforeName(), (Object)patch.getAfterName())}));
            return null;
        }
        String patched = StringUtil.convertLineSeparators((String)appliedPatch.patchedText);
        return new ApplyPatchForBaseRevisionTexts(patched, localContent, base, false);
    }

    @NotNull
    private static String getLocalFileContent(@NotNull VirtualFile file) {
        return (String)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document != null) {
                return document.getText();
            }
            return LoadTextUtil.loadText((VirtualFile)file).toString();
        });
    }
}

