/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IgnoreFile
extends PsiFileImpl {
    @NotNull
    private final Language language;
    @NotNull
    private final ParserDefinition parserDefinition;
    @NotNull
    private final IgnoreFileType fileType;

    public IgnoreFile(@NotNull FileViewProvider viewProvider, @NotNull IgnoreFileType fileType) {
        super(viewProvider);
        this.fileType = fileType;
        this.language = IgnoreFile.findLanguage(fileType.getLanguage(), viewProvider);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.language);
        if (parserDefinition == null) {
            throw new RuntimeException("IgnoreFile: language.getParserDefinition() returned null for: " + this.language);
        }
        this.parserDefinition = parserDefinition;
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        this.init((IElementType)nodeType, (IElementType)nodeType);
    }

    private static Language findLanguage(Language baseLanguage, FileViewProvider viewProvider) {
        Set languages = viewProvider.getLanguages();
        for (Language actualLanguage : languages) {
            if (!actualLanguage.isKindOf(baseLanguage) || !(actualLanguage instanceof IgnoreLanguage)) continue;
            return actualLanguage;
        }
        throw new AssertionError((Object)("Language " + baseLanguage + " doesn't participate in view provider " + viewProvider + ": " + new ArrayList(languages)));
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitFile((PsiFile)this);
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public ParserDefinition getParserDefinition() {
        return this.parserDefinition;
    }

    @NotNull
    public FileType getFileType() {
        return this.fileType;
    }

    public String toString() {
        return this.fileType.getName();
    }
}

