/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.codeInsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vcs.changes.ignore.lang.Syntax;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreSyntax;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SyntaxCompletionContributor
extends CompletionContributor {
    @NotNull
    private static final List<LookupElementBuilder> SYNTAX_ELEMENTS = new ArrayList<LookupElementBuilder>();

    public SyntaxCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)StandardPatterns.instanceOf(PsiElement.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                boolean isSyntaxSupported;
                PsiElement current = parameters.getPosition();
                Language language = parameters.getOriginalFile().getLanguage();
                boolean bl = isSyntaxSupported = language.isKindOf((Language)IgnoreLanguage.INSTANCE) && ((IgnoreLanguage)language).isSyntaxSupported();
                if (isSyntaxSupported && current.getParent() instanceof IgnoreSyntax && current.getPrevSibling() != null) {
                    result2.addAllElements((Iterable)SYNTAX_ELEMENTS);
                }
            }
        });
    }

    static {
        for (Syntax syntax : Syntax.values()) {
            SYNTAX_ELEMENTS.add(LookupElementBuilder.create((String)StringUtil.toLowerCase((String)syntax.toString())));
        }
    }
}

