/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.changes.ignore.cache.IgnorePatternsMatchedFilesCache;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Rf\u0010\u0005\u001aZ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t \b*,\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "dispose", "", "doSearch", "Lgnu/trove/THashSet;", "pattern", "Ljava/util/regex/Pattern;", "getFilesForPattern", "runSearchRequest", "key", "Companion", "intellij.platform.vcs.impl"})
public final class IgnorePatternsMatchedFilesCache
implements Disposable {
    private final ProjectFileIndex projectFileIndex;
    private final Cache<String, Collection<VirtualFile>> cache;
    private final MergingUpdateQueue updateQueue;
    private final Project project;
    public static final Companion Companion = new Companion(null);

    public void dispose() {
        this.cache.invalidateAll();
        this.updateQueue.cancelAllUpdates();
    }

    @NotNull
    public final Collection<VirtualFile> getFilesForPattern(@NotNull Pattern pattern) {
        Collection files;
        String key = pattern.toString();
        Collection collection = (Collection)this.cache.getIfPresent((Object)key);
        if (collection == null) {
            collection = files = (Collection)CollectionsKt.emptyList();
        }
        if (files.isEmpty()) {
            this.runSearchRequest(key, pattern);
        }
        return files;
    }

    private final void runSearchRequest(String key, Pattern pattern) {
        this.updateQueue.queue((Update)new DisposableUpdate(this, key, pattern, (Disposable)this.project, key){
            final /* synthetic */ IgnorePatternsMatchedFilesCache this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ Pattern $pattern;

            public boolean canEat(@NotNull Update update) {
                return true;
            }

            protected void doRun() {
                IgnorePatternsMatchedFilesCache.access$getCache$p(this.this$0).put((Object)this.$key, (Object)IgnorePatternsMatchedFilesCache.access$doSearch(this.this$0, this.$pattern));
            }
            {
                this.this$0 = this$0;
                this.$key = $captured_local_variable$1;
                this.$pattern = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        });
    }

    private final THashSet<VirtualFile> doSearch(Pattern pattern) {
        String[] parts;
        THashSet files = new THashSet(1000);
        String[] stringArray = parts = RegexUtil.getParts(pattern);
        boolean bl = false;
        if (stringArray.length == 0) {
            return files;
        }
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.project);
        this.projectFileIndex.iterateContent(new ContentIterator(this, parts, projectScope, files){
            final /* synthetic */ IgnorePatternsMatchedFilesCache this$0;
            final /* synthetic */ String[] $parts;
            final /* synthetic */ GlobalSearchScope $projectScope;
            final /* synthetic */ THashSet $files;

            public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                ProgressManager.checkCanceled();
                String name = fileOrDir.getName();
                if (RegexUtil.matchAnyPart(this.$parts, name)) {
                    boolean $i$f$runReadAction = false;
                    for (VirtualFile file : (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this, name){
                        final /* synthetic */ doSearch.1 this$0;
                        final /* synthetic */ String $name$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$name$inlined = string;
                        }

                        public final T compute() {
                            boolean bl = false;
                            return (T)FilenameIndex.getVirtualFilesByName((Project)IgnorePatternsMatchedFilesCache.access$getProject$p(this.this$0.this$0), (String)this.$name$inlined, (GlobalSearchScope)this.this$0.$projectScope);
                        }
                    })) {
                        if (!file.isValid() || !RegexUtil.matchAllParts(this.$parts, file.getPath())) continue;
                        this.$files.add((Object)file);
                    }
                }
                return true;
            }
            {
                this.this$0 = ignorePatternsMatchedFilesCache;
                this.$parts = stringArray;
                this.$projectScope = globalSearchScope;
                this.$files = tHashSet;
            }
        });
        return files;
    }

    public IgnorePatternsMatchedFilesCache(@NotNull Project project) {
        this.project = project;
        this.projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        this.updateQueue = new MergingUpdateQueue("IgnorePatternsMatchedFilesCacheUpdateQueue", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (cache.size() == 0L) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileCopyEvent) {
                        this.cleanupCache(vFileEvent.getPath());
                        continue;
                    }
                    if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                        this.cleanupCache(((VFilePropertyChangeEvent)vFileEvent).getOldPath());
                        this.cleanupCache(((VFilePropertyChangeEvent)vFileEvent).getPath());
                        continue;
                    }
                    if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                    this.cleanupCache(((VFileMoveEvent)vFileEvent).getOldPath());
                    this.cleanupCache(((VFileMoveEvent)vFileEvent).getPath());
                }
            }

            private final void cleanupCache(String path2) {
                ConcurrentMap cacheMap = cache.asMap();
                PatternCache globCache = PatternCache.getInstance(project);
                for (String key : cacheMap.keySet()) {
                    Pattern pattern;
                    if (globCache.getPattern(key) == null) {
                        continue;
                    }
                    String[] parts = RegexUtil.getParts(pattern);
                    if (!RegexUtil.matchAnyPart(parts, path2)) continue;
                    cacheMap.remove(key);
                }
            }
        });
    }

    public static final /* synthetic */ THashSet access$doSearch(IgnorePatternsMatchedFilesCache $this, Pattern pattern) {
        return $this.doSearch(pattern);
    }

    @JvmStatic
    @NotNull
    public static final IgnorePatternsMatchedFilesCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IgnorePatternsMatchedFilesCache getInstance(@NotNull Project project) {
            return (IgnorePatternsMatchedFilesCache)ServiceManager.getService((Project)project, IgnorePatternsMatchedFilesCache.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

