/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileGenerator;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.vcsUtil.VcsImplUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredFileGeneratorImpl
implements IgnoredFileGenerator {
    private static final Logger LOG = Logger.getInstance(IgnoredFileGeneratorImpl.class);
    private final Project myProject;
    private final Object myWriteLock = new Object();
    private static final Object myNotificationLock = new Object();
    @Nullable
    private static Notification myNotification;
    @Nullable
    private static VirtualFile myIgnoreFileRootNotificationShowFor;

    protected IgnoredFileGeneratorImpl(@NotNull Project project) {
        this.myProject = project;
    }

    public void generateFile(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs, boolean notify) {
        this.doGenerate(ignoreFileRoot, vcs, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGenerate(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs, boolean notify) {
        if (this.skipGeneration(ignoreFileRoot, notify)) {
            return;
        }
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoredFileContentProvider == null) {
            LOG.debug("Cannot find content provider for vcs " + vcs.getName());
            return;
        }
        String ignoreFileName = ignoredFileContentProvider.getFileName();
        Object object = this.myWriteLock;
        synchronized (object) {
            String ignoreFileContent2 = ignoredFileContentProvider.buildIgnoreFileContent(ignoreFileRoot, (IgnoredFileProvider[])IgnoredFileProvider.IGNORE_FILE.getExtensions());
            if (StringUtil.isEmptyOrSpaces((String)ignoreFileContent2)) {
                return;
            }
            File ignoreFile = IgnoredFileGeneratorImpl.getIgnoreFile(ignoreFileRoot, ignoreFileName);
            if (notify && IgnoredFileGeneratorImpl.needAskToManageIgnoreFiles(this.myProject)) {
                IgnoredFileGeneratorImpl.notifyVcsIgnoreFileManage(this.myProject, ignoreFileRoot, ignoredFileContentProvider, () -> this.writeToFile(ignoreFileRoot, ignoreFile, ignoreFileContent2, true));
            } else {
                this.writeToFile(ignoreFileRoot, ignoreFile, ignoreFileContent2, false);
            }
        }
    }

    private boolean skipGeneration(@NotNull VirtualFile ignoreFileRoot, boolean notify) {
        if (notify && !IgnoredFileGeneratorImpl.needGenerateIgnoreFile(this.myProject, ignoreFileRoot)) {
            LOG.debug("Skip VCS ignore file generation");
            return true;
        }
        if (!IgnoredFileGeneratorImpl.needGenerateInternalIgnoreFile(this.myProject, ignoreFileRoot)) {
            LOG.debug("Skip VCS internal ignore file generation");
            return true;
        }
        return false;
    }

    private void writeToFile(@NotNull VirtualFile ignoreFileRoot, @NotNull File ignoreFile, @NotNull String ignoreFileContent2, boolean openFile) {
        boolean append = ignoreFile.exists();
        String projectCharsetName = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharsetName();
        try {
            if (append) {
                FileUtil.writeToFile((File)ignoreFile, (byte[])(System.lineSeparator() + ignoreFileContent2).getBytes(projectCharsetName), (boolean)true);
            } else {
                WriteAction.runAndWait(() -> {
                    VirtualFile newIgnoreFile = ignoreFileRoot.createChildData((Object)ignoreFileRoot, ignoreFile.getName());
                    VfsUtil.saveText((VirtualFile)newIgnoreFile, (String)ignoreFileContent2);
                });
            }
        }
        catch (IOException e) {
            LOG.warn("Cannot write to file " + ignoreFile.getPath());
        }
        IgnoredFileGeneratorImpl.markIgnoreFileRootAsGenerated(this.myProject, ignoreFile.getParent());
        LocalFileSystem.getInstance().refreshIoFiles(Collections.singleton(ignoreFile));
        if (openFile) {
            this.openFile(ignoreFile);
        }
    }

    private void openFile(@NotNull File file) {
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            if (vFile == null) {
                return;
            }
            new OpenFileDescriptor(this.myProject, vFile).navigate(true);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyVcsIgnoreFileManage(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot, @NotNull IgnoredFileContentProvider ignoredFileContentProvider, @NotNull Runnable writeToIgnoreFile) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        VcsApplicationSettings applicationSettings = VcsApplicationSettings.getInstance();
        Object object = myNotificationLock;
        synchronized (object) {
            if (myNotification != null && myIgnoreFileRootNotificationShowFor != null && !myNotification.isExpired() && myIgnoreFileRootNotificationShowFor.equals(ignoreFileRoot)) {
                return;
            }
            myIgnoreFileRootNotificationShowFor = ignoreFileRoot;
            myNotification = VcsNotifier.getInstance(project).notifyMinorInfo(true, "", VcsBundle.message((String)"ignored.file.manage.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), ignoredFileContentProvider.getFileName()}), NotificationAction.create((Supplier)VcsBundle.messagePointer((String)"ignored.file.manage.this.project", (Object[])new Object[0]), (event, notification) -> {
                writeToIgnoreFile.run();
                propertiesComponent.setValue("MANAGE_IGNORE_FILES", true);
                propertiesComponent.setValue("ASKED_MANAGE_IGNORE_FILES", true);
                Object object = myNotificationLock;
                synchronized (object) {
                    notification.expire();
                    myIgnoreFileRootNotificationShowFor = null;
                }
            }), NotificationAction.create((Supplier)VcsBundle.messagePointer((String)"ignored.file.manage.all.project", (Object[])new Object[0]), (event, notification) -> {
                writeToIgnoreFile.run();
                applicationSettings.MANAGE_IGNORE_FILES = true;
                propertiesComponent.setValue("ASKED_MANAGE_IGNORE_FILES", true);
                Object object = myNotificationLock;
                synchronized (object) {
                    notification.expire();
                    myIgnoreFileRootNotificationShowFor = null;
                }
            }), NotificationAction.create((Supplier)VcsBundle.messagePointer((String)"ignored.file.manage.notmanage", (Object[])new Object[0]), (event, notification) -> {
                propertiesComponent.setValue("ASKED_MANAGE_IGNORE_FILES", true);
                Object object = myNotificationLock;
                synchronized (object) {
                    notification.expire();
                    myIgnoreFileRootNotificationShowFor = null;
                }
            }));
        }
    }

    @NotNull
    private static File getIgnoreFile(@NotNull VirtualFile ignoreFileRoot, @NotNull String ignoreFileName) {
        File vcsRootFile = VfsUtilCore.virtualToIoFile((VirtualFile)ignoreFileRoot);
        return new File(vcsRootFile.getPath(), ignoreFileName);
    }

    public static boolean needGenerateInternalIgnoreFile(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        boolean wasGeneratedPreviously = IgnoredFileRootStore.getInstance(project).containsRoot(ignoreFileRoot.getPath());
        if (wasGeneratedPreviously) {
            LOG.debug("Ignore file generated previously for root " + ignoreFileRoot.getPath());
            return false;
        }
        return true;
    }

    public static void markIgnoreFileRootAsGenerated(@NotNull Project project, @NotNull String ignoreFileRoot) {
        IgnoredFileRootStore.getInstance(project).addRoot(ignoreFileRoot);
    }

    private static boolean needGenerateIgnoreFile(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        VcsApplicationSettings vcsApplicationSettings = VcsApplicationSettings.getInstance();
        if (vcsApplicationSettings.DISABLE_MANAGE_IGNORE_FILES) {
            return false;
        }
        boolean wasGeneratedPreviously = IgnoredFileRootStore.getInstance(project).containsRoot(ignoreFileRoot.getPath());
        if (wasGeneratedPreviously) {
            LOG.debug("Ignore file generated previously for root " + ignoreFileRoot.getPath());
            return false;
        }
        boolean needGenerateRegistryFlag = Registry.is((String)"vcs.ignorefile.generation", (boolean)true);
        if (!needGenerateRegistryFlag) {
            return false;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        boolean askedToManageIgnores = propertiesComponent.getBoolean("ASKED_MANAGE_IGNORE_FILES", false);
        return IgnoredFileGeneratorImpl.isManageIgnoreTurnOn(project) || !askedToManageIgnores;
    }

    private static boolean isManageIgnoreTurnOn(@NotNull Project project) {
        boolean globalManageIgnores = VcsApplicationSettings.getInstance().MANAGE_IGNORE_FILES;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        boolean manageIgnoresInProject = propertiesComponent.getBoolean("MANAGE_IGNORE_FILES", false);
        return globalManageIgnores || manageIgnoresInProject;
    }

    private static boolean needAskToManageIgnoreFiles(@NotNull Project project) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        boolean askedToManageIgnores = propertiesComponent.getBoolean("ASKED_MANAGE_IGNORE_FILES", false);
        return !askedToManageIgnores && !IgnoredFileGeneratorImpl.isManageIgnoreTurnOn(project);
    }

    @com.intellij.openapi.components.State(name="IgnoredFileRootStore", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
    static class IgnoredFileRootStore
    implements PersistentStateComponent<State> {
        State myState = new State();

        IgnoredFileRootStore() {
        }

        static IgnoredFileRootStore getInstance(Project project) {
            return (IgnoredFileRootStore)ServiceManager.getService((Project)project, IgnoredFileRootStore.class);
        }

        boolean containsRoot(@NotNull String root) {
            return this.myState.generatedRoots.contains(root);
        }

        void addRoot(@NotNull String root) {
            this.myState.generatedRoots.add(root);
        }

        @Nullable
        public State getState() {
            return this.myState;
        }

        public void loadState(@NotNull State state) {
            this.myState = state;
        }

        static class State {
            public Set<String> generatedRoots = new HashSet<String>();

            State() {
            }
        }
    }
}

