/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.DateChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SelectGroupingAction
extends LabeledComboBoxAction
implements DumbAware {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommittedChangesTreeBrowser myBrowser;

    public SelectGroupingAction(@NotNull Project project, @NotNull CommittedChangesTreeBrowser browser2) {
        super(VcsBundle.message((String)"committed.changes.group.title", (Object[])new Object[0]));
        this.myProject = project;
        this.myBrowser = browser2;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setText(this.myBrowser.getGroupingStrategy().toString());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        return new DefaultActionGroup(ContainerUtil.map(this.collectStrategies(), (Function)((NotNullFunction)strategy -> new SetGroupingAction((ChangeListGroupingStrategy)strategy))));
    }

    @NotNull
    protected Condition<AnAction> getPreselectCondition() {
        return action -> ((SetGroupingAction)((Object)action)).myStrategy.equals(this.myBrowser.getGroupingStrategy());
    }

    @NotNull
    private List<ChangeListGroupingStrategy> collectStrategies() {
        ArrayList<ChangeListGroupingStrategy> result2 = new ArrayList<ChangeListGroupingStrategy>();
        result2.add(new DateChangeListGroupingStrategy());
        result2.add(ChangeListGroupingStrategy.USER);
        for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (provider == null) continue;
            for (ChangeListColumn column : provider.getColumns()) {
                if (!ChangeListColumn.isCustom((ChangeListColumn)column) || column.getComparator() == null) continue;
                result2.add(new CustomChangeListColumnGroupingStrategy(column));
            }
        }
        return result2;
    }

    private static class CustomChangeListColumnGroupingStrategy
    implements ChangeListGroupingStrategy {
        @NotNull
        private final ChangeListColumn<CommittedChangeList> myColumn;

        private CustomChangeListColumnGroupingStrategy(@NotNull ChangeListColumn column) {
            this.myColumn = column;
        }

        @Override
        public void beforeStart() {
        }

        @Override
        public boolean changedSinceApply() {
            return false;
        }

        @Override
        public String getGroupName(@NotNull CommittedChangeList changeList) {
            Object value = this.myColumn.getValue((ChangeList)changeList);
            return value != null ? value.toString() : null;
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return this.myColumn.getComparator();
        }

        public String toString() {
            return this.myColumn.getTitle();
        }
    }

    private class SetGroupingAction
    extends DumbAwareAction {
        @NotNull
        private final ChangeListGroupingStrategy myStrategy;

        private SetGroupingAction(ChangeListGroupingStrategy strategy) {
            super(strategy.toString());
            this.myStrategy = strategy;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SelectGroupingAction.this.myBrowser.setGroupingStrategy(this.myStrategy);
        }
    }
}

