/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.google.common.collect.Iterables;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CommittedListsSequencesZipper {
    @NotNull
    private final VcsCommittedListsZipper myVcsPartner;
    @NotNull
    private final List<RepositoryLocation> myInLocations;
    @NotNull
    private final Map<String, List<? extends CommittedChangeList>> myInLists;
    @NotNull
    private final Comparator<CommittedChangeList> myComparator;

    public CommittedListsSequencesZipper(@NotNull VcsCommittedListsZipper vcsPartner) {
        this.myVcsPartner = vcsPartner;
        this.myInLocations = new ArrayList<RepositoryLocation>();
        this.myInLists = new HashMap<String, List<? extends CommittedChangeList>>();
        this.myComparator = (o1, o2) -> Comparing.compare((long)this.myVcsPartner.getNumber(o1), (long)this.myVcsPartner.getNumber(o2));
    }

    public void add(@NotNull RepositoryLocation location, @NotNull List<? extends CommittedChangeList> lists) {
        this.myInLocations.add(location);
        lists.sort(this.myComparator);
        this.myInLists.put(location.toPresentableString(), lists);
    }

    @NotNull
    public List<CommittedChangeList> execute() {
        Pair groupingResult = this.myVcsPartner.groupLocations(this.myInLocations);
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        result2.addAll(ContainerUtil.flatten(this.collectChangeLists((List)groupingResult.getSecond())));
        for (RepositoryLocationGroup group : (List)groupingResult.getFirst()) {
            result2.addAll(this.mergeLocationGroupChangeLists(group));
        }
        return result2;
    }

    @NotNull
    private List<List<? extends CommittedChangeList>> collectChangeLists(@NotNull List<? extends RepositoryLocation> locations) {
        ArrayList<List<? extends CommittedChangeList>> result2 = new ArrayList<List<? extends CommittedChangeList>>(locations.size());
        for (RepositoryLocation repositoryLocation : locations) {
            result2.add(this.myInLists.get(repositoryLocation.toPresentableString()));
        }
        return result2;
    }

    @NotNull
    private List<CommittedChangeList> mergeLocationGroupChangeLists(@NotNull RepositoryLocationGroup group) {
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        ArrayList<CommittedChangeList> equalLists = new ArrayList<CommittedChangeList>();
        CommittedChangeList previousList = null;
        for (CommittedChangeList list : Iterables.mergeSorted(this.collectChangeLists(group.getLocations()), this.myComparator)) {
            if (previousList != null && this.myComparator.compare(previousList, list) != 0) {
                result2.add(this.zip(group, equalLists));
                equalLists.clear();
            }
            equalLists.add(list);
            previousList = list;
        }
        if (!equalLists.isEmpty()) {
            result2.add(this.zip(group, equalLists));
        }
        return result2;
    }

    @NotNull
    private CommittedChangeList zip(@NotNull RepositoryLocationGroup group, @NotNull List<? extends CommittedChangeList> equalLists) {
        if (equalLists.isEmpty()) {
            throw new IllegalArgumentException("equalLists can not be empty");
        }
        return equalLists.size() > 1 ? this.myVcsPartner.zip(group, equalLists) : equalLists.get(0);
    }
}

