/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.impl.DiffToolSubstitutor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.tools.simple.SimpleDiffTool;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.SimpleLocalChangeListDiffViewer;
import com.intellij.openapi.vcs.changes.actions.diff.lst.UnifiedLocalChangeListDiffViewer;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalChangeListDiffTool {
    public static final Key<Boolean> ALLOW_EXCLUDE_FROM_COMMIT = Key.create((String)"Diff.LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT");

    private static abstract class Base
    implements FrameDiffTool,
    DiffToolSubstitutor {
        @NotNull
        private final FrameDiffTool myReplacement;

        protected Base(@NotNull FrameDiffTool replacement) {
            this.myReplacement = replacement;
        }

        public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
            if (!(request instanceof LocalChangeListDiffRequest)) {
                return false;
            }
            LocalChangeListDiffRequest localRequest = (LocalChangeListDiffRequest)request;
            return localRequest.getLineStatusTracker() instanceof PartialLocalLineStatusTracker;
        }

        @NotNull
        public String getName() {
            return this.myReplacement.getName();
        }

        @Nullable
        public DiffTool getReplacement(@NotNull DiffTool tool, @NotNull DiffContext context, @NotNull DiffRequest request) {
            if (tool != this.myReplacement) {
                return null;
            }
            if (!this.canShow(context, request)) {
                return null;
            }
            return this;
        }
    }

    public static class Unified
    extends Base {
        public Unified() {
            super((FrameDiffTool)UnifiedDiffTool.INSTANCE);
        }

        @NotNull
        public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
            return new UnifiedLocalChangeListDiffViewer(context, (LocalChangeListDiffRequest)request);
        }
    }

    public static class Simple
    extends Base {
        public Simple() {
            super((FrameDiffTool)SimpleDiffTool.INSTANCE);
        }

        @NotNull
        public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
            return new SimpleLocalChangeListDiffViewer(context, (LocalChangeListDiffRequest)request);
        }
    }
}

