/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.RollbackDeletionAction;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackAction
extends AnAction
implements DumbAware,
UpdateInBackground {
    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean visible = project != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
        e.getPresentation().setEnabledAndVisible(visible);
        if (!visible) {
            return;
        }
        Change[] leadSelection = (Change[])e.getData(VcsDataKeys.CHANGE_LEAD_SELECTION);
        boolean isEnabled = leadSelection != null && leadSelection.length > 0 || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_LOCALLY_DELETED)) || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING)) || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_SELECTED_CHANGES)) || RollbackAction.hasReversibleFiles(e) || RollbackAction.currentChangelistNotEmpty(project);
        e.getPresentation().setEnabled(isEnabled);
        String operationName = RollbackUtil.getRollbackOperationName(project);
        e.getPresentation().setText(operationName + "...");
        if (isEnabled) {
            e.getPresentation().setDescription(VcsBundle.message((String)"action.message.use.selected.changes.description", (Object[])new Object[]{UIUtil.removeMnemonic((String)operationName)}));
        }
    }

    private static boolean hasReversibleFiles(@NotNull AnActionEvent e) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)((Project)e.getRequiredData(CommonDataKeys.PROJECT)));
        HashSet modifiedWithoutEditing = new HashSet(manager.getModifiedWithoutEditing());
        return UtilKt.notNullize((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM))).anyMatch(file -> manager.haveChangesUnder(file) != ThreeState.NO || manager.isFileAffected(file) || modifiedWithoutEditing.contains(file));
    }

    private static boolean currentChangelistNotEmpty(Project project) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
        LocalChangeList list = clManager.getDefaultChangeList();
        return !list.getChanges().isEmpty();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String title2;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        String string = title2 = "ChangesViewToolbar".equals(e.getPlace()) ? null : VcsBundle.message((String)"error.cant.perform.operation.now", (Object[])new Object[]{StringUtil.removeEllipsisSuffix((String)UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project)))});
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(title2)) {
            return;
        }
        List missingFiles = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        List changes = RollbackAction.getChanges(project, e);
        LinkedHashSet<VirtualFile> modifiedWithoutEditing = RollbackAction.getModifiedWithoutEditing(e, project);
        if (modifiedWithoutEditing != null) {
            changes = ContainerUtil.filter(changes, change -> !modifiedWithoutEditing.contains(change.getVirtualFile()));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        boolean hasChanges = false;
        if (missingFiles != null && !missingFiles.isEmpty()) {
            hasChanges = true;
            new RollbackDeletionAction().actionPerformed(e);
        }
        if (modifiedWithoutEditing != null && !modifiedWithoutEditing.isEmpty()) {
            hasChanges = true;
            RollbackAction.rollbackModifiedWithoutEditing(project, modifiedWithoutEditing);
        }
        if (!changes.isEmpty()) {
            RollbackChangesDialog.rollbackChanges(project, changes);
        } else if (!hasChanges) {
            LocalChangeList currentChangeList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
            RollbackChangesDialog.rollbackChanges(project, currentChangeList);
        }
    }

    @NotNull
    private static List<Change> getChanges(Project project, AnActionEvent e) {
        VirtualFile[] files;
        Object[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes == null && (files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
            ChangeListManager clManager = ChangeListManager.getInstance((Project)project);
            ArrayList changesList = new ArrayList();
            for (VirtualFile vf : files) {
                changesList.addAll(clManager.getChangesIn(vf));
            }
            if (!changesList.isEmpty()) {
                changes = changesList.toArray(new Change[0]);
            }
        }
        if (changes != null && changes.length > 0) {
            return ContainerUtil.newArrayList((Object[])changes);
        }
        return Collections.emptyList();
    }

    @Nullable
    private static LinkedHashSet<VirtualFile> getModifiedWithoutEditing(AnActionEvent e, Project project) {
        List modifiedWithoutEditing = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        if (modifiedWithoutEditing != null && modifiedWithoutEditing.size() > 0) {
            return new LinkedHashSet<VirtualFile>(modifiedWithoutEditing);
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFiles != null && virtualFiles.length > 0) {
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>(Arrays.asList(virtualFiles));
            result2.retainAll(ChangeListManager.getInstance((Project)project).getModifiedWithoutEditing());
            return result2;
        }
        return null;
    }

    private static void rollbackModifiedWithoutEditing(Project project, LinkedHashSet<VirtualFile> modifiedWithoutEditing) {
        String operationName = StringUtil.decapitalize((String)UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project)));
        String message = modifiedWithoutEditing.size() == 1 ? VcsBundle.message((String)"rollback.modified.without.editing.confirm.single", (Object[])new Object[]{operationName, ((VirtualFile)modifiedWithoutEditing.iterator().next()).getPresentableUrl()}) : VcsBundle.message((String)"rollback.modified.without.editing.confirm.multiple", (Object[])new Object[]{operationName, modifiedWithoutEditing.size()});
        int rc = Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.action.rollback.title", (Object[])new Object[]{operationName}), (Icon)Messages.getQuestionIcon());
        if (rc != 0) {
            return;
        }
        ArrayList exceptions = new ArrayList();
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action = () -> {
            ProgressIndicator indicator = progressManager.getProgressIndicator();
            try {
                ChangesUtil.processVirtualFilesByVcs((Project)project, (Collection)modifiedWithoutEditing, (vcs, items) -> {
                    RollbackEnvironment rollbackEnvironment = vcs.getRollbackEnvironment();
                    if (rollbackEnvironment != null) {
                        if (indicator != null) {
                            indicator.setText(VcsBundle.message((String)"progress.text.performing", (Object[])new Object[]{vcs.getDisplayName(), StringUtil.toLowerCase((String)UIUtil.removeMnemonic((String)rollbackEnvironment.getRollbackOperationName()))}));
                            indicator.setIndeterminate(false);
                        }
                        rollbackEnvironment.rollbackModifiedWithoutCheckout(items, exceptions, (RollbackProgressListener)new RollbackProgressModifier(items.size(), indicator));
                        if (indicator != null) {
                            indicator.setText2("");
                        }
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (!exceptions.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, VcsBundle.message((String)"rollback.modified.without.checkout.error.tab", (Object[])new Object[]{operationName}));
            }
            VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)modifiedWithoutEditing));
            VirtualFileManager.getInstance().asyncRefresh(() -> {
                for (VirtualFile virtualFile : modifiedWithoutEditing) {
                    VcsDirtyScopeManager.getInstance((Project)project).fileDirty(virtualFile);
                }
            });
        };
        progressManager.runProcessWithProgressSynchronously(action, operationName, true, project);
    }
}

