/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class Waiter
extends Task.Modal {
    private static final Logger LOG = Logger.getInstance(Waiter.class);
    @NotNull
    private final Runnable myRunnable;
    @NotNull
    private final AtomicBoolean myStarted = new AtomicBoolean();
    @NotNull
    private final Semaphore mySemaphore = new Semaphore();

    public Waiter(@NotNull Project project, @NotNull Runnable runnable, String title2, boolean cancellable) {
        super(project, VcsBundle.message((String)"change.list.manager.wait.lists.synchronization", (Object[])new Object[]{title2}), cancellable);
        this.myRunnable = runnable;
        this.mySemaphore.down();
        this.setCancelText(VcsBundle.message((String)"button.skip", (Object[])new Object[0]));
    }

    public void run(@NotNull ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        indicator.setText2(VcsBundle.message((String)"commit.wait.util.synched.text", (Object[])new Object[0]));
        if (!this.myStarted.compareAndSet(false, true)) {
            LOG.error("Waiter running under progress being started again.");
        } else {
            ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)this.mySemaphore, (ProgressIndicator)indicator);
        }
    }

    public void onCancel() {
        this.onSuccess();
    }

    public void onSuccess() {
        if (!this.myProject.isDisposed()) {
            this.myRunnable.run();
            ChangesViewManager.getInstance(this.myProject).scheduleRefresh();
        }
    }

    public void done() {
        this.mySemaphore.up();
    }
}

