/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.VcsIgnoreFilesChecker;
import com.intellij.openapi.vcs.changes.VcsIgnoreFilesCheckerKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0013\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n*\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreFilesChecker;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "()V", "generateVcsIgnoreFileInRootIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "projectOpened", "getProjectConfigDirOrProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "intellij.platform.vcs.impl"})
public final class VcsIgnoreFilesChecker
implements ProjectManagerListener {
    public void projectOpened(@NotNull Project project) {
        project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(this, project){
            final /* synthetic */ VcsIgnoreFilesChecker this$0;
            final /* synthetic */ Project $project;

            public final void directoryMappingChanged() {
                ProjectLevelVcsManager.getInstance((Project)this.$project).runAfterInitialization(new Runnable(this){
                    final /* synthetic */ projectOpened.1 this$0;

                    public final void run() {
                        BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)this.this$0.$project), (Runnable)new Runnable(this){
                            final /* synthetic */ projectOpened.1 this$0;

                            public final void run() {
                                VcsIgnoreFilesChecker.access$generateVcsIgnoreFileInRootIfNeeded(this.this$0.this$0.this$0, this.this$0.this$0.$project);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = vcsIgnoreFilesChecker;
                this.$project = project;
            }
        });
    }

    private final void generateVcsIgnoreFileInRootIfNeeded(Project project) {
        if (project.isDisposed()) {
            return;
        }
        VirtualFile virtualFile = this.getProjectConfigDirOrProjectFile(project);
        if (virtualFile == null) {
            return;
        }
        VirtualFile projectFile = virtualFile;
        VirtualFile virtualFile2 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFile);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile projectFileVcsRoot = virtualFile2;
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)projectFileVcsRoot);
        if (abstractVcs == null) {
            return;
        }
        AbstractVcs vcs = abstractVcs;
        VcsIgnoreFilesCheckerKt.access$getLOG$p().debug("Propose manage VCS ignore in " + projectFileVcsRoot.getPath() + " for vcs " + vcs.getName());
        VcsImplUtil.proposeUpdateIgnoreFile(project, vcs, projectFileVcsRoot);
    }

    private final VirtualFile getProjectConfigDirOrProjectFile(Project $this$getProjectConfigDirOrProjectFile) {
        VirtualFile virtualFile;
        if (ProjectKt.isDirectoryBased((Project)$this$getProjectConfigDirOrProjectFile)) {
            String string = ProjectKt.getStateStore((Project)$this$getProjectConfigDirOrProjectFile).getProjectConfigDir();
            if (string != null) {
                String string2 = string;
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string2;
                boolean bl3 = false;
                virtualFile = localFileSystem.findFileByPath(p1);
            } else {
                virtualFile = null;
            }
        } else {
            virtualFile = $this$getProjectConfigDirOrProjectFile.getProjectFile();
        }
        return virtualFile;
    }

    public static final /* synthetic */ void access$generateVcsIgnoreFileInRootIfNeeded(VcsIgnoreFilesChecker $this, Project project) {
        $this.generateVcsIgnoreFileInRootIfNeeded(project);
    }
}

